/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.data.fastlanereader.report;

import com.healthmarketscience.sqlbuilder.ComboCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.InCondition;
import com.healthmarketscience.sqlbuilder.SelectQuery;
import com.healthmarketscience.sqlbuilder.SetOperationQuery;
import com.healthmarketscience.sqlbuilder.Subquery;
import com.healthmarketscience.sqlbuilder.UnaryCondition;
import com.healthmarketscience.sqlbuilder.UnionQuery;
import com.healthmarketscience.sqlbuilder.dbspec.Column;
import com.healthmarketscience.sqlbuilder.dbspec.Table;
import de.proveo.util.database.DatabaseType;
import de.proveo.wwt.logic.app.util.Stopwatch;
import de.proveo.wwt.logic.web.common.dataSelection.OperatorReportSelectionDTO;
import de.proveo.wwt.logic.web.common.dataSelection.ReportSelectionDTO;
import de.proveo.wwt.logic.web.common.dataSelection.UnitReportSelectionDTO;
import de.proveo.wwt.logic.web.common.dataSelection.filter.IUnitFilter;
import de.proveo.wwt.logic.web.common.dto.DTOListBase;
import de.proveo.wwt.logic.web.common.dto.ReportDTOBase;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import de.proveo.wwt.logic.web.data.enumerations.FastLaneReaderOrder;
import de.proveo.wwt.logic.web.data.fastlanereader.base.FastLaneReader;
import de.proveo.wwt.logic.web.data.fastlanereader.base.ReportFastLaneBase;
import de.proveo.wwt.logic.web.data.query.definitions.UnitDefinitions;
import de.proveo.wwt.logic.web.data.query.definitions.UseUserDefinitions;
import de.proveo.wwt.logic.web.data.query.interfaces.IOperatorTable;
import de.proveo.wwt.logic.web.data.query.interfaces.IReportTableDefinitions;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ReportFastLaneReader<T extends ReportDTOBase, D extends IReportTableDefinitions>
extends ReportFastLaneBase {
    protected static final Log log = LogFactory.getLog(ReportFastLaneReader.class);
    protected D definitions;
    protected DTOListBase<T> dataList;
    protected ReportSelectionDTO selectionDTO;
    protected SelectQuery cacheQuery;
    protected SelectQuery historyQuery;
    protected FastLaneReaderOrder order = FastLaneReaderOrder.ByNothing;
    protected Integer reportMaxRowLimit;

    protected ReportFastLaneReader(D definitions) {
        this.definitions = definitions;
    }

    protected void init(DTOListBase<T> dataList, ReportSelectionDTO selectionDTO, FastLaneReaderOrder order) {
        if (dataList != null) {
            this.dataList = dataList;
        }
        if (selectionDTO != null) {
            this.selectionDTO = selectionDTO;
        }
        if (order != null) {
            this.order = order;
        }
        if (selectionDTO.getEndTime() != null && selectionDTO.getEndTime() > System.currentTimeMillis()) {
            log.debug((Object)"Setting end time of fastlanereader to current time");
            this.selectionDTO.setEndTime(System.currentTimeMillis());
        }
    }

    protected abstract D getDefinitions();

    protected abstract void addTimeConditions();

    protected abstract void addCustomConditions();

    protected abstract void addExtendedDataColumns();

    protected abstract int getCache(ResultSet var1) throws SQLException;

    protected abstract int getHistory(ResultSet var1) throws SQLException;

    protected void initQuerys() {
        this.prepareCacheColumns();
        this.prepareHistoryColumns();
        this.addExtendedDataColumns();
        this.addUnitConditions();
        this.addOperatorConditions();
        this.addTimeConditions();
        this.addCustomConditions();
    }

    protected String generateSql(boolean cache) {
        this.initQuerys();
        if (cache) {
            this.cacheQuery.addCustomOrderings(new Object[]{"unit_id"});
            return ((SelectQuery)this.cacheQuery.validate()).toString();
        }
        UnionQuery unionQuery = new UnionQuery(SetOperationQuery.Type.UNION, new SelectQuery[]{this.historyQuery, this.cacheQuery});
        this.addOrder(unionQuery);
        return ((UnionQuery)unionQuery.validate()).toString();
    }

    protected String generateSql(boolean cache, int maxRowsLimit) {
        this.reportMaxRowLimit = maxRowsLimit;
        String unionQuery = this.generateSql(cache);
        if (maxRowsLimit != 0) {
            switch (this.databaseType) {
                case MSSQL: {
                    unionQuery = unionQuery.replaceFirst("SELECT DISTINCT", "SELECT DISTINCT TOP " + maxRowsLimit);
                    break;
                }
                case MySQL: {
                    unionQuery = unionQuery.replace("UNION", "LIMIT " + maxRowsLimit + " UNION");
                    break;
                }
                case Oracle: {
                    unionQuery = unionQuery.replaceFirst("WHERE", "WHERE ROWNUM <= " + maxRowsLimit + " AND");
                }
            }
        }
        return unionQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getData(String sql, boolean cache) {
        log.debug((Object)"reportFastLaneReader called");
        Stopwatch stopwatch = new Stopwatch(FastLaneReader.class, "reportFastLaneReader");
        stopwatch.start("Overall");
        Connection connection = null;
        Statement statement = null;
        try {
            stopwatch.start("Database access");
            connection = this.getConnection();
            statement = this.createReadOnlyForwardOnlyStatement(connection);
            log.debug((Object)("executed SQL: " + sql));
            ResultSet resultSet = statement.executeQuery(sql);
            stopwatch.stop("Database access", true);
            stopwatch.start("Build DTO");
            int dataSize = 0;
            dataSize = cache ? this.getCache(resultSet) : this.getHistory(resultSet);
            stopwatch.stop("Build DTO", true, dataSize);
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
        }
        stopwatch.stop("Overall", true);
    }

    protected void addOrder(UnionQuery unionQuery) {
        switch (this.order) {
            case ByNothing: {
                break;
            }
            case ByUnitIdAndBeginTime: {
                unionQuery.addCustomOrderings(new Object[]{"unit_id", "bt"});
                break;
            }
            case ByBeginTime: {
                unionQuery.addCustomOrderings(new Object[]{"bt"});
                break;
            }
            case ByUnitId: {
                unionQuery.addCustomOrderings(new Object[]{"unit_id"});
                break;
            }
            default: {
                throw new IllegalArgumentException("Used unsupported order argument in generateStateHistorySql()");
            }
        }
    }

    protected void addUnitConditions() {
        if (!(this.selectionDTO instanceof UnitReportSelectionDTO)) {
            return;
        }
        UnitReportSelectionDTO selectionDTO = (UnitReportSelectionDTO)this.selectionDTO;
        if (!selectionDTO.isAllSelected() && selectionDTO.getCount() > 0) {
            HashSet<Long> basicUnitIds = new HashSet<Long>();
            HashSet<Long> groupUnitIds = new HashSet<Long>();
            HashSet<Long> joinGroupUnitIds = new HashSet<Long>();
            ComboCondition comboHistory = new ComboCondition(ComboCondition.Op.OR);
            ComboCondition comboCache = new ComboCondition(ComboCondition.Op.OR);
            for (UnitDTO dto : selectionDTO.getUnitDTOs()) {
                if (dto.isBasic()) {
                    basicUnitIds.add(dto.getUnitId());
                    continue;
                }
                if (selectionDTO.isUseGroupHistory()) {
                    groupUnitIds.add(dto.getUnitId());
                    continue;
                }
                if (this.databaseType == DatabaseType.Oracle) {
                    joinGroupUnitIds.add(dto.getUnitId());
                    continue;
                }
                basicUnitIds.addAll(ReportFastLaneReader.getUnitsInGroup(dto.getUnitId()));
            }
            if (!basicUnitIds.isEmpty()) {
                comboHistory.addCondition((Condition)new InCondition((Object)this.getDefinitions().getHelperUnitIdColumn(), basicUnitIds));
                comboCache.addCondition((Condition)new InCondition((Object)this.getDefinitions().getCacheUnitIdColumn(), basicUnitIds));
            }
            if (!groupUnitIds.isEmpty()) {
                InCondition groupHistoryCondition = new InCondition((Object)UnitDefinitions.col_GroupHistoryXUnitModel_UnitGroupId, groupUnitIds);
                this.historyQuery.addJoin(SelectQuery.JoinType.LEFT_OUTER, (Table)this.getDefinitions().getHelperTable(), (Table)UnitDefinitions.tbl_GroupHistory, (Column)this.getDefinitions().getHelperGroupHistoryColumn(), (Column)UnitDefinitions.col_GroupHistory_Id);
                this.historyQuery.addJoin(SelectQuery.JoinType.LEFT_OUTER, (Table)UnitDefinitions.tbl_GroupHistory, (Table)UnitDefinitions.tbl_GroupHistoryXUnitModel, (Column)UnitDefinitions.col_GroupHistory_Id, (Column)UnitDefinitions.col_GroupHistoryXUnitModel_Id);
                comboHistory.addCondition((Condition)groupHistoryCondition);
                this.cacheQuery.addJoin(SelectQuery.JoinType.LEFT_OUTER, (Table)this.getDefinitions().getCacheTable(), (Table)UnitDefinitions.tbl_GroupHistory, (Column)this.getDefinitions().getCacheGroupHistoryColumn(), (Column)UnitDefinitions.col_GroupHistory_Id);
                this.cacheQuery.addJoin(SelectQuery.JoinType.LEFT_OUTER, (Table)UnitDefinitions.tbl_GroupHistory, (Table)UnitDefinitions.tbl_GroupHistoryXUnitModel, (Column)UnitDefinitions.col_GroupHistory_Id, (Column)UnitDefinitions.col_GroupHistoryXUnitModel_Id);
                comboCache.addCondition((Condition)groupHistoryCondition);
            }
            if (!joinGroupUnitIds.isEmpty()) {
                SelectQuery subSelect = new SelectQuery();
                subSelect.addColumns(new Column[]{UnitDefinitions.col_UnitModelXUnitModel_UnitId});
                subSelect.addCondition((Condition)new InCondition((Object)UnitDefinitions.col_UnitModelXUnitModel_GroupId, joinGroupUnitIds));
                Subquery subQuery = new Subquery((Object)subSelect);
                comboHistory.addCondition((Condition)new InCondition((Object)this.getDefinitions().getHelperUnitIdColumn(), new Object[]{subQuery}));
                comboCache.addCondition((Condition)new InCondition((Object)this.getDefinitions().getCacheUnitIdColumn(), new Object[]{subQuery}));
            }
            this.historyQuery.addCondition((Condition)comboHistory);
            this.cacheQuery.addCondition((Condition)comboCache);
        }
        if (!selectionDTO.getUnitFilters().isEmpty()) {
            this.historyQuery.addJoin(SelectQuery.JoinType.LEFT_OUTER, (Table)this.getDefinitions().getHelperTable(), (Table)UnitDefinitions.tbl_UnitModel, (Column)this.getDefinitions().getHelperUnitIdColumn(), (Column)UnitDefinitions.col_UnitModel_UnitId);
            this.cacheQuery.addJoin(SelectQuery.JoinType.LEFT_OUTER, (Table)this.getDefinitions().getCacheTable(), (Table)UnitDefinitions.tbl_UnitModel, (Column)this.getDefinitions().getCacheUnitIdColumn(), (Column)UnitDefinitions.col_UnitModel_UnitId);
            for (IUnitFilter filter : selectionDTO.getUnitFilters()) {
                InCondition condition = new InCondition((Object)filter.getColumn(), filter.getObjects());
                this.historyQuery.addCondition((Condition)condition);
                this.cacheQuery.addCondition((Condition)condition);
            }
        }
    }

    protected void addOperatorConditions() {
        if (!(this.getDefinitions() instanceof IOperatorTable)) {
            return;
        }
        IOperatorTable definitions = (IOperatorTable)this.getDefinitions();
        if (!(this.selectionDTO instanceof OperatorReportSelectionDTO)) {
            return;
        }
        OperatorReportSelectionDTO selectionDTO = (OperatorReportSelectionDTO)this.selectionDTO;
        if (selectionDTO.getCount() > 0) {
            if (selectionDTO.isAllSelected()) {
                this.historyQuery.addCondition((Condition)new UnaryCondition(UnaryCondition.Op.IS_NOT_NULL, (Object)definitions.getHistoryUseUserIdColumn()));
                this.cacheQuery.addCondition((Condition)new UnaryCondition(UnaryCondition.Op.IS_NOT_NULL, (Object)definitions.getCacheUseUserIdColumn()));
            } else {
                HashSet<Long> basicIds = new HashSet<Long>();
                basicIds.addAll(Arrays.asList(selectionDTO.getOperatorIds()));
                HashSet<Long> groupIds = new HashSet<Long>();
                groupIds.addAll(Arrays.asList(selectionDTO.getOperatorGroupIds()));
                ComboCondition comboHistory = new ComboCondition(ComboCondition.Op.OR);
                ComboCondition comboCache = new ComboCondition(ComboCondition.Op.OR);
                if (!basicIds.isEmpty()) {
                    comboHistory.addCondition((Condition)new InCondition((Object)definitions.getHistoryUseUserIdColumn(), basicIds));
                    comboCache.addCondition((Condition)new InCondition((Object)definitions.getCacheUseUserIdColumn(), basicIds));
                }
                if (!groupIds.isEmpty()) {
                    InCondition groupHistoryCondition = new InCondition((Object)UseUserDefinitions.col_UseUserXUseGroup_UseGroupId, groupIds);
                    this.historyQuery.addJoin(SelectQuery.JoinType.INNER, (Table)this.getDefinitions().getHistoryTable(), (Table)UseUserDefinitions.tbl_UseUser, (Column)definitions.getHistoryUseUserIdColumn(), (Column)UseUserDefinitions.col_UseUser_Id);
                    this.historyQuery.addJoin(SelectQuery.JoinType.LEFT_OUTER, (Table)UseUserDefinitions.tbl_UseUser, (Table)UseUserDefinitions.tbl_UseUserXUseGroup, (Column)UseUserDefinitions.col_UseUser_Id, (Column)UseUserDefinitions.col_UseUserXUseGroup_UseUserId);
                    comboHistory.addCondition((Condition)groupHistoryCondition);
                    this.cacheQuery.addJoin(SelectQuery.JoinType.INNER, (Table)this.getDefinitions().getCacheTable(), (Table)UseUserDefinitions.tbl_UseUser, (Column)definitions.getCacheUseUserIdColumn(), (Column)UseUserDefinitions.col_UseUser_Id);
                    this.cacheQuery.addJoin(SelectQuery.JoinType.LEFT_OUTER, (Table)UseUserDefinitions.tbl_UseUser, (Table)UseUserDefinitions.tbl_UseUserXUseGroup, (Column)UseUserDefinitions.col_UseUser_Id, (Column)UseUserDefinitions.col_UseUserXUseGroup_UseUserId);
                    comboCache.addCondition((Condition)groupHistoryCondition);
                }
                this.historyQuery.addCondition((Condition)comboHistory);
                this.cacheQuery.addCondition((Condition)comboCache);
            }
        }
    }

    protected void prepareCacheColumns() {
        this.cacheQuery = new SelectQuery();
        this.cacheQuery.addColumns(new Column[]{this.getDefinitions().getCacheHistoryIdColumn(), this.getDefinitions().getCacheUnitIdColumn()});
    }

    protected void prepareHistoryColumns() {
        this.historyQuery = new SelectQuery(true);
        this.historyQuery.addColumns(new Column[]{this.getDefinitions().getHelperHistoryIdColumn(), this.getDefinitions().getHelperUnitIdColumn()});
    }
}

