/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.data.fastlanereader.report;

import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.dbspec.Column;
import de.proveo.wwt.datamodel.measurement.MeasurementDefinition;
import de.proveo.wwt.datamodel.measurement.MeasurementType;
import de.proveo.wwt.datamodel.measurement.MeasurementUnit;
import de.proveo.wwt.logic.web.common.dataSelection.ReportSelectionDTO;
import de.proveo.wwt.logic.web.common.dto.DTOFactory;
import de.proveo.wwt.logic.web.common.dto.DTOListBase;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import de.proveo.wwt.logic.web.data.enumerations.ExtendedDTOData;
import de.proveo.wwt.logic.web.data.enumerations.FastLaneReaderOrder;
import de.proveo.wwt.logic.web.data.fastlanereader.report.EventReportFastLaneReader;
import de.proveo.wwt.logic.web.data.fastlanereader.report.MeasurementBaseFastlaneReader;
import de.proveo.wwt.logic.web.data.query.definitions.MeasurementDefinitions;
import de.proveo.wwt.logic.web.historyData.dto.MeasurementDTO;
import java.sql.ResultSet;
import java.sql.SQLException;

public class MeasurementFastLaneReader
extends EventReportFastLaneReader<MeasurementDTO, MeasurementDefinitions> {
    protected MeasurementBaseFastlaneReader baseReader = new MeasurementBaseFastlaneReader();
    protected Integer measurementFilterId;

    public MeasurementFastLaneReader() {
        super(new MeasurementDefinitions());
    }

    public void getCache(DTOListBase<MeasurementDTO> list, Integer measurementFilterId, ReportSelectionDTO selectionDTO, ExtendedDTOData ... extendedData) {
        this.init(measurementFilterId, list, selectionDTO, FastLaneReaderOrder.ByUnitId, extendedData);
        String sql = this.generateSql(true);
        this.getData(sql, true);
    }

    public void getHistory(DTOListBase<MeasurementDTO> list, Integer measurementFilterId, ReportSelectionDTO selectionDTO, ExtendedDTOData ... extendedData) {
        this.init(measurementFilterId, list, selectionDTO, FastLaneReaderOrder.ByUnitId, extendedData);
        String sql = this.generateSql(false);
        this.getData(sql, false);
    }

    @Override
    protected void addCustomConditions() {
        if (this.measurementFilterId != null) {
            MeasurementDefinitions cfr_ignored_0 = (MeasurementDefinitions)this.getDefinitions();
            this.historyQuery.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.EQUAL_TO, (Object)MeasurementDefinitions.col_History_MeasurementDefinitionId, (Object)this.measurementFilterId));
            MeasurementDefinitions cfr_ignored_1 = (MeasurementDefinitions)this.getDefinitions();
            this.cacheQuery.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.EQUAL_TO, (Object)MeasurementDefinitions.col_Cache_MeasurementDefinitionId, (Object)this.measurementFilterId));
        }
    }

    @Override
    protected int getCache(ResultSet resultSet) throws SQLException {
        int dataSize = 0;
        int idx_id = resultSet.findColumn(((MeasurementDefinitions)this.getDefinitions()).getCacheHistoryIdColumn().getName());
        int idx_unitId = resultSet.findColumn(((MeasurementDefinitions)this.getDefinitions()).getCacheUnitIdColumn().getName());
        int idx_createTime = resultSet.findColumn(((MeasurementDefinitions)this.getDefinitions()).getCacheCreateTimeColumn().getName());
        int idx_receiveTime = resultSet.findColumn(((MeasurementDefinitions)this.getDefinitions()).getCacheReceiveTimeColumn().getName());
        MeasurementDefinitions cfr_ignored_0 = (MeasurementDefinitions)this.getDefinitions();
        int idx_value = resultSet.findColumn(MeasurementDefinitions.col_Cache_Value.getName());
        MeasurementDefinitions cfr_ignored_1 = (MeasurementDefinitions)this.getDefinitions();
        int idx_mdId = resultSet.findColumn(MeasurementDefinitions.col_Cache_MeasurementDefinitionId.getName());
        while (resultSet.next()) {
            long id = resultSet.getLong(idx_id);
            long unitId = resultSet.getLong(idx_unitId);
            long createTime = resultSet.getLong(idx_createTime);
            long receiveTime = resultSet.getLong(idx_receiveTime);
            Float value = Float.valueOf(resultSet.getFloat(idx_value));
            int mdId = resultSet.getInt(idx_mdId);
            UnitDTO unitDTO = this.getUnitDTOMap().get(unitId);
            if (unitDTO.isDeleted()) continue;
            MeasurementDefinition md = this.baseReader.getMeasurementDefinitionsMap().get(mdId);
            MeasurementUnit mu = md == null ? null : this.baseReader.getMeasurementUnitsMap().get(md.getMeasurementUnitId());
            MeasurementType mt = mu == null ? null : this.baseReader.getMeasurementTypesMap().get(mu.getMeasurementTypeId());
            MeasurementDTO dto = DTOFactory.buildMeasurementDTO(id, createTime, receiveTime, value, md, mt, mu, unitDTO);
            this.addExtendedData(true, resultSet, dto, new ExtendedDTOData[0]);
            this.dataList.add(dto);
            ++dataSize;
        }
        return dataSize;
    }

    @Override
    protected int getHistory(ResultSet resultSet) throws SQLException {
        int dataSize = 0;
        int idx_id = resultSet.findColumn(((MeasurementDefinitions)this.getDefinitions()).getHelperHistoryIdColumn().getName());
        int idx_unitId = resultSet.findColumn(((MeasurementDefinitions)this.getDefinitions()).getHelperUnitIdColumn().getName());
        int idx_createTime = resultSet.findColumn(((MeasurementDefinitions)this.getDefinitions()).getHistoryCreateTimeColumn().getName());
        int idx_receiveTime = resultSet.findColumn(((MeasurementDefinitions)this.getDefinitions()).getHistoryReceiveTimeColumn().getName());
        MeasurementDefinitions cfr_ignored_0 = (MeasurementDefinitions)this.getDefinitions();
        int idx_value = resultSet.findColumn(MeasurementDefinitions.col_History_Value.getName());
        MeasurementDefinitions cfr_ignored_1 = (MeasurementDefinitions)this.getDefinitions();
        int idx_mdId = resultSet.findColumn(MeasurementDefinitions.col_History_MeasurementDefinitionId.getName());
        while (resultSet.next()) {
            long id = resultSet.getLong(idx_id);
            long unitId = resultSet.getLong(idx_unitId);
            long createTime = resultSet.getLong(idx_createTime);
            long receiveTime = resultSet.getLong(idx_receiveTime);
            Float value = Float.valueOf(resultSet.getFloat(idx_value));
            int mdId = resultSet.getInt(idx_mdId);
            UnitDTO unitDTO = this.getUnitDTOMap().get(unitId);
            MeasurementDefinition md = this.baseReader.getMeasurementDefinitionsMap().get(mdId);
            MeasurementUnit mu = md == null ? null : this.baseReader.getMeasurementUnitsMap().get(md.getMeasurementUnitId());
            MeasurementType mt = mu == null ? null : this.baseReader.getMeasurementTypesMap().get(mu.getMeasurementTypeId());
            MeasurementDTO dto = DTOFactory.buildMeasurementDTO(id, createTime, receiveTime, value, md, mt, mu, unitDTO);
            this.addExtendedData(false, resultSet, dto, new ExtendedDTOData[0]);
            this.dataList.add(dto);
            ++dataSize;
        }
        return dataSize;
    }

    @Override
    protected void prepareHistoryColumns() {
        super.prepareHistoryColumns();
        Column[] columnArray = new Column[2];
        MeasurementDefinitions cfr_ignored_0 = (MeasurementDefinitions)this.getDefinitions();
        columnArray[0] = MeasurementDefinitions.col_History_MeasurementDefinitionId;
        MeasurementDefinitions cfr_ignored_1 = (MeasurementDefinitions)this.getDefinitions();
        columnArray[1] = MeasurementDefinitions.col_History_Value;
        this.historyQuery.addColumns(columnArray);
    }

    @Override
    protected void prepareCacheColumns() {
        super.prepareCacheColumns();
        Column[] columnArray = new Column[2];
        MeasurementDefinitions cfr_ignored_0 = (MeasurementDefinitions)this.getDefinitions();
        columnArray[0] = MeasurementDefinitions.col_Cache_MeasurementDefinitionId;
        MeasurementDefinitions cfr_ignored_1 = (MeasurementDefinitions)this.getDefinitions();
        columnArray[1] = MeasurementDefinitions.col_Cache_Value;
        this.cacheQuery.addColumns(columnArray);
    }

    protected void init(Integer measurementFilterId, DTOListBase<MeasurementDTO> dataList, ReportSelectionDTO selectionDTO, FastLaneReaderOrder order, ExtendedDTOData ... extendedData) {
        super.init(dataList, selectionDTO, order, extendedData);
        this.measurementFilterId = measurementFilterId;
    }
}

