/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.data.fastlanereader.report;

import de.proveo.wwt.logic.web.common.dataSelection.ReportSelectionDTO;
import de.proveo.wwt.logic.web.common.dto.DTOFactory;
import de.proveo.wwt.logic.web.common.dto.DTOListBase;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import de.proveo.wwt.logic.web.data.enumerations.ExtendedDTOData;
import de.proveo.wwt.logic.web.data.enumerations.FastLaneReaderOrder;
import de.proveo.wwt.logic.web.data.fastlanereader.report.EventReportFastLaneReader;
import de.proveo.wwt.logic.web.data.query.definitions.KeepaliveDefinitions;
import de.proveo.wwt.logic.web.historyData.dto.KeepAliveDTO;
import java.sql.ResultSet;
import java.sql.SQLException;

public class KeepAliveFastLaneReader
extends EventReportFastLaneReader<KeepAliveDTO, KeepaliveDefinitions> {
    public KeepAliveFastLaneReader() {
        super(new KeepaliveDefinitions());
    }

    public void getHistory(DTOListBase<KeepAliveDTO> list, Long unitId, long beginTime, long endTime, boolean useGroupHistory, ExtendedDTOData ... extendedData) {
        ReportSelectionDTO selectionDTO = this.buildUnitReportSelectionDTO(unitId, beginTime, endTime, useGroupHistory, true);
        this.init(list, selectionDTO, FastLaneReaderOrder.ByBeginTime, extendedData);
        String sql = this.generateSql(false);
        this.getData(sql, false);
    }

    public void getHistory(DTOListBase<KeepAliveDTO> list, ReportSelectionDTO selectionDTO, ExtendedDTOData ... extendedData) {
        this.init(list, selectionDTO, FastLaneReaderOrder.ByBeginTime, extendedData);
        String sql = this.generateSql(false);
        this.getData(sql, false);
    }

    public void getCache(DTOListBase<KeepAliveDTO> list, ReportSelectionDTO selectionDTO, ExtendedDTOData ... extendedData) {
        this.init(list, selectionDTO, FastLaneReaderOrder.ByUnitId, extendedData);
        String sql = this.generateSql(true);
        this.getData(sql, true);
    }

    @Override
    protected int getCache(ResultSet resultSet) throws SQLException {
        int dataSize = 0;
        int idx_id = resultSet.findColumn(((KeepaliveDefinitions)this.getDefinitions()).getCacheHistoryIdColumn().getName());
        int idx_unitId = resultSet.findColumn(((KeepaliveDefinitions)this.getDefinitions()).getCacheUnitIdColumn().getName());
        int idx_createTime = resultSet.findColumn(((KeepaliveDefinitions)this.getDefinitions()).getCacheCreateTimeColumn().getName());
        int idx_receiveTime = resultSet.findColumn(((KeepaliveDefinitions)this.getDefinitions()).getCacheReceiveTimeColumn().getName());
        while (resultSet.next()) {
            long id = resultSet.getLong(idx_id);
            long unitId = resultSet.getLong(idx_unitId);
            long createTime = resultSet.getLong(idx_createTime);
            long receiveTime = resultSet.getLong(idx_receiveTime);
            UnitDTO unitDTO = this.getUnitDTOMap().get(unitId);
            if (unitDTO.isDeleted()) continue;
            KeepAliveDTO dto = DTOFactory.buildKeepAliveDTO(id, createTime, receiveTime, null, unitDTO);
            this.addExtendedData(false, resultSet, dto, new ExtendedDTOData[0]);
            this.dataList.add(dto);
            ++dataSize;
        }
        return dataSize;
    }

    @Override
    protected int getHistory(ResultSet resultSet) throws SQLException {
        int dataSize = 0;
        int idx_id = resultSet.findColumn(((KeepaliveDefinitions)this.getDefinitions()).getHelperHistoryIdColumn().getName());
        int idx_unitId = resultSet.findColumn(((KeepaliveDefinitions)this.getDefinitions()).getHelperUnitIdColumn().getName());
        int idx_createTime = resultSet.findColumn(((KeepaliveDefinitions)this.getDefinitions()).getHistoryCreateTimeColumn().getName());
        int idx_receiveTime = resultSet.findColumn(((KeepaliveDefinitions)this.getDefinitions()).getHistoryReceiveTimeColumn().getName());
        while (resultSet.next()) {
            long id = resultSet.getLong(idx_id);
            long unitId = resultSet.getLong(idx_unitId);
            long createTime = resultSet.getLong(idx_createTime);
            long receiveTime = resultSet.getLong(idx_receiveTime);
            UnitDTO unitDTO = this.getUnitDTOMap().get(unitId);
            KeepAliveDTO dto = DTOFactory.buildKeepAliveDTO(id, createTime, receiveTime, null, unitDTO);
            this.addExtendedData(false, resultSet, dto, new ExtendedDTOData[0]);
            this.dataList.add(dto);
            ++dataSize;
        }
        return dataSize;
    }
}

