/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.data.fastlanereader.report;

import com.healthmarketscience.sqlbuilder.dbspec.Column;
import de.proveo.wwt.datamodel.area.Area;
import de.proveo.wwt.logic.web.common.dataSelection.ReportSelectionDTO;
import de.proveo.wwt.logic.web.common.dto.DTOFactory;
import de.proveo.wwt.logic.web.common.dto.DTOListBase;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import de.proveo.wwt.logic.web.data.enumerations.ExtendedDTOData;
import de.proveo.wwt.logic.web.data.enumerations.FastLaneReaderOrder;
import de.proveo.wwt.logic.web.data.fastlanereader.report.StateReportFastLaneReader;
import de.proveo.wwt.logic.web.data.query.definitions.GdataDefinitions;
import de.proveo.wwt.logic.web.historyData.dto.PositionDTO;
import java.sql.ResultSet;
import java.sql.SQLException;

public class GdataFastLaneReader
extends StateReportFastLaneReader<PositionDTO, GdataDefinitions> {
    public GdataFastLaneReader() {
        super(new GdataDefinitions());
    }

    public void getHistory(DTOListBase<PositionDTO> list, ReportSelectionDTO selectionDTO, ExtendedDTOData ... extendedData) {
        this.init(list, selectionDTO, FastLaneReaderOrder.ByNothing, extendedData);
        String sql = this.generateSql(false, this.getRowLimit());
        this.getData(sql, false);
    }

    public void getCache(DTOListBase<PositionDTO> list, ReportSelectionDTO selectionDTO, ExtendedDTOData ... extendedData) {
        this.init(list, selectionDTO, FastLaneReaderOrder.ByUnitId, extendedData);
        String sql = this.generateSql(true);
        this.getData(sql, true);
    }

    public void getCache(DTOListBase<PositionDTO> list, Long unitId, ExtendedDTOData ... extendedData) {
        ReportSelectionDTO selectionDTO = this.buildUnitReportSelectionDTO(unitId, 0L, 0L, true, false);
        this.init(list, selectionDTO, FastLaneReaderOrder.ByUnitId, extendedData);
        String sql = this.generateSql(true);
        this.getData(sql, true);
    }

    public void getHistory(DTOListBase<PositionDTO> list, Long unitId, long beginTime, long endTime, boolean useGroupHistory, ExtendedDTOData ... extendedData) {
        ReportSelectionDTO selectionDTO = this.buildUnitReportSelectionDTO(unitId, beginTime, endTime, useGroupHistory, true);
        this.init(list, selectionDTO, FastLaneReaderOrder.ByNothing, extendedData);
        String sql = this.generateSql(false, this.getRowLimit());
        this.getData(sql, false);
    }

    @Override
    protected void prepareHistoryColumns() {
        super.prepareHistoryColumns();
        Column[] columnArray = new Column[7];
        GdataDefinitions cfr_ignored_0 = (GdataDefinitions)this.getDefinitions();
        columnArray[0] = GdataDefinitions.col_History_RmcRec;
        GdataDefinitions cfr_ignored_1 = (GdataDefinitions)this.getDefinitions();
        columnArray[1] = GdataDefinitions.col_History_GgaRec;
        GdataDefinitions cfr_ignored_2 = (GdataDefinitions)this.getDefinitions();
        columnArray[2] = GdataDefinitions.col_History_AreaId;
        GdataDefinitions cfr_ignored_3 = (GdataDefinitions)this.getDefinitions();
        columnArray[3] = GdataDefinitions.col_History_Trusted;
        GdataDefinitions cfr_ignored_4 = (GdataDefinitions)this.getDefinitions();
        columnArray[4] = GdataDefinitions.col_History_Reason;
        GdataDefinitions cfr_ignored_5 = (GdataDefinitions)this.getDefinitions();
        columnArray[5] = GdataDefinitions.col_History_LongMsec;
        GdataDefinitions cfr_ignored_6 = (GdataDefinitions)this.getDefinitions();
        columnArray[6] = GdataDefinitions.col_History_LatMsec;
        this.historyQuery.addColumns(columnArray);
    }

    @Override
    protected void prepareCacheColumns() {
        super.prepareCacheColumns();
        Column[] columnArray = new Column[7];
        GdataDefinitions cfr_ignored_0 = (GdataDefinitions)this.getDefinitions();
        columnArray[0] = GdataDefinitions.col_Cache_RmcRec;
        GdataDefinitions cfr_ignored_1 = (GdataDefinitions)this.getDefinitions();
        columnArray[1] = GdataDefinitions.col_Cache_GgaRec;
        GdataDefinitions cfr_ignored_2 = (GdataDefinitions)this.getDefinitions();
        columnArray[2] = GdataDefinitions.col_Cache_AreaId;
        GdataDefinitions cfr_ignored_3 = (GdataDefinitions)this.getDefinitions();
        columnArray[3] = GdataDefinitions.col_Cache_Trusted;
        GdataDefinitions cfr_ignored_4 = (GdataDefinitions)this.getDefinitions();
        columnArray[4] = GdataDefinitions.col_Cache_Reason;
        GdataDefinitions cfr_ignored_5 = (GdataDefinitions)this.getDefinitions();
        columnArray[5] = GdataDefinitions.col_Cache_LongMsec;
        GdataDefinitions cfr_ignored_6 = (GdataDefinitions)this.getDefinitions();
        columnArray[6] = GdataDefinitions.col_Cache_LatMsec;
        this.cacheQuery.addColumns(columnArray);
    }

    @Override
    protected int getCache(ResultSet resultSet) throws SQLException {
        int dataSize = 0;
        int idx_id = resultSet.findColumn(((GdataDefinitions)this.getDefinitions()).getCacheHistoryIdColumn().getName());
        int idx_unitId = resultSet.findColumn(((GdataDefinitions)this.getDefinitions()).getCacheUnitIdColumn().getName());
        int idx_beginTime = resultSet.findColumn("bt");
        int idx_beginReceiveTime = resultSet.findColumn(((GdataDefinitions)this.getDefinitions()).getCacheBeginReceiveTimeColumn().getName());
        int idx_actualBeginTime = resultSet.findColumn(((GdataDefinitions)this.getDefinitions()).getCacheBeginTimeColumn().getName());
        GdataDefinitions cfr_ignored_0 = (GdataDefinitions)this.getDefinitions();
        int idx_areaId = resultSet.findColumn(GdataDefinitions.col_Cache_AreaId.getName());
        GdataDefinitions cfr_ignored_1 = (GdataDefinitions)this.getDefinitions();
        int idx_areaTrusted = resultSet.findColumn(GdataDefinitions.col_Cache_Trusted.getName());
        GdataDefinitions cfr_ignored_2 = (GdataDefinitions)this.getDefinitions();
        int idx_reason = resultSet.findColumn(GdataDefinitions.col_Cache_Reason.getName());
        GdataDefinitions cfr_ignored_3 = (GdataDefinitions)this.getDefinitions();
        int idx_ggaRec = resultSet.findColumn(GdataDefinitions.col_Cache_GgaRec.getName());
        GdataDefinitions cfr_ignored_4 = (GdataDefinitions)this.getDefinitions();
        int idx_lat = resultSet.findColumn(GdataDefinitions.col_Cache_LatMsec.getName());
        GdataDefinitions cfr_ignored_5 = (GdataDefinitions)this.getDefinitions();
        int idx_long = resultSet.findColumn(GdataDefinitions.col_Cache_LongMsec.getName());
        GdataDefinitions cfr_ignored_6 = (GdataDefinitions)this.getDefinitions();
        int idx_rmcRec = resultSet.findColumn(GdataDefinitions.col_Cache_RmcRec.getName());
        while (resultSet.next()) {
            long id = resultSet.getLong(idx_id);
            long unitId = resultSet.getLong(idx_unitId);
            String ggaRec = resultSet.getString(idx_ggaRec);
            String rmcRec = resultSet.getString(idx_rmcRec);
            String reason = resultSet.getString(idx_reason);
            int latMSEC = resultSet.getInt(idx_lat);
            int longMSEC = resultSet.getInt(idx_long);
            long beginReceiveTime = resultSet.getLong(idx_beginReceiveTime);
            long endReceiveTime = 0L;
            long beginTime = resultSet.getLong(idx_beginTime);
            long endTime = 0L;
            long actualBeginTime = resultSet.getLong(idx_actualBeginTime);
            long actualEndTime = 0L;
            UnitDTO unitDTO = this.getUnitDTOMap().get(unitId);
            if (unitDTO.isDeleted()) continue;
            Area area = this.getAreaMap().get(resultSet.getInt(idx_areaId));
            boolean areaTrusted = resultSet.getBoolean(idx_areaTrusted);
            String areaName = area == null ? null : area.getArea();
            String areaDescription = area == null ? null : area.getDescription();
            PositionDTO dto = DTOFactory.buildPositionDTO(id, beginTime, endTime, beginReceiveTime, endReceiveTime, actualBeginTime, actualEndTime, areaTrusted, ggaRec, latMSEC, longMSEC, rmcRec, reason, areaName, areaDescription, unitDTO);
            this.addExtendedData(true, resultSet, dto, new ExtendedDTOData[0]);
            this.dataList.add(dto);
            if (this.reportMaxRowLimit == null || ++dataSize != this.reportMaxRowLimit) continue;
            this.dataList.setMaxRowsLimit(this.reportMaxRowLimit);
            log.debug((Object)("Row limit exceeded: " + this.reportMaxRowLimit));
            break;
        }
        return dataSize;
    }

    @Override
    protected int getHistory(ResultSet resultSet) throws SQLException {
        int dataSize = 0;
        int idx_id = resultSet.findColumn(((GdataDefinitions)this.getDefinitions()).getHelperHistoryIdColumn().getName());
        int idx_unitId = resultSet.findColumn(((GdataDefinitions)this.getDefinitions()).getHelperUnitIdColumn().getName());
        int idx_beginTime = resultSet.findColumn("bt");
        int idx_endTime = resultSet.findColumn("et");
        int idx_beginReceiveTime = resultSet.findColumn(((GdataDefinitions)this.getDefinitions()).getHistoryBeginReceiveTimeColumn().getName());
        int idx_endReceiveTime = resultSet.findColumn(((GdataDefinitions)this.getDefinitions()).getHistoryEndReceiveTimeColumn().getName());
        int idx_actualBeginTime = resultSet.findColumn(((GdataDefinitions)this.getDefinitions()).getHistoryBeginTimeColumn().getName());
        int idx_actualEndTime = resultSet.findColumn(((GdataDefinitions)this.getDefinitions()).getHistoryEndTimeColumn().getName());
        GdataDefinitions cfr_ignored_0 = (GdataDefinitions)this.getDefinitions();
        int idx_areaId = resultSet.findColumn(GdataDefinitions.col_History_AreaId.getName());
        GdataDefinitions cfr_ignored_1 = (GdataDefinitions)this.getDefinitions();
        int idx_areaTrusted = resultSet.findColumn(GdataDefinitions.col_History_Trusted.getName());
        GdataDefinitions cfr_ignored_2 = (GdataDefinitions)this.getDefinitions();
        int idx_reason = resultSet.findColumn(GdataDefinitions.col_History_Reason.getName());
        GdataDefinitions cfr_ignored_3 = (GdataDefinitions)this.getDefinitions();
        int idx_ggaRec = resultSet.findColumn(GdataDefinitions.col_History_GgaRec.getName());
        GdataDefinitions cfr_ignored_4 = (GdataDefinitions)this.getDefinitions();
        int idx_lat = resultSet.findColumn(GdataDefinitions.col_History_LatMsec.getName());
        GdataDefinitions cfr_ignored_5 = (GdataDefinitions)this.getDefinitions();
        int idx_long = resultSet.findColumn(GdataDefinitions.col_History_LongMsec.getName());
        GdataDefinitions cfr_ignored_6 = (GdataDefinitions)this.getDefinitions();
        int idx_rmcRec = resultSet.findColumn(GdataDefinitions.col_History_RmcRec.getName());
        while (resultSet.next()) {
            long id = resultSet.getLong(idx_id);
            long unitId = resultSet.getLong(idx_unitId);
            String ggaRec = resultSet.getString(idx_ggaRec);
            String rmcRec = resultSet.getString(idx_rmcRec);
            String reason = resultSet.getString(idx_reason);
            int latMSEC = resultSet.getInt(idx_lat);
            int longMSEC = resultSet.getInt(idx_long);
            long beginReceiveTime = resultSet.getLong(idx_beginReceiveTime);
            long endReceiveTime = resultSet.getLong(idx_endReceiveTime);
            long beginTime = resultSet.getLong(idx_beginTime);
            long endTime = resultSet.getLong(idx_endTime);
            long actualBeginTime = resultSet.getLong(idx_actualBeginTime);
            long actualEndTime = resultSet.getLong(idx_actualEndTime);
            UnitDTO unitDTO = this.getUnitDTOMap().get(unitId);
            Area area = this.getAreaMap().get(resultSet.getInt(idx_areaId));
            boolean areaTrusted = resultSet.getBoolean(idx_areaTrusted);
            String areaName = area == null ? null : area.getArea();
            String areaDescription = area == null ? null : area.getDescription();
            PositionDTO dto = DTOFactory.buildPositionDTO(id, beginTime, endTime, beginReceiveTime, endReceiveTime, actualBeginTime, actualEndTime, areaTrusted, ggaRec, latMSEC, longMSEC, rmcRec, reason, areaName, areaDescription, unitDTO);
            this.addExtendedData(false, resultSet, dto, new ExtendedDTOData[0]);
            this.dataList.add(dto);
            if (this.reportMaxRowLimit == null || ++dataSize != this.reportMaxRowLimit) continue;
            this.dataList.setMaxRowsLimit(this.reportMaxRowLimit);
            log.debug((Object)("Row limit exceeded: " + this.reportMaxRowLimit));
            break;
        }
        return dataSize;
    }

    @Override
    protected void init(DTOListBase<PositionDTO> dataList, ReportSelectionDTO selectionDTO, FastLaneReaderOrder order, ExtendedDTOData ... extendedData) {
        super.init(dataList, selectionDTO, order, extendedData);
        this.extendedData.remove((Object)ExtendedDTOData.AREA);
        this.extendedData.remove((Object)ExtendedDTOData.GDATA);
    }
}

