/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.data.fastlanereader.replay;

import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.ComboCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.CustomCondition;
import com.healthmarketscience.sqlbuilder.CustomSql;
import com.healthmarketscience.sqlbuilder.InCondition;
import com.healthmarketscience.sqlbuilder.OrderObject;
import com.healthmarketscience.sqlbuilder.SelectQuery;
import com.healthmarketscience.sqlbuilder.SqlObject;
import com.healthmarketscience.sqlbuilder.dbspec.Column;
import com.healthmarketscience.sqlbuilder.dbspec.Table;
import de.proveo.util.database.DatabaseType;
import de.proveo.wwt.logic.app.util.Stopwatch;
import de.proveo.wwt.logic.web.data.fastlanereader.base.ReplayFastLaneBase;
import de.proveo.wwt.logic.web.data.fastlanereader.base.UnitReplayFastLaneBase;
import de.proveo.wwt.logic.web.data.query.definitions.NotificationDefinitions;
import de.proveo.wwt.logic.web.data.query.definitions.NotifyDefinitions;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NotificationReplayFastLaneReader
extends UnitReplayFastLaneBase {
    private static final Log log = LogFactory.getLog(NotificationReplayFastLaneReader.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TreeMap<Long, HashMap> getReplayData(HashSet<Long> unitPermissions, TreeMap<Long, HashMap> completeReplayDataMap, long since, long until, ReplayFastLaneBase.DataType dataType) {
        String method = "getReplayData(" + (Object)((Object)dataType) + ")";
        log.debug((Object)(method + " called"));
        Stopwatch stopwatch = new Stopwatch(NotificationReplayFastLaneReader.class, method);
        stopwatch.start("Overall");
        int maxRowsLimit = this.getRowLimit();
        log.debug((Object)(method + ": maxRowLimit=" + maxRowsLimit));
        TreeMap<Long, HashMap> retMap = new TreeMap<Long, HashMap>();
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getConnection();
            if (connection != null) {
                String sql = null;
                switch (dataType) {
                    case CACHE: {
                        sql = this.generateCacheSqlForReplay(since, until, maxRowsLimit, unitPermissions);
                        break;
                    }
                    case HISTORY: {
                        sql = this.generateHistorySqlForReplay(since, until, maxRowsLimit);
                        break;
                    }
                    default: {
                        log.error((Object)("Unkown data type: " + (Object)((Object)dataType) + ". Break!"));
                        TreeMap<Long, HashMap> treeMap = retMap;
                        return treeMap;
                    }
                }
                log.debug((Object)(method + ": Execute SQL: " + sql));
                stopwatch.start("Database access");
                statement = this.createReadOnlyForwardOnlyStatement(connection);
                resultSet = statement.executeQuery(sql);
                stopwatch.stop("Database access", true);
                log.debug((Object)(method + ": building Maps..."));
                stopwatch.start("Build DTO");
                int rowCounter = 0;
                while (resultSet.next()) {
                    if (maxRowsLimit != 0 && ++rowCounter == maxRowsLimit) {
                        log.debug((Object)(method + ": Row limit exceeded: " + maxRowsLimit));
                        break;
                    }
                    long nUnitId = resultSet.getLong("UNIT_ID");
                    if (!unitPermissions.contains(nUnitId)) continue;
                    long nTimeStamp = resultSet.getLong("CREATE_TIME");
                    if (completeReplayDataMap.containsKey(nTimeStamp)) {
                        ++nTimeStamp;
                    }
                    HashMap valueMap = this.generateReplayValueMap(nTimeStamp, resultSet);
                    completeReplayDataMap.put(nTimeStamp, valueMap);
                    retMap.put(nTimeStamp, valueMap);
                }
                stopwatch.stop("Build DTO", true, retMap.size());
            }
        }
        catch (SQLException e) {
            log.error((Object)(method + ": runs into"), (Throwable)e);
        }
        finally {
            this.closeQuietly(statement, resultSet, connection);
            statement = null;
            resultSet = null;
            connection = null;
        }
        stopwatch.stop("Overall", true);
        return retMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<Long, TreeMap> getHistoryInitialForReplay(HashSet<Long> unitPermissions, long since, HashMap<Long, TreeMap> notifyCacheMap, int maximumNotifiesPerDay) {
        String method = "getHistoryInitialForReplay()";
        log.debug((Object)"getHistoryInitialForReplay() called");
        Stopwatch stopwatch = new Stopwatch(NotificationReplayFastLaneReader.class, "getHistoryInitialForReplay()");
        stopwatch.start("Overall");
        int maxRowsLimit = this.getRowLimit();
        log.debug((Object)("getHistoryInitialForReplay(): maxRowLimit=" + maxRowsLimit));
        if (notifyCacheMap == null) {
            notifyCacheMap = new HashMap();
        }
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getConnection();
            if (connection != null) {
                String sql = this.generateHistoryInitialSqlForReplay(since, maxRowsLimit);
                log.debug((Object)("getHistoryInitialForReplay(): Execute SQL: " + sql));
                stopwatch.start("Database access");
                statement = this.createReadOnlyForwardOnlyStatement(connection);
                resultSet = statement.executeQuery(sql);
                stopwatch.stop("Database access", true);
                log.debug((Object)"getHistoryInitialForReplay(): building Maps...");
                stopwatch.start("Build DTO");
                int rowCounter = 0;
                int dataAmount = 0;
                while (resultSet.next()) {
                    if (maxRowsLimit != 0 && ++rowCounter == maxRowsLimit) {
                        log.debug((Object)("getHistoryInitialForReplay(): Row limit exceeded: " + maxRowsLimit));
                        break;
                    }
                    long nUnitId = resultSet.getLong("UNIT_ID");
                    if (!unitPermissions.contains(nUnitId)) continue;
                    long nTimeStamp = resultSet.getLong("CREATE_TIME");
                    long nMessageId = resultSet.getLong("MESSAGE_ID");
                    TreeMap<String, HashMap> unitValueMap = new TreeMap<String, HashMap>();
                    if (notifyCacheMap.containsKey(nUnitId)) {
                        unitValueMap = notifyCacheMap.get(nUnitId);
                        if (maximumNotifiesPerDay > 0 && unitValueMap.size() >= maximumNotifiesPerDay) continue;
                        while (unitValueMap.containsKey(nTimeStamp + "_" + nMessageId)) {
                            ++nTimeStamp;
                        }
                    }
                    HashMap valueMap = this.generateReplayValueMap(nTimeStamp, resultSet);
                    unitValueMap.put(nTimeStamp + "_" + nMessageId, valueMap);
                    notifyCacheMap.put(nUnitId, unitValueMap);
                    ++dataAmount;
                }
                stopwatch.stop("Build DTO", true, dataAmount);
            }
        }
        catch (SQLException e) {
            log.error((Object)"getHistoryInitialForReplay(): runs into", (Throwable)e);
        }
        finally {
            this.closeQuietly(statement, resultSet, connection);
            statement = null;
            resultSet = null;
            connection = null;
        }
        stopwatch.stop("Overall", true);
        return notifyCacheMap;
    }

    private HashMap generateReplayValueMap(long nTimeStamp, ResultSet resultSet) throws SQLException {
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        long nUnitId = resultSet.getLong("UNIT_ID");
        long nReceiveTime = resultSet.getLong("RECEIVE_TIME");
        long nMessageId = resultSet.getLong("MESSAGE_ID");
        String nMessageName = resultSet.getString("DEFAULT_NAME");
        boolean nEntry = resultSet.getBoolean("ENTRY");
        valueMap.put("EventType", "data_type_notification_event");
        valueMap.put("UnitId", nUnitId);
        valueMap.put("NotifyMessageID", nMessageId);
        valueMap.put("NotifyMessage", nMessageName);
        valueMap.put("NotifyEntry", nEntry);
        valueMap.put("NotifyTimestamp", nTimeStamp);
        valueMap.put("NotifyReceiveTime", nReceiveTime);
        valueMap.put("ServerTime", nTimeStamp);
        return valueMap;
    }

    private String generateCacheSqlForReplay(long since, long until, int maxRowsLimit, HashSet<Long> unitPermissions) {
        SelectQuery query = new SelectQuery();
        query.addColumns(new Column[]{NotifyDefinitions.col_Cache_UnitId, NotifyDefinitions.col_Cache_CreateTime, NotifyDefinitions.col_Cache_ReceiveTime, NotifyDefinitions.col_Cache_MessageId, NotifyDefinitions.col_Cache_Entry, NotificationDefinitions.col_Notification_DefaultName});
        query.addJoin(SelectQuery.JoinType.LEFT_OUTER, (Table)NotifyDefinitions.tbl_Cache, (Table)NotificationDefinitions.tbl_Notification, (Column)NotifyDefinitions.col_Cache_MessageId, (Column)NotificationDefinitions.col_Notification_Id);
        ComboCondition whereCondition = new ComboCondition(ComboCondition.Op.AND);
        whereCondition.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.GREATER_THAN, (Object)NotifyDefinitions.col_Cache_CreateTime, (Object)since));
        whereCondition.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.LESS_THAN_OR_EQUAL_TO, (Object)NotifyDefinitions.col_Cache_CreateTime, (Object)until));
        whereCondition.addCondition((Condition)new InCondition((Object)NotifyDefinitions.col_Cache_UnitId, unitPermissions));
        if (this.databaseType == DatabaseType.Oracle && maxRowsLimit != 0) {
            whereCondition.addCondition((Condition)new CustomCondition((SqlObject)new CustomSql((Object)("ROWNUM <= " + maxRowsLimit))));
        }
        query.addCondition((Condition)whereCondition);
        String sql = ((SelectQuery)query.validate()).toString();
        if (maxRowsLimit != 0) {
            StringBuilder limitBuilder = new StringBuilder();
            switch (this.databaseType) {
                case MSSQL: {
                    limitBuilder.append("SELECT TOP ");
                    limitBuilder.append(maxRowsLimit);
                    limitBuilder.append(sql.substring(6));
                    sql = limitBuilder.toString();
                    break;
                }
                case MySQL: {
                    limitBuilder.append(sql);
                    limitBuilder.append(" LIMIT ");
                    limitBuilder.append(maxRowsLimit);
                    sql = limitBuilder.toString();
                }
            }
        }
        return sql;
    }

    private String generateHistorySqlForReplay(long since, long until, int maxRowsLimit) {
        SelectQuery query = new SelectQuery(true);
        query.addColumns(new Column[]{NotifyDefinitions.col_History_UnitId, NotifyDefinitions.col_History_CreateTime, NotifyDefinitions.col_History_ReceiveTime, NotifyDefinitions.col_History_MessageId, NotifyDefinitions.col_History_Entry, NotificationDefinitions.col_Notification_DefaultName});
        query.addJoin(SelectQuery.JoinType.LEFT_OUTER, (Table)NotifyDefinitions.tbl_HistoryHelper, (Table)NotifyDefinitions.tbl_History, (Column)NotifyDefinitions.col_HistoryHelper_Id, (Column)NotifyDefinitions.col_History_Id);
        query.addJoin(SelectQuery.JoinType.LEFT_OUTER, (Table)NotifyDefinitions.tbl_History, (Table)NotificationDefinitions.tbl_Notification, (Column)NotifyDefinitions.col_History_MessageId, (Column)NotificationDefinitions.col_Notification_Id);
        ComboCondition whereCondition = new ComboCondition(ComboCondition.Op.AND);
        whereCondition.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.LESS_THAN_OR_EQUAL_TO, (Object)NotifyDefinitions.col_HistoryHelper_DayStamp, (Object)(until / 86400000L)));
        whereCondition.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.GREATER_THAN_OR_EQUAL_TO, (Object)NotifyDefinitions.col_HistoryHelper_DayStamp, (Object)(since / 86400000L)));
        whereCondition.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.GREATER_THAN, (Object)NotifyDefinitions.col_History_CreateTime, (Object)since));
        whereCondition.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.LESS_THAN_OR_EQUAL_TO, (Object)NotifyDefinitions.col_History_CreateTime, (Object)until));
        if (this.databaseType == DatabaseType.Oracle && maxRowsLimit != 0) {
            whereCondition.addCondition((Condition)new CustomCondition((SqlObject)new CustomSql((Object)("ROWNUM <= " + maxRowsLimit))));
        }
        query.addCondition((Condition)whereCondition);
        query.addOrdering((Column)NotifyDefinitions.col_History_CreateTime, OrderObject.Dir.DESCENDING);
        String sql = ((SelectQuery)query.validate()).toString();
        if (maxRowsLimit != 0) {
            StringBuilder limitBuilder = new StringBuilder();
            switch (this.databaseType) {
                case MSSQL: {
                    limitBuilder.append("SELECT DISTINCT TOP ");
                    limitBuilder.append(maxRowsLimit);
                    limitBuilder.append(sql.substring(15));
                    sql = limitBuilder.toString();
                    break;
                }
                case MySQL: {
                    limitBuilder.append(sql);
                    limitBuilder.append(" LIMIT ");
                    limitBuilder.append(maxRowsLimit);
                    sql = limitBuilder.toString();
                }
            }
        }
        return sql;
    }

    private String generateCacheInitialSqlForReplay(long since, int maxRowsLimit, HashSet<Long> unitPermissions) {
        SelectQuery query = new SelectQuery();
        query.addColumns(new Column[]{NotifyDefinitions.col_Cache_UnitId, NotifyDefinitions.col_Cache_CreateTime, NotifyDefinitions.col_Cache_ReceiveTime, NotifyDefinitions.col_Cache_MessageId, NotifyDefinitions.col_Cache_Entry, NotificationDefinitions.col_Notification_DefaultName});
        query.addJoin(SelectQuery.JoinType.LEFT_OUTER, (Table)NotifyDefinitions.tbl_Cache, (Table)NotificationDefinitions.tbl_Notification, (Column)NotifyDefinitions.col_Cache_MessageId, (Column)NotificationDefinitions.col_Notification_Id);
        ComboCondition whereCondition = new ComboCondition(ComboCondition.Op.AND);
        whereCondition.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.LESS_THAN_OR_EQUAL_TO, (Object)NotifyDefinitions.col_Cache_CreateTime, (Object)since));
        whereCondition.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.GREATER_THAN_OR_EQUAL_TO, (Object)NotifyDefinitions.col_Cache_CreateTime, (Object)(since - 864000000L)));
        whereCondition.addCondition((Condition)new InCondition((Object)NotifyDefinitions.col_Cache_UnitId, unitPermissions));
        if (this.databaseType == DatabaseType.Oracle && maxRowsLimit != 0) {
            whereCondition.addCondition((Condition)new CustomCondition((SqlObject)new CustomSql((Object)("ROWNUM <= " + maxRowsLimit))));
        }
        query.addCondition((Condition)whereCondition);
        query.addOrdering((Column)NotifyDefinitions.col_Cache_CreateTime, OrderObject.Dir.DESCENDING);
        String sql = ((SelectQuery)query.validate()).toString();
        if (maxRowsLimit != 0) {
            StringBuilder limitBuilder = new StringBuilder();
            switch (this.databaseType) {
                case MSSQL: {
                    limitBuilder.append("SELECT TOP ");
                    limitBuilder.append(maxRowsLimit);
                    limitBuilder.append(sql.substring(6));
                    sql = limitBuilder.toString();
                    break;
                }
                case MySQL: {
                    limitBuilder.append(sql);
                    limitBuilder.append(" LIMIT ");
                    limitBuilder.append(maxRowsLimit);
                    sql = limitBuilder.toString();
                }
            }
        }
        return sql;
    }

    private String generateHistoryInitialSqlForReplay(long since, int maxRowsLimit) {
        SelectQuery query = new SelectQuery(true);
        query.addColumns(new Column[]{NotifyDefinitions.col_History_UnitId, NotifyDefinitions.col_History_CreateTime, NotifyDefinitions.col_History_ReceiveTime, NotifyDefinitions.col_History_MessageId, NotifyDefinitions.col_History_Entry, NotificationDefinitions.col_Notification_DefaultName});
        query.addJoin(SelectQuery.JoinType.LEFT_OUTER, (Table)NotifyDefinitions.tbl_HistoryHelper, (Table)NotifyDefinitions.tbl_History, (Column)NotifyDefinitions.col_HistoryHelper_Id, (Column)NotifyDefinitions.col_History_Id);
        query.addJoin(SelectQuery.JoinType.LEFT_OUTER, (Table)NotifyDefinitions.tbl_History, (Table)NotificationDefinitions.tbl_Notification, (Column)NotifyDefinitions.col_History_MessageId, (Column)NotificationDefinitions.col_Notification_Id);
        ComboCondition whereCondition = new ComboCondition(ComboCondition.Op.AND);
        whereCondition.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.LESS_THAN_OR_EQUAL_TO, (Object)NotifyDefinitions.col_HistoryHelper_DayStamp, (Object)(since / 86400000L)));
        whereCondition.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.GREATER_THAN_OR_EQUAL_TO, (Object)NotifyDefinitions.col_HistoryHelper_DayStamp, (Object)(since / 86400000L - 1L)));
        whereCondition.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.LESS_THAN_OR_EQUAL_TO, (Object)NotifyDefinitions.col_History_CreateTime, (Object)since));
        whereCondition.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.GREATER_THAN_OR_EQUAL_TO, (Object)NotifyDefinitions.col_History_CreateTime, (Object)(since - 864000000L)));
        if (this.databaseType == DatabaseType.Oracle && maxRowsLimit != 0) {
            whereCondition.addCondition((Condition)new CustomCondition((SqlObject)new CustomSql((Object)("ROWNUM <= " + maxRowsLimit))));
        }
        query.addCondition((Condition)whereCondition);
        query.addOrdering((Column)NotifyDefinitions.col_History_CreateTime, OrderObject.Dir.DESCENDING);
        String sql = ((SelectQuery)query.validate()).toString();
        if (maxRowsLimit != 0) {
            StringBuilder limitBuilder = new StringBuilder();
            switch (this.databaseType) {
                case MSSQL: {
                    limitBuilder.append("SELECT DISTINCT TOP ");
                    limitBuilder.append(maxRowsLimit);
                    limitBuilder.append(sql.substring(15));
                    sql = limitBuilder.toString();
                    break;
                }
                case MySQL: {
                    limitBuilder.append(sql);
                    limitBuilder.append(" LIMIT ");
                    limitBuilder.append(maxRowsLimit);
                    sql = limitBuilder.toString();
                }
            }
        }
        return sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<Long, TreeMap> getCacheInitialForReplay(HashSet<Long> unitPermissions, long since, int maximumNotifiesPerDay) {
        String method = "getCacheInitialForReplay()";
        log.debug((Object)"getCacheInitialForReplay() called");
        Stopwatch stopwatch = new Stopwatch(NotificationReplayFastLaneReader.class, "getCacheInitialForReplay()");
        stopwatch.start("Overall");
        int maxRowsLimit = this.getRowLimit();
        log.debug((Object)("getCacheInitialForReplay(): maxRowLimit=" + maxRowsLimit));
        HashMap<Long, TreeMap> retMap = new HashMap<Long, TreeMap>();
        if (unitPermissions == null || unitPermissions.size() <= 0) {
            log.warn((Object)"getCacheInitialForReplay(): No permissions, break.");
            stopwatch.stop("Overall", true);
            return retMap;
        }
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getConnection();
            if (connection != null) {
                String sql = this.generateCacheInitialSqlForReplay(since, maxRowsLimit, unitPermissions);
                log.debug((Object)("getCacheInitialForReplay(): Execute SQL: " + sql));
                stopwatch.start("Database access");
                statement = this.createReadOnlyForwardOnlyStatement(connection);
                resultSet = statement.executeQuery(sql);
                stopwatch.stop("Database access", true);
                log.debug((Object)"getCacheInitialForReplay(): building Maps...");
                stopwatch.start("Build DTO");
                int rowCounter = 0;
                while (resultSet.next()) {
                    if (maxRowsLimit != 0 && ++rowCounter == maxRowsLimit) {
                        log.debug((Object)("getCacheInitialForReplay(): Row limit exceeded: " + maxRowsLimit));
                        break;
                    }
                    long nUnitId = resultSet.getLong("UNIT_ID");
                    long nTimeStamp = resultSet.getLong("CREATE_TIME");
                    long nMessageId = resultSet.getLong("MESSAGE_ID");
                    TreeMap unitValueMap = new TreeMap();
                    if (retMap.containsKey(nUnitId)) {
                        unitValueMap = retMap.get(nUnitId);
                        if (maximumNotifiesPerDay > 0 && unitValueMap.size() >= maximumNotifiesPerDay) continue;
                        while (unitValueMap.containsKey(nTimeStamp + "_" + nMessageId)) {
                            ++nTimeStamp;
                        }
                    }
                    HashMap valueMap = this.generateReplayValueMap(nTimeStamp, resultSet);
                    unitValueMap.put(nTimeStamp + "_" + nMessageId, valueMap);
                    retMap.put(nUnitId, unitValueMap);
                }
                stopwatch.stop("Build DTO", true, retMap.size());
            }
        }
        catch (SQLException e) {
            log.error((Object)"getCacheInitialForReplay(): runs into", (Throwable)e);
        }
        finally {
            this.closeQuietly(statement, resultSet, connection);
            statement = null;
            resultSet = null;
            connection = null;
        }
        stopwatch.stop("Overall", true);
        return retMap;
    }
}

