/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.data.fastlanereader.base;

import com.healthmarketscience.sqlbuilder.ComboExpression;
import com.healthmarketscience.sqlbuilder.CustomExpression;
import com.healthmarketscience.sqlbuilder.CustomSql;
import com.healthmarketscience.sqlbuilder.FunctionCall;
import com.healthmarketscience.sqlbuilder.SqlObject;
import de.proveo.wwt.datamodel.unit.model.UnitModel;
import de.proveo.wwt.datamodel.use.group.UseGroup;
import de.proveo.wwt.datamodel.use.user.UseUser;
import de.proveo.wwt.logic.web.common.dataSelection.OperatorReportSelectionDTO;
import de.proveo.wwt.logic.web.common.dataSelection.ReportSelectionDTO;
import de.proveo.wwt.logic.web.common.dataSelection.UnitReportSelectionDTO;
import de.proveo.wwt.logic.web.common.dto.DTOFactory;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import de.proveo.wwt.logic.web.common.helper.UnitListFactory;
import de.proveo.wwt.logic.web.data.fastlanereader.base.FastLaneReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.joda.time.Interval;

public abstract class ReportFastLaneBase
extends FastLaneReader {
    public ReportSelectionDTO buildUnitReportSelectionDTO(Long unitId, long beginTime, long endTime, boolean useGroupHistory, boolean factsReport) {
        ArrayList<UnitDTO> unitDTOs = new ArrayList<UnitDTO>();
        if (unitId == null || unitId == 0L) {
            unitDTOs.add(DTOFactory.buildUnitDTO());
        } else {
            unitDTOs.add(this.getUnitDTOMap().get(unitId));
        }
        UnitReportSelectionDTO dto = new UnitReportSelectionDTO(factsReport ? new Interval(beginTime, endTime) : null, unitDTOs, useGroupHistory);
        return dto;
    }

    public OperatorReportSelectionDTO buildOperatorReportSelectionDTO(Long useUserId, Long useGroupId, long beginTime, long endTime, boolean factsReport) {
        ArrayList<UseUser> useUsers = new ArrayList<UseUser>();
        ArrayList<UseGroup> useGroups = new ArrayList<UseGroup>();
        if (useUserId != null) {
            useUsers.add(this.getUseUserMap().get(useUserId));
        }
        if (useGroupId != null) {
            if (useGroupId != 0L) {
                useGroups.add(this.getUseGroupMap().get(useGroupId));
            } else {
                UseGroup group = new UseGroup();
                group.setId(0L);
                useGroups.add(group);
            }
        }
        OperatorReportSelectionDTO dto = new OperatorReportSelectionDTO(factsReport ? new Interval(beginTime, endTime) : null, useUsers, useGroups);
        return dto;
    }

    protected static List<Long> getUnitsInGroup(Long unitId) {
        Collection<UnitModel> unitBasicModels = UnitListFactory.generateUnitModelList(unitId);
        ArrayList<Long> unitIds = new ArrayList<Long>(unitBasicModels.size());
        for (UnitModel unitModel : unitBasicModels) {
            unitIds.add(unitModel.getUnitId());
        }
        return unitIds;
    }

    protected static CustomSql getMinSql(Object value1, Object value2) {
        return ReportFastLaneBase.getMinMaxSql(true, value1, value2);
    }

    protected static CustomSql getMaxSql(Object value1, Object value2) {
        return ReportFastLaneBase.getMinMaxSql(false, value1, value2);
    }

    private static CustomSql getMinMaxSql(boolean generateMin, Object value1, Object value2) {
        return new CustomSql((Object)new CustomExpression((SqlObject)new ComboExpression(ComboExpression.Op.MULTIPLY, new Object[]{0.5, new ComboExpression(generateMin ? ComboExpression.Op.SUBTRACT : ComboExpression.Op.ADD, new Object[]{new ComboExpression(ComboExpression.Op.ADD, new Object[]{value1, value2}), new FunctionCall((Object)"ABS").addCustomParams(new Object[]{new ComboExpression(ComboExpression.Op.SUBTRACT, new Object[]{value1, value2})})})})));
    }
}

