/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.data.fastlanereader;

import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.ComboCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.FunctionCall;
import com.healthmarketscience.sqlbuilder.InCondition;
import com.healthmarketscience.sqlbuilder.SelectQuery;
import com.healthmarketscience.sqlbuilder.dbspec.Column;
import com.healthmarketscience.sqlbuilder.dbspec.Table;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbColumn;
import de.proveo.wwt.logic.web.common.dataSelection.ReportSelectionDTO;
import de.proveo.wwt.logic.web.common.dataSelection.UnitReportSelectionDTO;
import de.proveo.wwt.logic.web.common.dto.UnitContainerListBase;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import de.proveo.wwt.logic.web.common.dto.event.EventCountDTO;
import de.proveo.wwt.logic.web.common.dto.event.EventType;
import de.proveo.wwt.logic.web.data.fastlanereader.base.ReportFastLaneBase;
import de.proveo.wwt.logic.web.data.query.definitions.GdataDefinitions;
import de.proveo.wwt.logic.web.data.query.definitions.KeepaliveDefinitions;
import de.proveo.wwt.logic.web.data.query.definitions.MeasurementDefinitions;
import de.proveo.wwt.logic.web.data.query.definitions.NotifyDefinitions;
import de.proveo.wwt.logic.web.data.query.definitions.ScanmanMsgDefinitions;
import de.proveo.wwt.logic.web.data.query.definitions.StateDefinitions;
import de.proveo.wwt.logic.web.data.query.definitions.UnitDefinitions;
import de.proveo.wwt.logic.web.data.query.definitions.UseDefinitions;
import de.proveo.wwt.logic.web.data.query.interfaces.IEventReportTableDefinitions;
import de.proveo.wwt.logic.web.data.query.interfaces.IReportTableDefinitions;
import de.proveo.wwt.logic.web.data.query.interfaces.IStateReportTableDefinitions;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EventFastLaneReader
extends ReportFastLaneBase {
    private static final Log log = LogFactory.getLog(EventFastLaneReader.class);
    private ReportSelectionDTO selectionDTO;
    private static final String EVENT_COUNT = "event_count";

    private IReportTableDefinitions getDefinitions(EventType type) {
        switch (type) {
            case GdataEvents: {
                return new GdataDefinitions();
            }
            case KeepaliveEvents: {
                return new KeepaliveDefinitions();
            }
            case MeasurementEvents: {
                return new MeasurementDefinitions();
            }
            case NotifyEvents: {
                return new NotifyDefinitions();
            }
            case ScanmanMsgEvents: {
                return new ScanmanMsgDefinitions();
            }
            case StateEvents: {
                return new StateDefinitions();
            }
            case UseEvents: {
                return new UseDefinitions();
            }
        }
        return null;
    }

    public void getEventCountList(UnitContainerListBase<EventCountDTO> list, ReportSelectionDTO selectionDTO, EventType[] types) {
        this.selectionDTO = selectionDTO;
        for (EventType type : types) {
            HashMap<Long, Long> countMap = this.getCount(type);
            for (Map.Entry<Long, Long> count : countMap.entrySet()) {
                try {
                    EventCountDTO dto = list.getFirst(count.getKey());
                    if (dto == null) {
                        dto = new EventCountDTO(this.getUnitDTOMap().get(count.getKey()));
                        list.add(dto);
                    }
                    dto.put(type, count.getValue());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private HashMap<Long, Long> getCount(EventType type) {
        IReportTableDefinitions definitions = this.getDefinitions(type);
        SelectQuery query = new SelectQuery();
        query.addColumns(new Column[]{definitions.getHistoryUnitIdColumn()});
        query.addAliasedColumn((Object)FunctionCall.count().addColumnParams(new Column[]{definitions.getHistoryIdColumn()}), EVENT_COUNT);
        this.addTimeConditions(query, definitions);
        this.addUnitConditions(query, definitions);
        query.addCustomOrderings(new Object[]{EVENT_COUNT});
        query.addGroupings(new Column[]{definitions.getHistoryUnitIdColumn()});
        return this.getCount(((SelectQuery)query.validate()).toString(), definitions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap<Long, Long> getCount(String sql, IReportTableDefinitions definitions) {
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.getConnection();
            statement = this.createReadOnlyForwardOnlyStatement(connection);
            log.debug((Object)("Excecuted SQL: " + sql));
            ResultSet resultSet = statement.executeQuery(sql);
            HashMap<Long, Long> map = new HashMap<Long, Long>();
            while (resultSet.next()) {
                Long unitId = resultSet.getLong(definitions.getHistoryUnitIdColumn().getName());
                Long eventCount = resultSet.getLong(EVENT_COUNT);
                if (resultSet.wasNull()) continue;
                map.put(unitId, eventCount);
            }
            log.debug((Object)("Found " + map.keySet().size()));
            HashMap<Long, Long> hashMap = map;
            return hashMap;
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
        }
        return null;
    }

    private void addTimeConditions(SelectQuery query, IReportTableDefinitions definitions) {
        DbColumn beginTimeCol = null;
        DbColumn endTimeCol = null;
        if (definitions instanceof IEventReportTableDefinitions) {
            beginTimeCol = ((IEventReportTableDefinitions)definitions).getHistoryCreateTimeColumn();
            endTimeCol = ((IEventReportTableDefinitions)definitions).getHistoryCreateTimeColumn();
        } else if (definitions instanceof IStateReportTableDefinitions) {
            beginTimeCol = ((IStateReportTableDefinitions)definitions).getHistoryBeginTimeColumn();
            endTimeCol = ((IStateReportTableDefinitions)definitions).getHistoryBeginTimeColumn();
        } else {
            return;
        }
        query.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.LESS_THAN, (Object)beginTimeCol, (Object)this.selectionDTO.getEndTime()));
        query.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.GREATER_THAN, (Object)endTimeCol, (Object)this.selectionDTO.getBeginTime()));
    }

    private void addUnitConditions(SelectQuery query, IReportTableDefinitions definitions) {
        if (!(this.selectionDTO instanceof UnitReportSelectionDTO)) {
            return;
        }
        UnitReportSelectionDTO selectionDTO = (UnitReportSelectionDTO)this.selectionDTO;
        if (!selectionDTO.isAllSelected() && selectionDTO.getCount() > 0) {
            HashSet<Long> basicUnitIds = new HashSet<Long>();
            HashSet<Long> groupUnitIds = new HashSet<Long>();
            ComboCondition comboHistory = new ComboCondition(ComboCondition.Op.OR);
            for (UnitDTO dto : selectionDTO.getUnitDTOs()) {
                if (dto.isBasic()) {
                    basicUnitIds.add(dto.getUnitId());
                    continue;
                }
                if (selectionDTO.isUseGroupHistory()) {
                    groupUnitIds.add(dto.getUnitId());
                    continue;
                }
                basicUnitIds.addAll(EventFastLaneReader.getUnitsInGroup(dto.getUnitId()));
            }
            if (!basicUnitIds.isEmpty()) {
                comboHistory.addCondition((Condition)new InCondition((Object)definitions.getHistoryUnitIdColumn(), basicUnitIds));
            }
            if (!groupUnitIds.isEmpty()) {
                InCondition groupHistoryCondition = new InCondition((Object)UnitDefinitions.col_GroupHistoryXUnitModel_UnitGroupId, groupUnitIds);
                query.addJoin(SelectQuery.JoinType.LEFT_OUTER, (Table)definitions.getHistoryTable(), (Table)UnitDefinitions.tbl_GroupHistory, (Column)definitions.getHistoryGroupHistoryColumn(), (Column)UnitDefinitions.col_GroupHistory_Id);
                query.addJoin(SelectQuery.JoinType.LEFT_OUTER, (Table)UnitDefinitions.tbl_GroupHistory, (Table)UnitDefinitions.tbl_GroupHistoryXUnitModel, (Column)UnitDefinitions.col_GroupHistory_Id, (Column)UnitDefinitions.col_GroupHistoryXUnitModel_Id);
                comboHistory.addCondition((Condition)groupHistoryCondition);
            }
            query.addCondition((Condition)comboHistory);
        }
    }
}

