/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.data;

import de.proveo.wwt.logic.app.util.Stopwatch;
import de.proveo.wwt.logic.web.data.FastLaneWriter;
import de.proveo.wwt.logic.web.data.query.interfaces.IReportTableDefinitions;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HistoryFastLaneWriter
extends FastLaneWriter {
    private static final Log log = LogFactory.getLog(HistoryFastLaneWriter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateHistoryTablesSetGroupHistoryId(long unitId, long groupHistoryId) {
        log.debug((Object)"FastLaneWriter update_StateHistory_Set_GroupHistoryId called");
        Stopwatch stopwatch = new Stopwatch(FastLaneWriter.class, "updateHistoryTablesSetGroupHistoryId");
        stopwatch.start("Overall");
        Connection connection = null;
        Statement statement = null;
        try {
            log.debug((Object)"Database access...");
            stopwatch.start("Database access");
            connection = this.getConnection();
            statement = this.createStatement(connection);
            log.debug((Object)"Database access fast lane...");
            for (IReportTableDefinitions table : tableMap.values()) {
                String groupHistoryIdString = String.valueOf(groupHistoryId);
                String unitIdString = String.valueOf(unitId);
                String sql = HistoryFastLaneWriter.appendStringsToLowerCase("UPDATE ", table.getHistoryTable().getName(), " c SET group_history_id = ", groupHistoryIdString, " WHERE c.", table.getHistoryUnitIdColumn().getName(), "= ", unitIdString);
                log.debug((Object)("Executed SQL: " + sql));
                int updatedCount = statement.executeUpdate(sql);
                log.debug((Object)("Updated rows: " + updatedCount));
                if (table.getHelperTable() == null || table.getHelperTable() == table.getHistoryTable()) continue;
                sql = HistoryFastLaneWriter.appendStringsToLowerCase("UPDATE ", table.getHelperTable().getName(), " c SET group_history_id = ", groupHistoryIdString, " WHERE c.", table.getHelperUnitIdColumn().getName(), " = ", unitIdString);
                log.debug((Object)("Executed SQL: " + sql));
                updatedCount = statement.executeUpdate(sql);
                log.debug((Object)("Updated rows: " + updatedCount));
            }
            stopwatch.stop("Database access", true);
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
        }
        stopwatch.stop("Overall", true);
    }
}

