/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.common.dataSelection;

import de.proveo.wwt.datamodel.unit.identity.UnitIdentity;
import de.proveo.wwt.datamodel.unit.model.UnitModel;
import de.proveo.wwt.datamodel.unit.typeIdentity.UnitTypeIdentity;
import de.proveo.wwt.logic.web.common.dataSelection.ReportSelectionDTO;
import de.proveo.wwt.logic.web.common.dataSelection.filter.IUnitFilter;
import de.proveo.wwt.logic.web.common.dto.DTOFactory;
import de.proveo.wwt.logic.web.common.dto.UnitContainerComparator;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.joda.time.Interval;

public class UnitReportSelectionDTO
extends ReportSelectionDTO {
    private List<UnitDTO> unitDTOs = new ArrayList<UnitDTO>();
    private boolean useGroupHistory;
    private List<IUnitFilter> unitFilters = new ArrayList<IUnitFilter>();

    public UnitReportSelectionDTO(Interval interval, List<UnitDTO> unitDTOs, boolean useGroupHistory) {
        super(interval);
        if (unitDTOs != null) {
            this.unitDTOs = unitDTOs;
        }
        this.useGroupHistory = useGroupHistory;
    }

    @Override
    public boolean isBasic() {
        return this.getCount() == 1 && this.unitDTOs.get(0) != null && this.unitDTOs.get(0).isBasic();
    }

    @Override
    public boolean isAllSelected() {
        return this.getCount() == 1 && (this.unitDTOs.get(0) == null || this.unitDTOs.get(0).getUnitId() == null);
    }

    @Override
    public int getCount() {
        return this.unitDTOs.size();
    }

    public List<UnitDTO> getUnitDTOs() {
        return this.unitDTOs;
    }

    public boolean isUseGroupHistory() {
        return this.useGroupHistory;
    }

    public void setUseGroupHistory(boolean uGH) {
        this.useGroupHistory = uGH;
    }

    public UnitDTO getUnitDTO() {
        if (this.getCount() == 1) {
            return this.unitDTOs.get(0);
        }
        UnitModel unitModel = new UnitModel();
        unitModel.setUnitId(0L);
        UnitIdentity unitIdentity = new UnitIdentity();
        unitIdentity.setName("multi");
        UnitTypeIdentity unitTypeIdentity = new UnitTypeIdentity();
        UnitDTO unitDTO = DTOFactory.buildUnitDTO(unitModel, unitIdentity, unitTypeIdentity);
        return unitDTO;
    }

    @Override
    public ReportSelectionDTO copy() {
        return new UnitReportSelectionDTO(this.interval, this.unitDTOs, this.useGroupHistory);
    }

    public List<Long> getUnitIds() {
        ArrayList<Long> unitIds = new ArrayList<Long>();
        for (UnitDTO m : this.getUnitDTOs()) {
            unitIds.add(m.getUnitId());
        }
        return unitIds;
    }

    @Override
    public String getName() {
        StringBuilder result = new StringBuilder();
        if (this.unitDTOs.isEmpty()) {
            return "all";
        }
        Collections.sort(this.unitDTOs, new UnitContainerComparator(UnitContainerComparator.CompareType.UNIT_BASIC, UnitContainerComparator.CompareType.UNIT_NAME));
        if (this.isBasic()) {
            UnitDTO dto = this.getUnitDTO();
            result.append(dto.getUnitName());
            result.append(" - ");
            result.append(dto.getUnitTypeName());
        } else {
            for (UnitDTO dto : this.unitDTOs) {
                result.append(dto.getUnitName());
                result.append(", ");
            }
            result.replace(result.length() - 2, result.length(), "");
        }
        return result.toString();
    }

    public void addUnitFilter(IUnitFilter filter) {
        this.unitFilters.add(filter);
    }

    public void removeAllUnitFilters() {
        this.unitFilters.clear();
    }

    public List<IUnitFilter> getUnitFilters() {
        return this.unitFilters;
    }
}

