/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.interfaces.telemetryData.util;

import de.proveo.wwt.datamodel.unit.model.UnitModel;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacadeLocal;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.UnitDataValue;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import java.util.HashMap;
import javax.ejb.FinderException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class UnitHelper {
    private static final Log log = LogFactory.getLog(UnitHelper.class);
    public static final long VALIDITY_DURATION = 3600000L;
    private static HashMap<Long, UnitDataValue> unitDataValues = null;
    private static UnitFacadeLocal unitFacade = null;

    private UnitHelper() {
    }

    public static String getUnitName(long unitId) {
        String unitName = "";
        UnitDataValue data = UnitHelper.getUnit(unitId);
        if (data != null && data.getUnitName() != null) {
            unitName = data.getUnitName();
        }
        return unitName;
    }

    public static String getCustomerUnitId(long unitId) {
        String customerUnitId = "";
        UnitDataValue data = UnitHelper.getUnit(unitId);
        if (data != null && data.getCustomerUnitId() != null) {
            customerUnitId = data.getCustomerUnitId();
        }
        return customerUnitId;
    }

    public static long getUnitId(String unitName) throws FinderException {
        return unitFacade.getUnitDTO(unitName).getUnitId();
    }

    public static String getModelType(long unitId) {
        String modelType = "";
        UnitDataValue data = UnitHelper.getUnit(unitId);
        if (data != null && data.getModelType() != null) {
            modelType = data.getModelType();
        }
        return modelType;
    }

    public static boolean isSendData(long unitId) {
        boolean sendData = false;
        UnitDataValue data = UnitHelper.getUnit(unitId);
        if (data != null) {
            sendData = data.isSendData();
        }
        return sendData;
    }

    protected static UnitDataValue getUnit(long unitId) {
        UnitDataValue unitDataValue;
        if (unitDataValues == null || unitFacade == null) {
            UnitHelper.init();
        }
        if ((unitDataValue = unitDataValues.get(unitId)) == null || System.currentTimeMillis() - unitDataValue.getTimestamp() > 3600000L) {
            UnitDTO unitData = unitFacade.getUnitDTO(unitId);
            if (unitData != null) {
                UnitModel unitModelValue = unitData.getUnitModel();
                unitDataValue = new UnitDataValue(System.currentTimeMillis(), unitData.getUnitName(), unitModelValue.getCustomerUnitId(), unitModelValue.getModelType(), unitModelValue.getSendData());
                unitDataValues.put(unitId, unitDataValue);
            } else {
                log.debug((Object)("could not find unit " + unitId));
            }
        }
        return unitDataValue;
    }

    private static void init() {
        log.debug((Object)"init()");
        unitDataValues = new HashMap();
        try {
            InitialContext context = new InitialContext();
            unitFacade = (UnitFacadeLocal)context.lookup("rts/UnitFacade/local");
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
    }
}

