/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.interfaces.telemetryData.util;

import de.proveo.rts.configuration.interfaces.telemetryData.TelemetryDataConfigurationServiceMBean;
import de.proveo.util.service.ServiceFactory;
import de.proveo.util.service.ServiceInstantiationException;
import de.proveo.util.service.ServiceNotFoundException;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationClient;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationParameterNotFoundException;
import de.proveo.wwt.logic.ejb.interfaces.InterfaceConfiguration;
import java.rmi.RemoteException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class TDIConfiguration
extends InterfaceConfiguration {
    private static final Log log = LogFactory.getLog(TDIConfiguration.class);
    private static TDIConfiguration INSTANCE = new TDIConfiguration();
    private static ConfigurationClient configuration = new ConfigurationClient();
    private static TelemetryDataConfigurationServiceMBean telemetryDataConfigurationServiceMBean;
    private final String PREFIX_NAME = "telemetryDataPrefix";
    private final String DEFAULT_PREFIX = "de.proveo.telemetry.";
    private String prefix = null;

    private TDIConfiguration() {
        this.init();
    }

    public static TDIConfiguration getInstance() {
        return INSTANCE;
    }

    public boolean isTelemetryDataActive() {
        return telemetryDataConfigurationServiceMBean.isTelemetryDataActive();
    }

    @Override
    public boolean isInterfaceActive() {
        return this.isTelemetryDataActive();
    }

    public boolean isClientRegistered() {
        return telemetryDataConfigurationServiceMBean.isClientRegistered();
    }

    public void setClientRegistered(boolean registered) {
        telemetryDataConfigurationServiceMBean.setClientRegistered(registered);
    }

    public boolean isPingReceived() {
        return telemetryDataConfigurationServiceMBean.isPingReceived();
    }

    public void setPingReceived(boolean pingReceived) {
        telemetryDataConfigurationServiceMBean.setPingReceived(pingReceived);
    }

    public int getPingErrorCount() {
        return telemetryDataConfigurationServiceMBean.getPingErrorCount();
    }

    public void setPingErrorCount(int pingErrorCount) {
        telemetryDataConfigurationServiceMBean.setPingErrorCount(pingErrorCount);
    }

    public void incPingErrorCount() {
        telemetryDataConfigurationServiceMBean.incPingErrorCount();
    }

    public boolean isMessageSenderStopped() {
        return telemetryDataConfigurationServiceMBean.isMessageSenderStopped();
    }

    public void setMessageSenderStopped(boolean messageSenderStopped) {
        telemetryDataConfigurationServiceMBean.setMessageSenderStopped(messageSenderStopped);
    }

    public boolean isIgnoreMessages() {
        return telemetryDataConfigurationServiceMBean.isIgnoreMessages();
    }

    public void setIgnoreMessages(boolean ignoreMessages) {
        telemetryDataConfigurationServiceMBean.setIgnoreMessages(ignoreMessages);
    }

    public boolean isOnMessageRunning() {
        return telemetryDataConfigurationServiceMBean.isOnMessageRunning();
    }

    public void setOnMessageRunning(boolean onMessageRunning) {
        telemetryDataConfigurationServiceMBean.setOnMessageRunning(onMessageRunning);
    }

    @Override
    protected String getPrefix() {
        if (this.prefix == null) {
            try {
                this.prefix = configuration.getParameter("telemetryDataPrefix");
            }
            catch (RemoteException e) {
                log.error((Object)"runs into", (Throwable)e);
                this.prefix = "de.proveo.telemetry.";
            }
            catch (ConfigurationParameterNotFoundException e) {
                log.warn((Object)"Could not find parameter telemetryDataPrefix. Use default prefix de.proveo.telemetry.");
                this.prefix = "de.proveo.telemetry.";
            }
        }
        return this.prefix;
    }

    @Override
    protected void init() {
        log.debug((Object)"init");
        try {
            telemetryDataConfigurationServiceMBean = (TelemetryDataConfigurationServiceMBean)ServiceFactory.getInstance().getService(TelemetryDataConfigurationServiceMBean.class);
        }
        catch (ServiceNotFoundException e) {
            log.error((Object)"init runs into", (Throwable)e);
        }
        catch (ServiceInstantiationException e) {
            log.error((Object)"init runs into", (Throwable)e);
        }
    }
}

