/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.interfaces.telemetryData.tto;

import de.proveo.util.geo.GPSPosition;
import de.proveo.wwt.datamodel.geo.GdataBase;
import de.proveo.wwt.datamodel.geo.GdataCache;
import de.proveo.wwt.datamodel.geo.GdataHistory;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.tto.TTO;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.Enums;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.UnitHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GeoTTO
extends TTO {
    private static final Log log = LogFactory.getLog(GeoTTO.class);
    protected String area;
    protected double latitude;
    protected double longitude;
    protected long timestamp;
    protected double x;
    protected double y;

    public GeoTTO(GdataBase gdata) {
        if (gdata.getArea() != null) {
            this.area = gdata.getArea().getArea();
        }
        GPSPosition gps = new GPSPosition(gdata.getRmcRec(), gdata.getGgaRec(), gdata.getTrusted());
        this.latitude = (double)gps.getLatitudeMSec() / 3600000.0;
        this.longitude = (double)gps.getLongitudeMSec() / 3600000.0;
        this.latitude = this.round(this.latitude, 6);
        this.longitude = this.round(this.longitude, 6);
        this.timestamp = gdata.getBeginTime();
        this.calculateGaussKrueger(this.latitude, this.longitude);
        if (gdata instanceof GdataCache) {
            this.historyId = ((GdataCache)gdata).getHistoryId();
        }
        if (gdata instanceof GdataHistory) {
            this.historyId = ((GdataHistory)gdata).getId();
        }
        this.unitId = gdata.getUnitId();
        this.customerUnitId = UnitHelper.getCustomerUnitId(this.unitId);
        this.unitName = UnitHelper.getUnitName(this.unitId);
        this.eventType = Enums.EventType.GEO;
    }

    private void calculateGaussKrueger(double b, double l) {
        if (this.config.getBoolean("xml.telemetryDataMessage.gkCoords.active")) {
            double metersPerDegreeX = this.config.getDouble("plugins.fmg.client.gausskrueger.metersPerDegreeX");
            double metersPerDegreeY = this.config.getDouble("plugins.fmg.client.gausskrueger.metersPerDegreeY");
            double b0 = this.config.getDouble("plugins.fmg.client.gausskrueger.b0");
            double l0 = this.config.getDouble("plugins.fmg.client.gausskrueger.l0");
            double x0 = this.config.getDouble("plugins.fmg.client.gausskrueger.x0");
            double y0 = this.config.getDouble("plugins.fmg.client.gausskrueger.y0");
            this.x = metersPerDegreeX * (b - b0) + x0;
            this.y = metersPerDegreeY * (l - l0) + y0;
        }
    }
}

