/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.interfaces.maintenance.xml;

import de.proveo.wwt.logic.ejb.interfaces.maintenance.jaxb.server.MaintServerMsg;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.jaxb.server.ObjectFactory;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.xml.ErrorCodes;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.xml.ServerMsgWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ErrorWrapper
extends ServerMsgWrapper {
    private static final Log log = LogFactory.getLog(ErrorWrapper.class);

    public ErrorWrapper(Long msgId, ErrorCodes errorCode, String detail) {
        this.serverMsg.setSuccessful(false);
        this.serverMsg.setId(msgId);
        ObjectFactory objectFactory = new ObjectFactory();
        MaintServerMsg.Error error = objectFactory.createMaintServerMsgError();
        switch (errorCode) {
            case UnitNotFound: {
                error.setCode("UnitNotFound");
                error.setMessage("Could not find unit: " + detail);
                break;
            }
            case UnknownReason: {
                error.setCode("UnknownReason");
                error.setMessage("Unknown reason: " + detail);
                break;
            }
            case TimeFormat: {
                error.setCode("TimeFormat");
                error.setMessage("Incorrect time format: " + detail);
                break;
            }
            case MissingMethod: {
                error.setCode("MissingMethod");
                error.setMessage("XML message doesn't contain a setServiceStatus or getEngineHours element");
                break;
            }
            case MissingParameter: {
                error.setCode("MissingParameter");
                error.setMessage("Parameter is missing: " + detail);
                break;
            }
            case XMLParse: {
                error.setCode("XMLParse");
                error.setMessage("Could not parse XML: " + detail);
                break;
            }
            case XMLResponse: {
                error.setCode("XMLResponse");
                error.setMessage("Could not create response: " + detail);
                break;
            }
            case SynchronizationTimeout: {
                error.setCode("synchronizationTimeout");
                error.setMessage("Timeout while synchronization: " + detail);
                break;
            }
            case NotRegistered: {
                error.setCode("NotRegistered");
                error.setMessage("Client is not registered.");
                break;
            }
            case InterfaceNotActive: {
                error.setCode("InterfaceNotActive");
                error.setMessage("Maintenance interface is not active!");
                break;
            }
            case Unknown: {
                error.setCode("Unknown");
                error.setMessage("An error has occurred:  " + detail);
            }
        }
        this.serverMsg.setError(error);
    }
}

