/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.interfaces.maintenance.notify;

import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.wwt.datamodel.notify.NotifyHistory;
import de.proveo.wwt.logic.ejb.dataIn.notify.NotifyFacadeLocal;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.MIConfiguration;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.MITimestamp;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.exceptions.UnknownNotifyException;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.jaxb.server.MaintServerMsg;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.jaxb.server.ObjectFactory;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.UnitHelper;
import de.proveo.wwt.logic.web.historyData.dto.NotificationDTO;
import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MessageHelper {
    private static final Log log = LogFactory.getLog(MessageHelper.class);
    private static MIConfiguration config = MIConfiguration.getInstance();

    public static SerializableEventWrapper getSerializableEventWrapper(Message msg) {
        try {
            Serializable _object = ((ObjectMessage)msg).getObject();
            SerializableEventWrapper wrapper = (SerializableEventWrapper)_object;
            return wrapper;
        }
        catch (JMSException e) {
            log.error((Object)"runs into", (Throwable)e);
            return null;
        }
    }

    public static long getMessageId(Message msg) {
        SerializableEventWrapper wrapper = MessageHelper.getSerializableEventWrapper(msg);
        if (wrapper.get_typeOfEvent().equals("InfomanNotifyMessages")) {
            return wrapper.get_notifyHistoryId();
        }
        return 0L;
    }

    public static boolean isSendData(Message msg) {
        SerializableEventWrapper wrapper = MessageHelper.getSerializableEventWrapper(msg);
        if (wrapper.get_typeOfEvent().equals("InfomanNotifyMessages")) {
            NotifyHistory stateHistory = (NotifyHistory)wrapper.get_historyValue();
            return UnitHelper.isSendData(stateHistory.getUnitId());
        }
        log.error((Object)"the message contains an invalid event type");
        return false;
    }

    public static MaintServerMsg.NotifyMessage createNotifyMessage(NotifyHistory notifyHistory) throws UnknownNotifyException {
        long historyId = notifyHistory.getId();
        long notifyTypeId = notifyHistory.getMessageId();
        MITimestamp timestamp = new MITimestamp(notifyHistory.getReceiveTime());
        String remark = notifyHistory.getRemark();
        long unitId = notifyHistory.getUnitId();
        return MessageHelper.createNotifyMessage(historyId, unitId, notifyTypeId, timestamp, remark);
    }

    public static MaintServerMsg.NotifyMessage createNotifyMessage(NotificationDTO notificationDTO) throws UnknownNotifyException {
        long historyId = notificationDTO.getId();
        long notifyTypeId = notificationDTO.getMessageId();
        MITimestamp timestamp = new MITimestamp(notificationDTO.getReceiveTime());
        String remark = notificationDTO.getRemark();
        long unitId = notificationDTO.getUnitId();
        return MessageHelper.createNotifyMessage(historyId, unitId, notifyTypeId, timestamp, remark);
    }

    private static MaintServerMsg.NotifyMessage createNotifyMessage(long historyId, long unitId, long notifyTypeId, MITimestamp timestamp, String remark) throws UnknownNotifyException {
        String customerUnitId = UnitHelper.getCustomerUnitId(unitId);
        String unitName = UnitHelper.getUnitName(unitId);
        NotifyFacadeLocal notifyFacade = null;
        try {
            InitialContext ctx = new InitialContext();
            notifyFacade = (NotifyFacadeLocal)ctx.lookup("rts/NotifyFacade/local");
        }
        catch (NamingException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        ObjectFactory objFactory = new ObjectFactory();
        MaintServerMsg.NotifyMessage notifyMessage = objFactory.createMaintServerMsgNotifyMessage();
        notifyMessage.setMessageID(historyId);
        notifyMessage.setCustomerID(customerUnitId);
        notifyMessage.setProveoID(unitId);
        notifyMessage.setUnitName(unitName);
        MaintServerMsg.NotifyMessage.NotifyField notifyField = objFactory.createMaintServerMsgNotifyMessageNotifyField();
        notifyField.setTimestamp(timestamp.toString());
        notifyField.setRemark(remark);
        if (MessageHelper.sendNotifyWithId(notifyTypeId)) {
            if (notifyFacade != null) {
                String notificationText = notifyFacade.getNotificationTextById(notifyTypeId);
                if (notificationText != null) {
                    notifyField.setNotificationText(notificationText);
                } else {
                    notifyField.setNotificationText(config.getString("notify.unknown.text") + " " + notifyTypeId);
                }
            }
        } else {
            throw new UnknownNotifyException(notifyTypeId);
        }
        notifyMessage.setNotifyField(notifyField);
        return notifyMessage;
    }

    private static boolean sendNotifyWithId(long id) {
        long[] ids = config.getLongArray("notify.messageIdList");
        if (ids.length == 1) {
            if (ids[0] == -1L) {
                return false;
            }
            if (ids[0] == 0L) {
                return true;
            }
        }
        for (long l : ids) {
            if (l != id) continue;
            return true;
        }
        return false;
    }
}

