/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.general.tableMappings.readers;

import de.proveo.wwt.logic.ejb.general.tableMappings.annotations.PerformanceCounterClass;
import de.proveo.wwt.logic.ejb.general.tableMappings.annotations.PerformanceCounterTableMapping;
import java.awt.Color;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PerformanceCounterAnnotationReader {
    private static final Log log = LogFactory.getLog(PerformanceCounterAnnotationReader.class);

    private static PerformanceCounterTableMapping getMappingAnnotation(Enum<?> e) {
        PerformanceCounterTableMapping result = null;
        try {
            result = e.getDeclaringClass().getDeclaredField(e.name()).getAnnotation(PerformanceCounterTableMapping.class);
        }
        catch (NoSuchFieldException ex) {
            log.error((Object)"PerformanceCounterTableMapping annotation not found!");
        }
        return result;
    }

    public static <T extends Enum<T>> PerformanceCounterClass getClassAnnotation(Class<T> e) {
        PerformanceCounterClass result = null;
        try {
            result = e.getAnnotation(PerformanceCounterClass.class);
        }
        catch (Exception ex) {
            log.error((Object)"PerformanceCounterClass annotation not found!");
        }
        return result;
    }

    public static String getTable(Enum<?> e) {
        PerformanceCounterTableMapping annotation = PerformanceCounterAnnotationReader.getMappingAnnotation(e);
        return annotation != null ? annotation.table() : null;
    }

    public static String getColumn(Enum<?> e) {
        PerformanceCounterTableMapping annotation = PerformanceCounterAnnotationReader.getMappingAnnotation(e);
        return annotation != null ? annotation.column() : null;
    }

    public static String getCounterColumn(Enum<?> e) {
        PerformanceCounterTableMapping annotation = PerformanceCounterAnnotationReader.getMappingAnnotation(e);
        return annotation != null ? annotation.counterColumn() : null;
    }

    public static String getUnitIdColumn(Enum<?> e) {
        PerformanceCounterTableMapping annotation = PerformanceCounterAnnotationReader.getMappingAnnotation(e);
        return annotation != null ? annotation.unitIdColumn() : null;
    }

    public static String getWhereClause(Enum<?> e) {
        PerformanceCounterTableMapping annotation = PerformanceCounterAnnotationReader.getMappingAnnotation(e);
        return annotation != null ? annotation.whereClause() : null;
    }

    public static String getAggregationSql(Enum<?> e) {
        PerformanceCounterTableMapping annotation = PerformanceCounterAnnotationReader.getMappingAnnotation(e);
        return annotation != null ? annotation.aggregationSql() : null;
    }

    public static Color getColor(Enum<?> e) {
        PerformanceCounterTableMapping annotation = PerformanceCounterAnnotationReader.getMappingAnnotation(e);
        Color result = Color.BLACK;
        boolean errorOccured = false;
        if (annotation != null) {
            String color = annotation.color();
            if (color == null || color != null && color.length() != 6) {
                errorOccured = true;
            } else {
                try {
                    int colorValue = 0;
                    for (int i = 0; i != 3; ++i) {
                        colorValue |= Integer.parseInt(color.substring(i * 2, i * 2 + 2), 16) << (2 - i) * 8;
                    }
                    result = new Color(colorValue);
                }
                catch (NumberFormatException ex) {
                    errorOccured = true;
                }
            }
        }
        if (errorOccured) {
            log.error((Object)"Invalid color string passed to PerformanceCounterTableMapping Annotation. Must be a hexadecimal RGB string (i.e. 'FFFFFF' for white).");
        }
        return result;
    }

    public static <T extends Enum<T>> long getIntervalDuration(Class<T> e) {
        PerformanceCounterClass annotation = PerformanceCounterAnnotationReader.getClassAnnotation(e);
        return annotation != null ? annotation.intervalDuration() : -1L;
    }

    public static <T extends Enum<T>> String getTableName(Class<T> e) {
        PerformanceCounterClass annotation = PerformanceCounterAnnotationReader.getClassAnnotation(e);
        return annotation != null ? annotation.tableName() : null;
    }

    public static boolean supportsUnits(Enum<?> e) {
        return PerformanceCounterAnnotationReader.supportsUnits(e.getDeclaringClass());
    }

    public static <T extends Enum<T>> boolean supportsUnits(Class<T> e) {
        PerformanceCounterClass annotation = PerformanceCounterAnnotationReader.getClassAnnotation(e);
        return annotation != null ? Boolean.valueOf(annotation.supportsUnits()) : null;
    }

    public static <T extends Enum<T>> Class<?> getTypeClass(Class<T> e) {
        PerformanceCounterClass annotation = PerformanceCounterAnnotationReader.getClassAnnotation(e);
        return annotation != null ? annotation.typeClass() : null;
    }
}

