/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.general.performanceCounter;

import de.proveo.wwt.logic.ejb.general.performanceCounter.PerformanceCounterResultBase;
import de.proveo.wwt.logic.ejb.general.tableMappings.readers.PerformanceCounterAnnotationReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class PerformanceCounterResult<E extends Enum<E>>
extends PerformanceCounterResultBase<E>
implements Serializable {
    private static final long serialVersionUID = -4387241666236234339L;
    public List<Long> timestampRows;
    public List<Long> sumRows;
    public HashMap<Enum<E>, List<Long>> statisticsMap;
    public long eventSumTotal;
    public HashMap<Enum<E>, Long> eventSumTotalMap;

    public PerformanceCounterResult() {
    }

    public PerformanceCounterResult(long interval) {
        this.interval = interval;
    }

    @Override
    protected Set<Enum<E>> getKeyEnums() {
        return this.statisticsMap.keySet();
    }

    public List<HashMap<String, Long>> generateStatisticsDto() {
        if (this.statisticsMap == null) {
            return null;
        }
        Object[] values = this.statisticsMap.values().toArray();
        int listSize = ((List)values[0]).size();
        ArrayList<HashMap<String, Long>> dtoList = new ArrayList<HashMap<String, Long>>(listSize);
        for (int i = 0; i != listSize; ++i) {
            dtoList.add(new HashMap());
        }
        Set<Enum<E>> keySet = this.statisticsMap.keySet();
        for (Enum<E> currentColumnId : keySet) {
            List<Long> currentArray = this.statisticsMap.get(currentColumnId);
            int size = currentArray.size();
            for (int i = 0; i != size; ++i) {
                HashMap<String, Long> currentMap = dtoList.get(i);
                String counterColumn = PerformanceCounterAnnotationReader.getCounterColumn(currentColumnId);
                currentMap.put(counterColumn, currentArray.get(i));
            }
        }
        int size = this.sumRows.size();
        for (int i = 0; i != size; ++i) {
            HashMap<String, Long> currentMap = dtoList.get(i);
            currentMap.put("EVENT_SUM", this.sumRows.get(i));
            currentMap.put("TIMESTAMP", this.timestampRows.get(i));
        }
        return dtoList;
    }

    public HashMap<String, Long> generateEventSumTotalDto() {
        if (this.eventSumTotalMap == null) {
            return null;
        }
        Set<Enum<E>> keySet = this.eventSumTotalMap.keySet();
        Iterator<Enum<E>> keyIterator = keySet.iterator();
        HashMap<String, Long> dtoMap = new HashMap<String, Long>();
        while (keyIterator.hasNext()) {
            Enum<E> currentColumnId = keyIterator.next();
            String counterColumn = PerformanceCounterAnnotationReader.getCounterColumn(currentColumnId);
            dtoMap.put(counterColumn, this.eventSumTotalMap.get(currentColumnId));
        }
        dtoMap.put("EVENT_SUM", this.eventSumTotal);
        return dtoMap;
    }
}

