/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.general.kml.unit;

import de.micromata.opengis.kml.v_2_2_0.Document;
import de.micromata.opengis.kml.v_2_2_0.Feature;
import de.micromata.opengis.kml.v_2_2_0.Geometry;
import de.micromata.opengis.kml.v_2_2_0.Icon;
import de.micromata.opengis.kml.v_2_2_0.IconStyle;
import de.micromata.opengis.kml.v_2_2_0.Kml;
import de.micromata.opengis.kml.v_2_2_0.Placemark;
import de.micromata.opengis.kml.v_2_2_0.Point;
import de.micromata.opengis.kml.v_2_2_0.Style;
import de.micromata.opengis.kml.v_2_2_0.StyleSelector;
import de.proveo.util.kml.KmlUtil;
import de.proveo.util.kml.structs.GeoPoint;
import de.proveo.util.kml.structs.UnitInfo;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationLocal;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacadeLocal;
import de.proveo.wwt.logic.web.common.dataSelection.ReportSelectionDTO;
import de.proveo.wwt.logic.web.common.dto.ReportDTOListBase;
import de.proveo.wwt.logic.web.currentData.CurrentDataFacadeLocal;
import de.proveo.wwt.logic.web.data.enumerations.ExtendedDTOData;
import de.proveo.wwt.logic.web.historyData.HistoryDataFacadeLocal;
import de.proveo.wwt.logic.web.historyData.dto.PositionDTO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import javax.naming.InitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UnitExport {
    private static final Log log = LogFactory.getLog(UnitExport.class);
    private static final String DOCUMENT_NAME = "Units";
    public static final String IMAGE_PREFIX = "../../images/units/airportmap/128/";
    public static final String IMAGE_SUFFIX = ".png";
    private HashMap<String, Style> styles = new HashMap();
    protected ReportDTOListBase<PositionDTO> dataList;
    protected CurrentDataFacadeLocal currentDataFacade;
    protected UnitFacadeLocal unitFacade;
    protected HistoryDataFacadeLocal historyDataFacade;
    protected ConfigurationLocal configuration;

    protected String getDocName() {
        return DOCUMENT_NAME;
    }

    public UnitExport() {
        try {
            InitialContext context = new InitialContext();
            this.currentDataFacade = (CurrentDataFacadeLocal)context.lookup("rts/CurrentDataFacade/local");
            this.unitFacade = (UnitFacadeLocal)context.lookup("rts/UnitFacade/local");
            this.historyDataFacade = (HistoryDataFacadeLocal)context.lookup("rts/HistoryDataFacade/local");
            this.configuration = (ConfigurationLocal)context.lookup("rts/Configuration/local");
        }
        catch (Exception e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
    }

    public byte[] exportPosition(ReportSelectionDTO selectionDTO) {
        Kml kml = new Kml();
        Document doc = kml.createAndSetDocument();
        doc.setName(this.getDocName());
        doc.setVisibility(Boolean.valueOf(true));
        for (UnitInfo info : this.getUnitInfo(selectionDTO)) {
            doc.addToFeature((Feature)UnitExport.generatePlacemark(info));
            this.addStyle(UnitExport.generateStyle(info));
        }
        for (Style style : this.styles.values()) {
            doc.addToStyleSelector((StyleSelector)style);
        }
        return KmlUtil.serialize((Kml)kml);
    }

    protected static Placemark generatePlacemark(UnitInfo info) {
        Point point = KmlUtil.createPoint((GeoPoint)info.point);
        Placemark placemark = new Placemark();
        placemark.setId(String.valueOf(info.id));
        placemark.setName(info.name);
        placemark.setDescription(info.description);
        placemark.setGeometry((Geometry)point);
        placemark.setStyleUrl("#" + info.styleUrl);
        return placemark;
    }

    protected static Style generateStyle(UnitInfo info) {
        Icon icon = new Icon();
        icon.setHref(IMAGE_PREFIX + info.styleUrl + IMAGE_SUFFIX);
        IconStyle iconStyle = new IconStyle();
        iconStyle.setScale(2.0);
        iconStyle.setIcon(icon);
        Style style = new Style();
        style.setIconStyle(iconStyle);
        style.setId(info.styleUrl);
        return style;
    }

    private void addStyle(Style style) {
        if (this.styles.get(style.getId()) == null) {
            this.styles.put(style.getId(), style);
        }
    }

    protected UnitInfo[] getUnitInfo(ReportSelectionDTO selectionDTO) {
        ArrayList<UnitInfo> unitInfoList = new ArrayList<UnitInfo>();
        this.dataList = this.currentDataFacade.getCurrentPositionData(selectionDTO, ExtendedDTOData.getNOTHING());
        for (PositionDTO dto : this.dataList) {
            long latitude = dto.getGPSPosition().getLatitudeMSec();
            long longitude = dto.getGPSPosition().getLongitudeMSec();
            if (latitude == 0L && longitude == 0L || !dto.getUnitModel().getAirportmapVisible()) continue;
            GeoPoint point = new GeoPoint(latitude, longitude);
            UnitInfo info = new UnitInfo();
            info.id = dto.getUnitId();
            info.name = dto.getUnitName();
            info.description = null;
            info.styleUrl = dto.getUnit().getUnitTypeIdentity().getImageType().getName();
            info.point = point;
            unitInfoList.add(info);
        }
        Collections.sort(unitInfoList, new Comparator<UnitInfo>(){

            @Override
            public int compare(UnitInfo o1, UnitInfo o2) {
                if (o1 == null || o2 == null || o1.name == null || o2.name == null) {
                    return 0;
                }
                return o1.name.compareTo(o2.name);
            }
        });
        return unitInfoList.toArray(new UnitInfo[unitInfoList.size()]);
    }

    public ReportDTOListBase<PositionDTO> getDataList() {
        return this.dataList;
    }
}

