/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.general.kml.unit;

import de.micromata.opengis.kml.v_2_2_0.Data;
import de.micromata.opengis.kml.v_2_2_0.Document;
import de.micromata.opengis.kml.v_2_2_0.ExtendedData;
import de.micromata.opengis.kml.v_2_2_0.Feature;
import de.micromata.opengis.kml.v_2_2_0.Geometry;
import de.micromata.opengis.kml.v_2_2_0.Kml;
import de.micromata.opengis.kml.v_2_2_0.Placemark;
import de.micromata.opengis.kml.v_2_2_0.Point;
import de.micromata.opengis.kml.v_2_2_0.PolyStyle;
import de.micromata.opengis.kml.v_2_2_0.Style;
import de.micromata.opengis.kml.v_2_2_0.StyleSelector;
import de.proveo.util.kml.KmlUtil;
import de.proveo.util.kml.structs.GeoPoint;
import de.proveo.util.kml.structs.UnitInfo;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationParameterNotFoundException;
import de.proveo.wwt.logic.ejb.general.kml.unit.UnitExport;
import de.proveo.wwt.logic.web.common.dataSelection.ReportSelectionDTO;
import de.proveo.wwt.logic.web.common.dto.ReportDTOBaseComparator;
import de.proveo.wwt.logic.web.data.enumerations.ExtendedDTOData;
import de.proveo.wwt.logic.web.historyData.dto.PositionDTO;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PositionDataExport
extends UnitExport {
    private static final Log log = LogFactory.getLog(PositionDataExport.class);
    private static final String DOCUMENT_NAME = "Position";
    public static final String BEGINTIME = "bt";
    public static final String POSITION = "pos";
    public static final String IMAGE = "img";
    public static final String SPEED_KMH = "kmh";
    public static final String SPEED_MPH = "mph";
    private int currColorIndex = 0;
    private List<Color> colors = new ArrayList<Color>();

    @Override
    protected String getDocName() {
        return DOCUMENT_NAME;
    }

    public byte[] export() {
        return this.export(null);
    }

    public PositionDataExport() {
        String parameter;
        try {
            parameter = this.configuration.getParameter("de.proveo.rts.web.map.tracemarkColors");
        }
        catch (ConfigurationParameterNotFoundException e) {
            log.warn((Object)"No configured colors for map, using default");
            parameter = "0,0,255;";
        }
        for (String colorValues : parameter.split(";")) {
            if (colorValues.isEmpty()) continue;
            String[] rgbValues = colorValues.split(",");
            this.colors.add(new Color(Integer.parseInt(rgbValues[0]), Integer.parseInt(rgbValues[1]), Integer.parseInt(rgbValues[2])));
        }
    }

    private Color generateColor(Long unitId) {
        if (this.currColorIndex >= this.colors.size()) {
            this.currColorIndex = 0;
        }
        return this.colors.get(this.currColorIndex++);
    }

    public byte[] export(ReportSelectionDTO selectionDTO) {
        Kml kml = new Kml();
        Document doc = kml.createAndSetDocument();
        doc.setName(this.getDocName());
        doc.setVisibility(Boolean.valueOf(true));
        ArrayList<Long> unitIds = new ArrayList<Long>();
        for (UnitInfo info : this.getInfo(selectionDTO)) {
            doc.addToFeature((Feature)PositionDataExport.generatePlacemark(info));
            if (unitIds.contains(info.id)) continue;
            unitIds.add(info.id);
        }
        this.currColorIndex = 0;
        for (Long unitId : unitIds) {
            Style style = new Style();
            PolyStyle ps = new PolyStyle();
            Color color = this.generateColor(unitId);
            ps.setColor(KmlUtil.kmlColor((Color)color));
            style.setPolyStyle(ps);
            style.setId(String.valueOf(unitId));
            doc.addToStyleSelector((StyleSelector)style);
        }
        return KmlUtil.serialize((Kml)kml);
    }

    protected static Placemark generatePlacemark(UnitInfo info) {
        Point point = KmlUtil.createPoint((GeoPoint)info.point);
        Placemark placemark = new Placemark();
        placemark.setId(String.valueOf(info.id));
        placemark.setName(info.name);
        placemark.setGeometry((Geometry)point);
        String timestamp = (String)info.data.get(BEGINTIME);
        String position = (String)info.data.get(POSITION);
        String image = (String)info.data.get(IMAGE);
        String speedKmh = (String)info.data.get(SPEED_KMH);
        String speedMph = (String)info.data.get(SPEED_MPH);
        ExtendedData extData = new ExtendedData();
        Data timestampData = new Data("");
        timestampData.setName("timestamp");
        timestampData.setValue(timestamp);
        extData.addToData(timestampData);
        Data positionData = new Data("");
        positionData.setName("position");
        positionData.setValue(position);
        extData.addToData(positionData);
        Data imageData = new Data("");
        imageData.setName("image");
        imageData.setValue(image);
        extData.addToData(imageData);
        Data kmhData = new Data("");
        kmhData.setName(SPEED_KMH);
        kmhData.setValue(speedKmh);
        extData.addToData(kmhData);
        Data mphData = new Data("");
        mphData.setName(SPEED_MPH);
        mphData.setValue(speedMph);
        extData.addToData(mphData);
        placemark.setExtendedData(extData);
        return placemark;
    }

    protected UnitInfo[] getInfo(ReportSelectionDTO selectionDTO) {
        ArrayList<UnitInfo> infoList = new ArrayList<UnitInfo>();
        this.dataList = this.historyDataFacade.getPositionData(selectionDTO, ExtendedDTOData.getNOTHING());
        Collections.sort(this.dataList, new ReportDTOBaseComparator(ReportDTOBaseComparator.CompareType.UNIT_NAME, ReportDTOBaseComparator.CompareType.BEGIN_TIME));
        UnitInfo previous = null;
        for (PositionDTO dto : this.dataList) {
            boolean isNext = false;
            if (previous == null || !dto.getUnitName().equals(previous.name)) {
                isNext = true;
            }
            long latitude = dto.getLatMSEC();
            long longitude = dto.getLongMSEC();
            if (latitude == 0L && longitude == 0L) continue;
            GeoPoint point = new GeoPoint(latitude, longitude);
            UnitInfo info = new UnitInfo();
            info.id = dto.getUnitId();
            info.name = dto.getUnitName();
            info.description = null;
            info.point = point;
            HashMap<String, String> data = new HashMap<String, String>();
            data.put(BEGINTIME, String.valueOf(dto.getBeginTime()));
            data.put(IMAGE, "../../images/units/airportmap/128/" + dto.getUnit().getUnitTypeIdentity().getImageType().getName() + ".png");
            data.put(SPEED_KMH, String.valueOf(dto.getSpeedKmh()));
            data.put(SPEED_MPH, String.valueOf(dto.getSpeedMph()));
            info.data = data;
            if (isNext) {
                info.data.put(POSITION, "start");
                if (previous != null) {
                    previous.data.put(POSITION, "end");
                }
            } else {
                info.data.put(POSITION, "middle");
            }
            previous = info;
            infoList.add(info);
        }
        if (previous != null) {
            previous.data.put(POSITION, "end");
        }
        return infoList.toArray(new UnitInfo[infoList.size()]);
    }
}

