/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.general.kml.transmissionDelay;

import de.micromata.opengis.kml.v_2_2_0.Document;
import de.micromata.opengis.kml.v_2_2_0.GroundOverlay;
import de.micromata.opengis.kml.v_2_2_0.Kml;
import de.micromata.opengis.kml.v_2_2_0.TimeSpan;
import de.proveo.util.kml.KmlUtil;
import de.proveo.util.kml.processors.ValueGridImageProcessor;
import de.proveo.util.kml.structs.FileInfo;
import de.proveo.util.kml.structs.GeoArea;
import de.proveo.util.kml.structs.GroundOverlayInfo;
import de.proveo.util.kml.structs.ImageProperties;
import de.proveo.util.kml.structs.KmlInfo;
import de.proveo.util.kml.structs.ValueGrid;
import de.proveo.wwt.logic.ejb.general.kml.area.AreaExportFastLane;
import de.proveo.wwt.logic.ejb.general.kml.providers.ProviderBase;
import de.proveo.wwt.logic.ejb.general.kml.transmissionDelay.TransmissionDelaySqlBuilder;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransmissionDelay
extends ProviderBase {
    private static final Log log = LogFactory.getLog(TransmissionDelay.class);
    private static final String PLACEMARK_NAME = "Airport";
    private static final String IMAGE_FILE_NAME = "Transmission Delay";
    private static final String IMAGE_FILE_EXTENSION = ".png";
    private static final String KMZ_FILE_NAME = "Transmission Delay.kmz";
    private static final String KML_FILE_NAME = "Transmission Delay.kml";
    private static final String KMZ_PATH = "D:\\";
    private static final int AREA_ID = 530;
    private static Date BEGIN_DATE;
    private static Date END_DATE;
    private static long BEGIN_TIME;
    private static long END_TIME;
    private static long MAX_DELAY;
    private static long INTERVAL;
    private static final long HIGH_RES_GRID_SIZE = 80L;

    public static void main(String[] args) {
        TransmissionDelay transmissionDelay = new TransmissionDelay();
        AreaExportFastLane aefl = new AreaExportFastLane();
        KmlInfo kmlInfo = new KmlInfo();
        kmlInfo.documentName = IMAGE_FILE_NAME;
        kmlInfo.geoArea = aefl.getCoveredArea(530);
        kmlInfo.gridSize = 80L;
        kmlInfo.imageFilename = IMAGE_FILE_NAME;
        kmlInfo.imageFileExtension = IMAGE_FILE_EXTENSION;
        kmlInfo.kmlFilename = KML_FILE_NAME;
        kmlInfo.beginTime = BEGIN_TIME;
        kmlInfo.endTime = END_TIME;
        ImageProperties imageProperties = new ImageProperties();
        DateFormat df = DateFormat.getInstance();
        GroundOverlayInfo goi = new GroundOverlayInfo();
        goi.placemarkName = PLACEMARK_NAME;
        goi.placemarkDescription = "Transmission delay from " + df.format(BEGIN_DATE) + " to " + df.format(END_DATE) + ". Range: " + imageProperties.getMinValue() / 1000.0f + "-" + imageProperties.getMaxValue() / 1000.0f + " seconds.";
        goi.imageUrl = IMAGE_FILE_NAME;
        goi.groundOverlayName = PLACEMARK_NAME;
        byte[] data = transmissionDelay.generateKmz(kmlInfo, imageProperties, goi);
        KmlUtil.writeFile((String)"D:\\Transmission Delay.kmz", (byte[])data);
        System.out.println("DONE");
    }

    public byte[] generateKmz(KmlInfo kmlInfo, ImageProperties imageProperties, GroundOverlayInfo groundOverlayInfo) {
        ArrayList<FileInfo> files = new ArrayList<FileInfo>();
        String[] filenames = TransmissionDelay.getFrameFilenames(kmlInfo);
        byte[] kmlData = TransmissionDelay.generateKml(kmlInfo, groundOverlayInfo, filenames);
        files.add(new FileInfo(kmlInfo.kmlFilename, kmlData));
        byte[] data = null;
        if (kmlInfo.interval == 0L) {
            ValueGrid valueGrid = new ValueGrid(kmlInfo.geoArea, kmlInfo.gridSize);
            String sql = TransmissionDelaySqlBuilder.buildSql(kmlInfo.beginTime, kmlInfo.endTime, valueGrid.getGridSize(), MAX_DELAY, kmlInfo.geoArea);
            this.fillGrid(sql, valueGrid, true);
            byte[] imageData = TransmissionDelay.generateOverlayImage(valueGrid, imageProperties);
            files.add(new FileInfo(filenames[0], imageData));
        } else {
            int numOverlays = TransmissionDelay.getFrameCount(kmlInfo);
            for (int i = 0; i != numOverlays; ++i) {
                ValueGrid valueGrid = new ValueGrid(kmlInfo.geoArea, kmlInfo.gridSize);
                String sql = TransmissionDelaySqlBuilder.buildSql(kmlInfo.beginTime + (long)i * kmlInfo.interval, kmlInfo.beginTime + (long)(i + 1) * kmlInfo.interval, valueGrid.getGridSize(), MAX_DELAY, kmlInfo.geoArea);
                this.fillGrid(sql, valueGrid, true);
                byte[] imageData = TransmissionDelay.generateOverlayImage(valueGrid, imageProperties);
                files.add(new FileInfo(filenames[i], imageData));
            }
        }
        data = KmlUtil.writeKmz(files);
        return data;
    }

    private static byte[] generateKml(KmlInfo kmlInfo, GroundOverlayInfo goi, String[] filenames) {
        Kml kml = new Kml();
        Document doc = kml.createAndSetDocument();
        doc.setName(kmlInfo.documentName);
        doc.setDescription(kmlInfo.documentDescription);
        SimpleDateFormat xmlDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        DateFormat df = DateFormat.getDateTimeInstance();
        KmlUtil.createAndAddPlacemark((Document)doc, (String)goi.placemarkName, (String)goi.placemarkDescription, (long)((long)((double)(kmlInfo.geoArea.minLon + kmlInfo.geoArea.maxLon) / 2.0)), (long)((long)((double)(kmlInfo.geoArea.minLat + kmlInfo.geoArea.maxLat) / 2.0)));
        if (filenames.length == 1) {
            goi.imageUrl = filenames[0];
            KmlUtil.createAndAddGroundOverlay((Document)doc, (GroundOverlayInfo)goi, (GeoArea)kmlInfo.geoArea);
        } else {
            for (int i = 0; i != filenames.length; ++i) {
                Date beginTime = new Date(kmlInfo.beginTime + (long)i * kmlInfo.interval);
                Date endTime = new Date(kmlInfo.beginTime + (long)(i + 1) * kmlInfo.interval - 1L);
                goi.imageUrl = filenames[i];
                StringBuilder sb = new StringBuilder();
                sb.append(df.format(beginTime));
                sb.append(" - ");
                sb.append(df.format(endTime));
                goi.groundOverlayName = sb.toString();
                GroundOverlay go = KmlUtil.createAndAddGroundOverlay((Document)doc, (GroundOverlayInfo)goi, (GeoArea)kmlInfo.geoArea);
                TimeSpan timeSpan = go.createAndSetTimeSpan();
                timeSpan.setBegin(xmlDateFormat.format(beginTime));
                timeSpan.setEnd(xmlDateFormat.format(endTime));
            }
        }
        return KmlUtil.serialize((Kml)kml);
    }

    public static byte[] generateOverlayImage(ValueGrid valueGrid, ImageProperties imageProperties) {
        ValueGridImageProcessor imageProcessor = new ValueGridImageProcessor(imageProperties);
        return imageProcessor.writeImage(valueGrid);
    }

    static {
        BEGIN_TIME = 0L;
        END_TIME = 0L;
        MAX_DELAY = 120000L;
        INTERVAL = 3600000L;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat();
            BEGIN_DATE = sdf.parse("01.01.2010 00:00:00,0");
            BEGIN_TIME = BEGIN_DATE.getTime();
            END_DATE = sdf.parse("10.01.2010 00:00:00,0");
            END_TIME = END_DATE.getTime();
        }
        catch (ParseException e) {
            log.error((Object)"Runs into", (Throwable)e);
        }
    }
}

