/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.general.kml.providers;

import de.proveo.util.kml.structs.KmlInfo;
import de.proveo.util.kml.structs.ValueGrid;
import de.proveo.wwt.logic.web.data.fastlanereader.base.FastLaneReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ProviderBase
extends FastLaneReader {
    private static final Log log = LogFactory.getLog(ProviderBase.class);

    protected static int getFrameCount(KmlInfo tdi) {
        return tdi.interval == 0L ? 1 : (int)Math.ceil((tdi.endTime - tdi.beginTime) / tdi.interval);
    }

    protected static String[] getFrameFilenames(KmlInfo tdi) {
        int numFiles = ProviderBase.getFrameCount(tdi);
        String[] filenames = new String[numFiles];
        for (int i = 0; i != numFiles; ++i) {
            StringBuilder sb = new StringBuilder(tdi.imageFilename);
            sb.append(i + 1);
            sb.append(tdi.imageFileExtension);
            filenames[i] = sb.toString();
        }
        return filenames;
    }

    protected void fillGrid(String sql, ValueGrid valueGrid, boolean useDelay) {
        try {
            long minDelay = Long.MAX_VALUE;
            long maxDelay = -1L;
            Connection connection = this.getConnection();
            Statement statement = this.createReadOnlyForwardOnlyStatement(connection);
            boolean idxLat = true;
            int idxLon = 2;
            int idxCount = 3;
            int idxDelay = 4;
            log.debug((Object)sql);
            ResultSet resultSet = statement.executeQuery(sql);
            resultSet.setFetchSize(5000);
            while (resultSet.next()) {
                int latIdx = resultSet.getInt(1);
                int lonIdx = resultSet.getInt(2);
                long count = resultSet.getLong(3);
                long delay = 0L;
                if (useDelay && (delay = resultSet.getLong(4)) < 0L) continue;
                valueGrid.setCount(count, latIdx, lonIdx);
                if (!useDelay) continue;
                valueGrid.setValue(delay, latIdx, lonIdx);
                if (delay < minDelay) {
                    minDelay = delay;
                }
                if (delay <= maxDelay) continue;
                maxDelay = delay;
            }
            if (useDelay) {
                log.debug((Object)("Overall minimum delay: " + minDelay + " ms"));
                log.debug((Object)("Overall maximum delay: " + maxDelay + " ms"));
            }
            connection.close();
        }
        catch (SQLException e) {
            log.error((Object)"Runs into", (Throwable)e);
        }
    }
}

