/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.general.kml.eventCount;

import de.micromata.opengis.kml.v_2_2_0.Document;
import de.micromata.opengis.kml.v_2_2_0.Feature;
import de.micromata.opengis.kml.v_2_2_0.Folder;
import de.micromata.opengis.kml.v_2_2_0.Kml;
import de.proveo.util.kml.KmlUtil;
import de.proveo.util.kml.processors.ValueGridBarProcessor;
import de.proveo.util.kml.processors.ValueGridImageProcessor;
import de.proveo.util.kml.structs.FileInfo;
import de.proveo.util.kml.structs.ImageProperties;
import de.proveo.util.kml.structs.KmlInfo;
import de.proveo.util.kml.structs.ValueGrid;
import de.proveo.wwt.logic.ejb.general.kml.area.AreaExportFastLane;
import de.proveo.wwt.logic.ejb.general.kml.eventCount.GeoEventCountSqlBuilder;
import de.proveo.wwt.logic.ejb.general.kml.providers.ProviderBase;
import de.proveo.wwt.logic.ejb.general.kml.transmissionDelay.TransmissionDelay;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GeoEventCount
extends ProviderBase {
    private static final Log log = LogFactory.getLog(TransmissionDelay.class);
    private static final String PLACEMARK_NAME = "Airport";
    private static final String KMZ_FILE_NAME = "Geo Event Count.kmz";
    private static final String KML_FILE_NAME = "Geo Event Count.kml";
    private static final String KMZ_PATH = "D:\\";
    private static final int AREA_ID = 530;
    private static Date BEGIN_DATE;
    private static Date END_DATE;
    private static long BEGIN_TIME;
    private static long END_TIME;
    private static long INTERVAL;
    private static DateFormat dateFormat;
    static final long MAX_EVENTS = 100L;
    static final String STYLE_NAME = "NUM_EVT_STYL";
    private static final long HIGH_RES_GRID_SIZE = 400L;

    public static void main(String[] args) {
        AreaExportFastLane aefl = new AreaExportFastLane();
        KmlInfo kmlInfo = new KmlInfo();
        kmlInfo.documentName = "Geo Event Count";
        kmlInfo.geoArea = aefl.getCoveredArea(530);
        kmlInfo.gridSize = 400L;
        kmlInfo.kmlFilename = KML_FILE_NAME;
        kmlInfo.beginTime = BEGIN_TIME;
        kmlInfo.endTime = END_TIME;
        ImageProperties imageProperties = new ImageProperties();
        imageProperties.setMaxValue(100.0f);
        GeoEventCount geoEventCount = new GeoEventCount();
        byte[] data = geoEventCount.generateKmz(kmlInfo, imageProperties);
        KmlUtil.writeFile((String)"D:\\Geo Event Count.kmz", (byte[])data);
        System.out.println("DONE");
    }

    public byte[] generateKmz(KmlInfo kmlInfo, ImageProperties imageProperties) {
        ArrayList<FileInfo> files = new ArrayList<FileInfo>();
        Kml kml = GeoEventCount.generateKml(kmlInfo, PLACEMARK_NAME, "");
        ValueGridBarProcessor.BarProperties barProperties = new ValueGridBarProcessor.BarProperties();
        ValueGridBarProcessor barProcessor = new ValueGridBarProcessor(barProperties, imageProperties);
        if (kmlInfo.interval == 0L) {
            ValueGrid valueGrid = new ValueGrid(kmlInfo.geoArea, kmlInfo.gridSize);
            String sql = GeoEventCountSqlBuilder.buildSql(kmlInfo.beginTime, kmlInfo.endTime, kmlInfo.gridSize, kmlInfo.geoArea);
            this.fillGrid(sql, valueGrid, false);
            Folder folder = kml.createAndSetFolder();
            folder.setName(kmlInfo.documentName);
            folder.setDescription(dateFormat.format(new Date(kmlInfo.beginTime)) + "-" + dateFormat.format(new Date(kmlInfo.endTime)));
            barProcessor.addBars(folder, valueGrid);
        } else {
            int numOverlays = GeoEventCount.getFrameCount(kmlInfo);
            Document doc = kml.createAndSetDocument();
            doc.setName(kmlInfo.documentName);
            doc.setDescription(kmlInfo.documentDescription);
            for (int i = 0; i != numOverlays; ++i) {
                long beginTime = kmlInfo.beginTime + (long)i * kmlInfo.interval;
                long endTime = kmlInfo.beginTime + (long)(i + 1) * kmlInfo.interval - 1L;
                ValueGrid valueGrid = new ValueGrid(kmlInfo.geoArea, kmlInfo.gridSize);
                String sql = GeoEventCountSqlBuilder.buildSql(beginTime, endTime, kmlInfo.gridSize, kmlInfo.geoArea);
                this.fillGrid(sql, valueGrid, false);
                Folder folder = new Folder();
                folder.setName(dateFormat.format(new Date(beginTime)) + "-" + dateFormat.format(new Date(endTime)));
                doc.addToFeature((Feature)folder);
                barProcessor.addBars(folder, valueGrid, beginTime, endTime);
            }
        }
        files.add(new FileInfo(kmlInfo.kmlFilename, KmlUtil.serialize((Kml)kml)));
        return KmlUtil.writeKmz(files);
    }

    private static Kml generateKml(KmlInfo kmlInfo, String placemarkName, String placemarkDescription) {
        Kml kml = new Kml();
        Document doc = kml.createAndSetDocument();
        doc.setName(kmlInfo.documentName);
        doc.setDescription(kmlInfo.documentDescription);
        KmlUtil.createAndAddPlacemark((Document)doc, (String)placemarkName, (String)placemarkDescription, (long)((long)((double)(kmlInfo.geoArea.minLon + kmlInfo.geoArea.maxLon) / 2.0)), (long)((long)((double)(kmlInfo.geoArea.minLat + kmlInfo.geoArea.maxLat) / 2.0)));
        return kml;
    }

    public static byte[] generateOverlayImage(ValueGrid valueGrid, ImageProperties imageProperties) {
        ValueGridImageProcessor imageProcessor = new ValueGridImageProcessor(imageProperties);
        return imageProcessor.writeImage(valueGrid);
    }

    static {
        BEGIN_TIME = 0L;
        END_TIME = 0L;
        INTERVAL = 3600000L;
        dateFormat = DateFormat.getInstance();
        try {
            SimpleDateFormat sdf = new SimpleDateFormat();
            BEGIN_DATE = sdf.parse("01.01.2010 00:00:00,0");
            BEGIN_TIME = BEGIN_DATE.getTime();
            END_DATE = sdf.parse("02.01.2010 00:00:00,0");
            END_TIME = END_DATE.getTime();
        }
        catch (ParseException e) {
            log.error((Object)"Runs into", (Throwable)e);
        }
    }
}

