/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.general.jms;

import javax.jms.JMSException;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JMSClient {
    private static final Log log = LogFactory.getLog(JMSClient.class);
    private String subscriberId;
    private TopicConnection connection = null;
    private TopicSession session = null;
    private TopicSubscriber subscriber = null;

    public JMSClient(String subscriberId, TopicConnection connection, TopicSubscriber subscriber, TopicSession session) {
        this.subscriberId = subscriberId;
        this.connection = connection;
        this.subscriber = subscriber;
        this.session = session;
    }

    public void close() throws JMSException {
        JMSException ex;
        block22: {
            String method;
            block21: {
                block20: {
                    method = "close() [subscriberId=" + this.subscriberId == null ? "?!?null?!?" : this.subscriberId + "]: ";
                    ex = null;
                    if (null != this.connection) {
                        try {
                            this.connection.stop();
                            if (log.isDebugEnabled()) {
                                log.debug((Object)(method + "TopicConnection stopped!"));
                            }
                        }
                        catch (JMSException e) {
                            if (ex != null) break block20;
                            ex = e;
                        }
                    }
                }
                if (this.session != null) {
                    try {
                        this.session.commit();
                    }
                    catch (JMSException e) {
                        log.debug((Object)(method + "Could not commit session: " + e.getMessage()));
                    }
                }
                if (null != this.subscriber) {
                    try {
                        this.subscriber.close();
                        this.subscriber = null;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)(method + "TopicSubscriber closed!"));
                        }
                    }
                    catch (JMSException e) {
                        ex = e;
                    }
                }
                if (null != this.session) {
                    try {
                        this.session.close();
                        this.session = null;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)(method + "TopicSession closed!"));
                        }
                    }
                    catch (JMSException e) {
                        if (ex != null) break block21;
                        ex = e;
                    }
                }
            }
            if (null != this.connection) {
                try {
                    this.connection.close();
                    this.connection = null;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(method + "TopicConnection closed!"));
                    }
                }
                catch (JMSException e) {
                    if (ex != null) break block22;
                    ex = e;
                }
            }
        }
        if (ex != null) {
            throw ex;
        }
        this.subscriberId = null;
    }

    public String getClientId() {
        String clientId = "disconnected";
        if (this.connection != null) {
            try {
                clientId = this.connection.getClientID();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return clientId;
    }
}

