/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataOut.raw;

import de.proveo.wwt.datamodel.area.Area;
import de.proveo.wwt.datamodel.unit.identity.UnitIdentity;
import de.proveo.wwt.logic.ejb.geo.GeoStruct;
import java.io.Serializable;

public class GeoStamp
implements Serializable {
    private static final long serialVersionUID = 7130225621579397156L;
    protected long requestedBeginTime;
    protected long requestedEndTime;
    protected long eventEntryTime;
    protected long eventExitTime;
    protected long eventDuration;
    protected long beginTime;
    protected long endTime;
    protected long duration;
    protected long beginReceiveTime;
    protected long endReceiveTime;
    protected long beginDelayTime;
    protected long endDelayTime;
    GeoStruct geoStruct;
    Area areaStruct;
    UnitIdentity unitIdentityData;

    public GeoStamp(GeoStruct gs, Area as, UnitIdentity uid, long reqBeginTime, long reqEndTime) {
        this.geoStruct = gs;
        this.areaStruct = as;
        this.unitIdentityData = uid;
        this.requestedBeginTime = reqBeginTime;
        this.requestedEndTime = reqEndTime;
        this.eventEntryTime = gs.getBeginTime();
        this.eventExitTime = gs.getEndTime();
        this.beginReceiveTime = gs.getBeginReceiveTime();
        this.endReceiveTime = gs.getEndReceiveTime();
        this.beginDelayTime = gs.getBeginEventDelay();
        this.endDelayTime = gs.getEndEventDelay();
        this.beginTime = this.eventEntryTime < this.requestedBeginTime ? this.requestedBeginTime : this.eventEntryTime;
        if (gs.getEndTime() == 0L) {
            this.initFromCache();
        } else {
            this.initFromHistory(gs);
        }
        this.duration = this.endTime - this.beginTime;
    }

    protected void initFromCache() {
        this.endTime = this.requestedEndTime;
        this.eventDuration = this.requestedEndTime - this.eventEntryTime;
    }

    protected void initFromHistory(GeoStruct gs) {
        this.endTime = this.eventExitTime > this.requestedEndTime ? this.requestedEndTime : this.eventExitTime;
        this.eventDuration = this.eventExitTime - this.eventEntryTime;
    }

    public long getRequestedBeginTime() {
        return this.requestedBeginTime;
    }

    public long getRequestedEndTime() {
        return this.requestedEndTime;
    }

    public long getBeginTime() {
        return this.beginTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public long getDuration() {
        return this.duration;
    }

    public long getEventEntryTime() {
        return this.eventEntryTime;
    }

    public long getEventExitTime() {
        return this.eventExitTime;
    }

    public long getEventDuration() {
        return this.eventDuration;
    }

    public long getBeginReceiveTime() {
        return this.beginReceiveTime;
    }

    public long getEndReceiveTime() {
        return this.endReceiveTime;
    }

    public long getBeginDelayTime() {
        return this.beginDelayTime;
    }

    public long getEndDelayTime() {
        return this.endDelayTime;
    }

    public long getUnitId() {
        return this.geoStruct.getUnitId();
    }

    public String getUnitName() {
        return this.unitIdentityData.getName();
    }

    public String getArea() {
        return this.areaStruct.getArea();
    }

    public String getAreaName() {
        return this.areaStruct.getDescription();
    }

    public GeoStruct getGeoStruct() {
        return this.geoStruct;
    }

    public Area getAreaStruct() {
        return this.areaStruct;
    }

    public UnitIdentity getUnitIdentityData() {
        return this.unitIdentityData;
    }
}

