/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataIn.event.handlers;

import de.proveo.eventbase.EventResponse;
import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.wwt.logic.ejb.dataIn.event.EventInfo;
import de.proveo.wwt.logic.ejb.dataIn.event.EventResult;
import de.proveo.wwt.logic.ejb.dataIn.event.handlers.DatasyncHandler;
import de.proveo.wwt.logic.ejb.dataIn.event.handlers.EventHandlerUtil;
import de.proveo.wwt.logic.ejb.dataIn.event.handlers.IEventHandler;
import de.proveo.wwt.logic.ejb.general.zeroconf.ZeroconfFacadeLocal;
import java.util.ArrayList;
import java.util.Properties;
import javax.ejb.EJBException;
import javax.naming.InitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ZeroconfEventHandler
implements IEventHandler {
    private static final Log log = LogFactory.getLog(ZeroconfEventHandler.class);
    private DatasyncHandler datasyncHandler;
    private ZeroconfFacadeLocal zeroconfFacadeLocal;

    @Override
    public EventResult handleEvent(Properties event, EventResponse eventResponse, EventInfo eventInfo, ArrayList<SerializableEventWrapper> eventWrappers) {
        if (!EventHandlerUtil.isTestEvent(event)) {
            if (this.isZeroConfEvent(event, eventInfo)) {
                this.zeroconfFacadeLocal.update(event, eventInfo);
                EventResult result = this.datasyncHandler.handleEvent(event, eventResponse, eventInfo, eventWrappers);
                if (result == EventResult.ERROR) {
                    return result;
                }
                return EventResult.SUCCESS_BUT_STOP_HANDLER_CHAIN;
            }
            if (this.isManagementEvent(event, eventInfo)) {
                this.zeroconfFacadeLocal.handleBootEvent(event, eventInfo);
            }
        }
        return EventResult.SUCCESS;
    }

    protected boolean isZeroConfEvent(Properties event, EventInfo eventInfo) {
        return event.containsKey("hwsn") && event.containsKey("hwType") && eventInfo.unitIds.length == 0;
    }

    protected boolean isManagementEvent(Properties event, EventInfo eventInfo) {
        return eventInfo.serialNumber != null && eventInfo.deviceType != null;
    }

    @Override
    public void initialize() {
        try {
            InitialContext context = new InitialContext();
            Object obj = context.lookup("rts/ZeroconfFacade/local");
            this.zeroconfFacadeLocal = (ZeroconfFacadeLocal)obj;
        }
        catch (Exception e) {
            log.error((Object)"DatasyncHandler() runs into", (Throwable)e);
            throw new EJBException("EJB reference problem", e);
        }
        this.datasyncHandler = new DatasyncHandler();
        this.datasyncHandler.initialize();
    }
}

