/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataIn.event.handlers;

import de.proveo.eventbase.EventResponse;
import de.proveo.rts.configuration.monitor.MonitoringMBean;
import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.util.service.ServiceFactory;
import de.proveo.wwt.logic.app.rfid.RFIDValue;
import de.proveo.wwt.logic.ejb.dataIn.event.EventInfo;
import de.proveo.wwt.logic.ejb.dataIn.event.EventResult;
import de.proveo.wwt.logic.ejb.dataIn.event.handlers.IEventHandler;
import de.proveo.wwt.logic.ejb.dataIn.rfid.TagEventFacadeLocal;
import java.util.ArrayList;
import java.util.Properties;
import javax.ejb.EJBException;
import javax.naming.InitialContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RFIDEventHandler
implements IEventHandler {
    private static final Log log = LogFactory.getLog(RFIDEventHandler.class);
    private MonitoringMBean rfidEventCounter;
    private TagEventFacadeLocal tagEventFacadeLocal = null;

    @Override
    public EventResult handleEvent(Properties event, EventResponse eventResponse, EventInfo eventInfo, ArrayList<SerializableEventWrapper> eventWrappers) {
        if (event.containsKey("rf")) {
            for (long unitId : eventInfo.unitIds) {
                this.handleRFIDEvent(event, unitId);
            }
        }
        return EventResult.SUCCESS;
    }

    private void handleRFIDEvent(Properties event, long unitId) {
        log.trace((Object)"handleRFIDEvent()");
        this.rfidEventCounter.increment();
        long timestamp = Long.parseLong(event.getProperty("t"));
        long tagId = 0L;
        String tag = StringUtils.trimToEmpty((String)event.getProperty("rf"));
        RFIDValue rfidEvent = new RFIDValue(unitId, tagId, timestamp);
        rfidEvent.setTagName(tag);
        this.tagEventFacadeLocal.handleEvent(rfidEvent);
    }

    @Override
    public void initialize() {
        try {
            this.rfidEventCounter = (MonitoringMBean)ServiceFactory.getInstance().getService(MonitoringMBean.class, "RFIDEvents");
            InitialContext context = new InitialContext();
            this.tagEventFacadeLocal = (TagEventFacadeLocal)context.lookup("rts/TagEventFacade/local");
        }
        catch (Exception e) {
            log.error((Object)"RFIDEventHandler() runs into", (Throwable)e);
            throw new EJBException("EJB reference problem", e);
        }
    }
}

