/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataIn.event.handlers;

import de.proveo.eventbase.EventResponse;
import de.proveo.rts.configuration.monitor.MonitoringMBean;
import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.util.service.ServiceFactory;
import de.proveo.wwt.datamodel.keepalive.KeepAliveHistory;
import de.proveo.wwt.logic.app.keepalive.event.KeepAliveEvent;
import de.proveo.wwt.logic.ejb.dataIn.event.EventInfo;
import de.proveo.wwt.logic.ejb.dataIn.event.EventResult;
import de.proveo.wwt.logic.ejb.dataIn.event.handlers.IEventHandler;
import de.proveo.wwt.logic.ejb.dataIn.event.handlers.StateEventHandler;
import de.proveo.wwt.logic.ejb.dataIn.event.history.EventPersisterFacadeLocal;
import de.proveo.wwt.logic.ejb.dataIn.event.history.EventPersisterResult;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import javax.ejb.EJBException;
import javax.naming.InitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class KeepaliveEventHandler
implements IEventHandler {
    private static final Log log = LogFactory.getLog(KeepaliveEventHandler.class);
    private MonitoringMBean keepAliveEventCounter;
    private StateEventHandler stateHandler;
    private EventPersisterFacadeLocal eventPersisterFacade = null;

    @Override
    public EventResult handleEvent(Properties event, EventResponse eventResponse, EventInfo eventInfo, ArrayList<SerializableEventWrapper> eventWrappers) {
        EventResult result = EventResult.SUCCESS;
        if (KeepaliveEventHandler.isKeepAliveEvent(event, eventInfo)) {
            int numUnits = eventInfo.unitIds.length;
            for (int i = 0; i != numUnits; ++i) {
                if (this.handleKeepaliveEvent(event, eventInfo, eventInfo.unitIds[i], eventWrappers)) continue;
                result = EventResult.ERROR;
                break;
            }
        }
        return result;
    }

    protected static boolean isKeepAliveEvent(Properties event, EventInfo eventInfo) {
        if ((event.containsKey("u") || event.containsKey("u1")) && event.containsKey("t")) {
            int expectedKeys = 1;
            if (event.containsKey("oldTimestamp")) {
                ++expectedKeys;
            }
            if (event.containsKey("c")) {
                ++expectedKeys;
            }
            if (event.containsKey("hwsn")) {
                ++expectedKeys;
            }
            if (event.containsKey("hwType")) {
                ++expectedKeys;
            }
            return event.size() <= (expectedKeys += eventInfo.unitIds.length);
        }
        return false;
    }

    private boolean handleKeepaliveEvent(Properties event, EventInfo eventInfo, long unitId, ArrayList<SerializableEventWrapper> eventWrappers) {
        long timestamp;
        this.keepAliveEventCounter.increment();
        try {
            timestamp = Long.parseLong(event.getProperty("t"));
        }
        catch (NumberFormatException ex) {
            log.error((Object)"could not parse event time", (Throwable)ex);
            return false;
        }
        KeepAliveHistory keepAliveHistory = new KeepAliveHistory();
        keepAliveHistory.setCreateTime(timestamp);
        keepAliveHistory.setReceiveTime(eventInfo.receiveTime);
        keepAliveHistory.setUnitId(unitId);
        try {
            EventPersisterResult result = this.eventPersisterFacade.persist(keepAliveHistory);
            if (result == null) {
                return true;
            }
            Properties infomanState = new Properties();
            infomanState.putAll((Map<?, ?>)event);
            infomanState.setProperty("m", Long.toString(2110L));
            infomanState.setProperty("s", Long.toString(2112L));
            infomanState.setProperty("t", event.getProperty("t"));
            if (log.isTraceEnabled()) {
                log.trace((Object)("infoman keep alive. switch infoman state: " + infomanState));
            }
            EventResponse eventResponse = new EventResponse();
            this.stateHandler.handleEvent(infomanState, eventResponse, eventInfo, eventWrappers);
            Properties onlineState = new Properties();
            onlineState.putAll((Map<?, ?>)event);
            onlineState.setProperty("m", Long.toString(2140L));
            onlineState.setProperty("s", Long.toString(2141L));
            onlineState.setProperty("t", Long.toString(System.currentTimeMillis()));
            if (log.isTraceEnabled()) {
                log.trace((Object)("infoman keep alive. switch online state: " + onlineState));
            }
            eventResponse = new EventResponse();
            this.stateHandler.handleEvent(onlineState, eventResponse, eventInfo, eventWrappers);
        }
        catch (Exception ex) {
            log.error((Object)"handleKeepaliveEvent() runs into ", (Throwable)ex);
        }
        try {
            KeepAliveEvent keepAliveEvent = new KeepAliveEvent(unitId, timestamp);
            keepAliveEvent.setReceiveTimestamp(System.currentTimeMillis());
            SerializableEventWrapper eventWrapper = new SerializableEventWrapper((Serializable)keepAliveEvent, (Serializable)((Object)keepAliveHistory));
            eventWrapper.set_typeOfEvent("KeepAlive");
            eventWrappers.add(eventWrapper);
        }
        catch (Exception e) {
            log.error((Object)"Error while notifying informantFacade!", (Throwable)e);
        }
        return true;
    }

    @Override
    public void initialize() {
        try {
            this.keepAliveEventCounter = (MonitoringMBean)ServiceFactory.getInstance().getService(MonitoringMBean.class, "KeepAliveEvents");
            InitialContext context = new InitialContext();
            this.eventPersisterFacade = (EventPersisterFacadeLocal)context.lookup("rts/EventPersisterFacade/local");
        }
        catch (Exception e) {
            log.error((Object)"KeepaliveEventHandler() runs into", (Throwable)e);
            throw new EJBException("EJB reference problem", e);
        }
        this.stateHandler = new StateEventHandler();
        this.stateHandler.initialize();
    }
}

