/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.app.state;

import de.proveo.wwt.logic.app.state.StateFactory;
import de.proveo.wwt.logic.app.state.event.StateEvent;
import de.proveo.wwt.logic.app.state.exception.ChangeNotAllowedException;
import de.proveo.wwt.logic.app.state.exception.InternalStateModelException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class State {
    private static final transient Log log = LogFactory.getLog(State.class);
    private StateFactory stateFactory;
    private int stateId;
    private int stateModelId;

    protected State(int stateId, int stateModelId, StateFactory stateFactory) {
        this.stateId = stateId;
        this.stateModelId = stateModelId;
        this.stateFactory = stateFactory;
        if (this.stateFactory == null) {
            throw new IllegalArgumentException("parameter stateFactory cannot be null");
        }
        if (this.stateFactory.getStateModelId() != this.stateModelId) {
            throw new IllegalArgumentException("StateModel Factory doesn't fit to stateModel");
        }
    }

    public abstract String getName();

    public int getStateId() {
        return this.stateId;
    }

    public State changeState(StateEvent stateEvent, boolean dontValidate) throws ChangeNotAllowedException, InternalStateModelException {
        if (this.stateModelId == stateEvent.getStateModelId()) {
            try {
                return this.stateFactory.getState(stateEvent.getStateId());
            }
            catch (Exception ex) {
                throw new InternalStateModelException(this.stateModelId, this.stateId, stateEvent, "I can't instanciate the new state", ex);
            }
        }
        throw new InternalStateModelException(this.stateModelId, this.stateId, stateEvent, "No Implementation for this Event");
    }

    public State enter(long unitId) {
        return this;
    }

    public State enter(StateEvent event) {
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.stateId;
        result = 31 * result + this.stateModelId;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        State other = (State)obj;
        if (this.stateId != other.stateId) {
            return false;
        }
        return this.stateModelId == other.stateModelId;
    }

    public void leave(long unitId) {
    }

    public void leave(StateEvent event) {
    }

    protected StateFactory getStateFactory() {
        return this.stateFactory;
    }

    protected long getStateModelId() {
        return this.stateModelId;
    }

    public String toString() {
        return this.getName() + ", id: " + this.getStateId();
    }
}

