/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.app.security;

import de.proveo.util.connection.LoginResponse;
import de.proveo.wwt.datamodel.account.Account;
import de.proveo.wwt.datamodel.module.ModuleType;
import de.proveo.wwt.logic.app.security.LoginCallbackHandler;
import de.proveo.wwt.logic.ejb.dataOut.audit.ActionType;
import de.proveo.wwt.logic.ejb.dataOut.audit.AuditFacadeRemote;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.facade.UserAdminFacadeRemote;
import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoginContextUtil {
    private static final Log log = LogFactory.getLog(LoginContextUtil.class);
    private UserAdminFacadeRemote userAdminFacade;
    private AuditFacadeRemote auditFacade;
    String username;
    boolean accessPermitted = false;
    String accessReasonCode = "";
    CallbackHandler loginCallbackHandler;
    TreeSet<String> permissions = new TreeSet();
    TreeSet<String> roles = new TreeSet();
    public static final String ROLE_SUPERADMIN = "superadmin";
    public static final String ROLE_AIRPORTMAP = "section.airportmap";
    public static final String ROLE_AIRPORTMAP_ADMIN = "section.airportmap_admin";
    public static final String ROLE_AIRPORTMAP_NOTIFICATION = "section.airportmap.notification";
    public static final String ROLE_AIRPORTMAP_STATE_CHANGEABLE = "section.airportmap.statesChangeable";
    public static final String ROLE_AIRPORTMAP_REPLAY = "section.airportmap.replay";
    public static final String ROLE_AIRPORTMAP_MAP_AREAS = "section.airportmap.area_map";
    public static final String ROLE_AIRPORTMAP_GEOFENCING_AREAS = "section.airportmap.area_geofencing";
    public static final String ROLE_AIRPORTMAP_GENERATOR = "section.airportmapgenerator";
    public static final String ROLE_AIRPORTMAP_GENERATOR_ADMIN = "section.airportmapgenerator_admin";
    public static final String ROLE_AIRPORTMAP_GENERATOR_AIRPORTMAP_AREAS = "section.airportmapgenerator.airportmap";
    public static final String ROLE_AIRPORTMAP_GENERATOR_GEOFENCING_AREAS = "section.airportmapgenerator.geofencing";

    public LoginContextUtil(String user, String pw) throws NamingException {
        this.username = user;
        this.loginCallbackHandler = new LoginCallbackHandler(this.username, pw);
        InitialContext ctx = new InitialContext();
        this.auditFacade = (AuditFacadeRemote)ctx.lookup("rts/AuditFacade/remote");
        this.userAdminFacade = (UserAdminFacadeRemote)ctx.lookup("rts/UserAdminFacade/remote");
    }

    public LoginContextUtil(String user, char[] pw) throws NamingException {
        this.username = user;
        this.loginCallbackHandler = new LoginCallbackHandler(this.username, pw);
        InitialContext ctx = new InitialContext();
        this.auditFacade = (AuditFacadeRemote)ctx.lookup("rts/AuditFacade/remote");
        this.userAdminFacade = (UserAdminFacadeRemote)ctx.lookup("rts/UserAdminFacade/remote");
    }

    public void fetchPermissions() {
        String method = "fetchPermissions(): ";
        try {
            LoginContext lc = new LoginContext("rts", this.loginCallbackHandler);
            lc.login();
            Set<Principal> principals = lc.getSubject().getPrincipals();
            for (Principal principal : principals) {
                if (principal == null || principal.getName() == null) {
                    log.warn((Object)(method + "found a principal==null or principal's name is null"));
                    continue;
                }
                if (!(principal instanceof Group)) continue;
                Group group = (Group)principal;
                Enumeration e = group.members();
                while (e.hasMoreElements()) {
                    Principal rolePrincipal = (Principal)e.nextElement();
                    String role = rolePrincipal.getName();
                    this.roles.add(role);
                }
                String permission = principal.getName();
                this.permissions.add(permission);
            }
            this.accessPermitted = true;
        }
        catch (LoginException lex) {
            Account account = this.userAdminFacade.getAccountByUsername(this.username);
            if (account == null) {
                this.accessReasonCode = "incorrectUsernameOrPassword";
                this.userAdminFacade.incrementFailedLogins(this.username);
                log.debug((Object)(method + "login failed, user '" + this.username + "' unknown"));
            } else if (account.getDeleted().booleanValue()) {
                this.accessReasonCode = "incorrectUsernameOrPassword";
                log.debug((Object)(method + "user is deleted"));
            } else if (account.getBlockOut()) {
                this.accessReasonCode = "userBlocked";
                log.debug((Object)(method + "user is blocked"));
            } else {
                this.accessReasonCode = "incorrectUsernameOrPassword";
                this.userAdminFacade.incrementFailedLogins(this.username);
                log.debug((Object)(method + "login failed, but user '" + this.username + "' is not blocked: incorrect username or password"));
            }
            this.roles.clear();
            this.accessPermitted = false;
        }
    }

    public LoginResponse login() {
        String method = "login(): ";
        LoginResponse loginResponse = null;
        ArrayList<String> reason = new ArrayList<String>();
        if (this.accessPermitted) {
            if (this.isSuperAdmin()) {
                loginResponse = new LoginResponse(true);
                loginResponse.setPortalPermissions(this.roles);
                this.auditFacade.logSystemAccess(ModuleType.UNKNOWN, ActionType.Login, this.username);
            } else {
                Account account = this.userAdminFacade.getAccountByUsername(this.username);
                if (account == null) {
                    loginResponse = new LoginResponse(false);
                    reason.add("incorrectUsernameOrPassword");
                    loginResponse.setPortalPermissions(reason);
                    log.error((Object)("account value null for user '" + this.username + "'"));
                } else if (account.getDeleted().booleanValue()) {
                    loginResponse = new LoginResponse(false);
                    reason.add("incorrectUsernameOrPassword");
                    loginResponse.setPortalPermissions(reason);
                    log.debug((Object)"user is deleted");
                } else if (account.getBlockOut()) {
                    loginResponse = new LoginResponse(false);
                    reason.add("userBlocked");
                    loginResponse.setPortalPermissions(reason);
                    log.debug((Object)"user is blocked");
                } else {
                    loginResponse = new LoginResponse(true);
                    loginResponse.setPortalPermissions(this.roles);
                    log.debug((Object)(method + "login access granted for user '" + this.username + "'"));
                    this.userAdminFacade.setLoginSuccessful(this.username);
                    this.auditFacade.logSystemAccess(ModuleType.UNKNOWN, ActionType.Login, this.username);
                    log.debug((Object)(method + "login logged (audit data) for user '" + this.username + "'"));
                }
            }
        } else {
            loginResponse = new LoginResponse(false);
            reason.add("incorrectUsernameOrPassword");
            loginResponse.setPortalPermissions(reason);
        }
        return loginResponse;
    }

    public HashMap login4AirportMap() {
        String method = "login4AirportMap(): ";
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        if (this.accessPermitted) {
            responseMap.put("Permissions", this.permissions);
            responseMap.put("Roles", this.roles);
            if (this.isSuperAdmin()) {
                responseMap.put("AccessPermitted", true);
                this.auditFacade.logSystemAccess(ModuleType.MAP, ActionType.Login, this.username);
            } else {
                Account account = this.userAdminFacade.getAccountByUsername(this.username);
                if (account == null) {
                    responseMap.put("AccessPermitted", false);
                    responseMap.put("ReasonCode", "incorrectUsernameOrPassword");
                    log.error((Object)("account value null for user '" + this.username + "'"));
                } else if (account.getDeleted().booleanValue()) {
                    responseMap.put("AccessPermitted", false);
                    responseMap.put("ReasonCode", "incorrectUsernameOrPassword");
                    log.debug((Object)"user is deleted");
                } else if (account.getBlockOut()) {
                    responseMap.put("AccessPermitted", false);
                    responseMap.put("ReasonCode", "userBlocked");
                    log.debug((Object)"user is blocked");
                } else if (!this.isUserInRole(ROLE_AIRPORTMAP)) {
                    responseMap.put("AccessPermitted", false);
                    responseMap.put("ReasonCode", "UserNotInRoleAirportmap");
                    log.debug((Object)"user is not in role 'section.airportmap'");
                } else {
                    responseMap.put("AccessPermitted", true);
                    log.debug((Object)(method + "login access granted for user '" + this.username + "'"));
                    this.userAdminFacade.setLoginSuccessful(this.username);
                    this.auditFacade.logSystemAccess(ModuleType.MAP, ActionType.Login, this.username);
                    log.debug((Object)(method + "login logged (audit data) for user '" + this.username + "'"));
                }
            }
        } else {
            responseMap.put("AccessPermitted", false);
            responseMap.put("ReasonCode", this.accessReasonCode);
        }
        return responseMap;
    }

    public HashMap logout4AirportMap() {
        String method = "logout4AirportMap(): ";
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        if (this.accessPermitted) {
            try {
                this.auditFacade.logSystemAccess(ModuleType.MAP, ActionType.Logout, this.username);
                if (!this.isSuperAdmin()) {
                    log.debug((Object)(method + "logout logged (audit data) for user '" + this.username + "'"));
                }
                responseMap.put("LogoutSuccessful", true);
            }
            catch (Exception re) {
                log.error((Object)(method + "AdminFacade.createAuditDataLoginLogout() runs into " + re.getMessage()));
                responseMap.put("LogoutSuccessful", false);
                responseMap.put("LogoutReasonCode", "LogoutApplicationError");
            }
        } else {
            log.error((Object)(method + "could not perform logout and audit log because of refused access."));
            responseMap.put("LogoutSuccessful", false);
            responseMap.put("LogoutReasonCode", this.accessReasonCode);
        }
        return responseMap;
    }

    public TreeSet getPermissions() {
        return this.permissions;
    }

    public TreeSet getRoles() {
        return this.roles;
    }

    public boolean isAccessPermitted() {
        return this.accessPermitted;
    }

    public boolean isUserInRole(String role) {
        return this.roles.contains(role);
    }

    public boolean isSuperAdmin() {
        return this.roles.contains(ROLE_SUPERADMIN);
    }
}

