/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.datamodel.use.user;

import de.proveo.maven.plugins.extendedObject.annotations.Equals;
import de.proveo.maven.plugins.extendedObject.annotations.ToString;
import de.proveo.util.jpa.entity.Trim;
import de.proveo.wwt.datamodel.AuditEntityBase;
import de.proveo.wwt.datamodel.notify.NotifyCache;
import de.proveo.wwt.datamodel.notify.NotifyHistory;
import de.proveo.wwt.datamodel.state.StateCache;
import de.proveo.wwt.datamodel.state.StateHistory;
import de.proveo.wwt.datamodel.unit.permission.IUnitPermissionOwner;
import de.proveo.wwt.datamodel.unit.permission.UnitPermission;
import de.proveo.wwt.datamodel.use.UseCache;
import de.proveo.wwt.datamodel.use.UseHistory;
import de.proveo.wwt.datamodel.use.group.UseGroup;
import de.proveo.wwt.datamodel.use.license.License;
import de.proveo.wwt.logic.ejb.dataOut.audit.AuditRelevant;
import de.proveo.wwt.logic.web.common.dto.interfaces.IDTOAttachable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.QueryHint;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name="use_user")
@NamedQueries(value={@NamedQuery(name="findUseUserAll", query="SELECT u FROM UseUser u WHERE u.deleted = FALSE ORDER BY u.name ASC", hints={@QueryHint(name="org.hibernate.cacheable", value="true")}), @NamedQuery(name="findUseUserAllDeleted", query="SELECT u FROM UseUser u WHERE u.deleted = TRUE ORDER BY u.name ASC", hints={@QueryHint(name="org.hibernate.cacheable", value="true")}), @NamedQuery(name="findUseUserByKey", query="SELECT u FROM UseUser u WHERE u.keyId = ?1 AND u.deleted = FALSE", hints={@QueryHint(name="org.hibernate.cacheable", value="true")}), @NamedQuery(name="findUseUserByPersonalNumber", query="SELECT u FROM UseUser u WHERE u.personalNumber = ?1 AND u.deleted = FALSE"), @NamedQuery(name="findDeletedByKey", query="SELECT u FROM UseUser u WHERE u.keyId = ?1 AND u.deleted = TRUE", hints={@QueryHint(name="org.hibernate.cacheable", value="true")}), @NamedQuery(name="findUseUserLikeKey", query="SELECT u FROM UseUser u WHERE u.keyId LIKE concat(?1,'%') AND u.deleted = FALSE", hints={@QueryHint(name="org.hibernate.cacheable", value="true")}), @NamedQuery(name="findUseUserByDescription", query="SELECT u FROM UseUser u WHERE u.description LIKE ?1 AND u.deleted = FALSE", hints={@QueryHint(name="org.hibernate.cacheable", value="true")}), @NamedQuery(name="findUseUserAllIncludeDeleted", query="SELECT u FROM UseUser u ORDER BY u.name ASC", hints={@QueryHint(name="org.hibernate.cacheable", value="true")})})
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class UseUser
extends AuditEntityBase
implements Serializable,
IUnitPermissionOwner,
IDTOAttachable {
    private static final long serialVersionUID = 2216227183877501893L;
    @AuditRelevant
    @Id
    @Column(name="ID")
    @GenericGenerator(name="incrementer", strategy="increment")
    @GeneratedValue(generator="incrementer")
    @Equals
    @ToString
    private long id;
    @AuditRelevant
    @Column(name="NAME")
    @Equals
    @Trim
    @ToString
    private String name;
    @AuditRelevant
    @Column(name="DESCRIPTION")
    @Equals
    @Trim
    @ToString
    private String description;
    @AuditRelevant
    @Column(name="DELETED")
    @Equals
    @ToString
    private boolean deleted;
    @AuditRelevant
    @Column(name="KEY_ID")
    @Equals
    @Trim
    @ToString
    private String keyId;
    @AuditRelevant
    @Column(name="PERSONAL_NUMBER")
    @Equals
    @Trim
    @ToString
    private String personalNumber;
    @AuditRelevant
    @Column(name="MECHANIC")
    @Equals
    @ToString
    private boolean mechanic;
    @AuditRelevant
    @ManyToMany(targetEntity=UseGroup.class, fetch=FetchType.EAGER)
    @JoinTable(name="use_user_x_use_group", joinColumns={@JoinColumn(name="ID_USE_USER")}, inverseJoinColumns={@JoinColumn(name="ID_USE_GROUP")})
    private List<UseGroup> useGroups = new ArrayList<UseGroup>();
    @OneToMany(targetEntity=StateCache.class, mappedBy="useUser", cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY)
    private List<StateCache> currentStateCaches = new ArrayList<StateCache>();
    @OneToMany(targetEntity=StateHistory.class, mappedBy="useUser", cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY)
    private List<StateHistory> stateHistories = new ArrayList<StateHistory>();
    @AuditRelevant
    @OneToMany(targetEntity=UnitPermission.class, mappedBy="useUser", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private List<UnitPermission> unitPermissions = new ArrayList<UnitPermission>();
    @OneToMany(targetEntity=UseCache.class, mappedBy="useUser", cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY)
    private List<UseCache> useCaches = new ArrayList<UseCache>();
    @OneToMany(targetEntity=UseHistory.class, mappedBy="useUser", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    private List<UseHistory> useHistories = new ArrayList<UseHistory>();
    @OneToMany(targetEntity=NotifyCache.class, mappedBy="useUser", cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY)
    private List<NotifyCache> currentNotifyCaches = new ArrayList<NotifyCache>();
    @OneToMany(targetEntity=NotifyHistory.class, mappedBy="useUser", cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY)
    private List<NotifyHistory> notifyHistories = new ArrayList<NotifyHistory>();
    @OneToMany(targetEntity=License.class, fetch=FetchType.EAGER, mappedBy="useUser")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.DELETE})
    private Set<License> licenses = new HashSet<License>();

    public UseUser(UseUser useUser) {
        this.id = useUser.id;
        this.name = useUser.name;
        this.description = useUser.description;
        this.deleted = useUser.deleted;
        this.setKeyId(useUser.keyId);
        this.setPersonalNumber(useUser.personalNumber);
        this.mechanic = useUser.mechanic;
        this.currentStateCaches = useUser.currentStateCaches;
        this.stateHistories = useUser.stateHistories;
        this.unitPermissions = useUser.unitPermissions;
        this.useCaches = useUser.useCaches;
        this.useHistories = useUser.useHistories;
        this.currentNotifyCaches = useUser.currentNotifyCaches;
        this.notifyHistories = useUser.notifyHistories;
        this.licenses = useUser.licenses;
    }

    public UseUser() {
    }

    public long getId() {
        return this.id;
    }

    public Object getPrimaryKey() {
        return this.getId();
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean getDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public void setKeyId(String keyId) {
        this.keyId = keyId != null ? keyId.trim() : null;
    }

    public List<UseGroup> getUseGroups() {
        return this.useGroups;
    }

    public void setUseGroups(List<UseGroup> useGroups) {
        this.useGroups = useGroups;
    }

    public String getPersonalNumber() {
        return this.personalNumber;
    }

    public void setPersonalNumber(String personalNumber) {
        this.personalNumber = personalNumber != null ? personalNumber.trim() : null;
    }

    public boolean getMechanic() {
        return this.mechanic;
    }

    public void setMechanic(boolean mechanic) {
        this.mechanic = mechanic;
    }

    public List<StateHistory> getStateHistories() {
        return this.stateHistories;
    }

    public void setStateHistories(List<StateHistory> stateHistories) {
        this.stateHistories = stateHistories;
    }

    @Override
    public List<UnitPermission> getUnitPermissions() {
        return this.unitPermissions;
    }

    @Override
    public void setUnitPermissions(List<UnitPermission> unitPermissions) {
        this.unitPermissions = unitPermissions;
    }

    @Override
    public void setPermissionOwner(UnitPermission unitPermission) {
        unitPermission.setUseUserId(this.getId());
    }

    @Override
    public boolean isPermissionOwner(UnitPermission unitPermission) {
        Long id = unitPermission.getUseUserId();
        return id != null && id.equals(this.getPrimaryKey());
    }

    public List<UseCache> getUseCaches() {
        return this.useCaches;
    }

    public void setUseCaches(List<UseCache> useCaches) {
        this.useCaches = useCaches;
    }

    public List<UseHistory> getUseHistories() {
        return this.useHistories;
    }

    public void setUseHistories(List<UseHistory> useHistories) {
        this.useHistories = useHistories;
    }

    public List<StateCache> getCurrentStateCaches() {
        return this.currentStateCaches;
    }

    public void setCurrentStateCaches(List<StateCache> currentStateCaches) {
        this.currentStateCaches = currentStateCaches;
    }

    public List<NotifyCache> getCurrentNotifyCaches() {
        return this.currentNotifyCaches;
    }

    public void setCurrentNotifyCaches(List<NotifyCache> currentNotifyCaches) {
        this.currentNotifyCaches = currentNotifyCaches;
    }

    public List<NotifyHistory> getNotifyHistories() {
        return this.notifyHistories;
    }

    public void setNotifyHistories(List<NotifyHistory> notifyHistories) {
        this.notifyHistories = notifyHistories;
    }

    public boolean idHasBeenSet() {
        return this.id != 0L;
    }

    public void addUseGroup(UseGroup group) {
        if (group != null) {
            if (this.useGroups == null) {
                this.useGroups = new ArrayList<UseGroup>();
            }
            if (!this.useGroups.contains(group)) {
                this.useGroups.add(group);
                if (!group.getUseUsers().contains(this)) {
                    group.getUseUsers().add(this);
                }
            }
        }
    }

    public List<License> getLicenseList() {
        return new ArrayList<License>(this.licenses);
    }

    public Set<License> getLicenses() {
        return this.licenses;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("UseUser");
        stringBuilder.append(" (");
        stringBuilder.append("id = ");
        stringBuilder.append(this.id);
        stringBuilder.append(", ");
        stringBuilder.append("name = ");
        stringBuilder.append(this.name == null ? "[null]" : this.name.toString());
        stringBuilder.append(", ");
        stringBuilder.append("description = ");
        stringBuilder.append(this.description == null ? "[null]" : this.description.toString());
        stringBuilder.append(", ");
        stringBuilder.append("deleted = ");
        stringBuilder.append(this.deleted);
        stringBuilder.append(", ");
        stringBuilder.append("keyId = ");
        stringBuilder.append(this.keyId == null ? "[null]" : this.keyId.toString());
        stringBuilder.append(", ");
        stringBuilder.append("personalNumber = ");
        stringBuilder.append(this.personalNumber == null ? "[null]" : this.personalNumber.toString());
        stringBuilder.append(", ");
        stringBuilder.append("mechanic = ");
        stringBuilder.append(this.mechanic);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        UseUser useUser = (UseUser)object;
        if (this.id != useUser.id) {
            return false;
        }
        if (this.name == null ? useUser.name != null : !this.name.equals(useUser.name)) {
            return false;
        }
        if (this.description == null ? useUser.description != null : !this.description.equals(useUser.description)) {
            return false;
        }
        if (this.deleted != useUser.deleted) {
            return false;
        }
        if (this.keyId == null ? useUser.keyId != null : !this.keyId.equals(useUser.keyId)) {
            return false;
        }
        if (this.personalNumber == null ? useUser.personalNumber != null : !this.personalNumber.equals(useUser.personalNumber)) {
            return false;
        }
        return this.mechanic == useUser.mechanic;
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = n * n2 + (int)(this.id ^ this.id >>> 32);
        n2 = n * n2 + (this.name == null ? 0 : this.name.hashCode());
        n2 = n * n2 + (this.description == null ? 0 : this.description.hashCode());
        n2 = n * n2 + (this.deleted ? 0 : 1);
        n2 = n * n2 + (this.keyId == null ? 0 : this.keyId.hashCode());
        n2 = n * n2 + (this.personalNumber == null ? 0 : this.personalNumber.hashCode());
        n2 = n * n2 + (this.mechanic ? 0 : 1);
        return n2;
    }
}

