/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.datamodel.unit.permission;

import de.proveo.maven.plugins.extendedObject.annotations.ToString;
import de.proveo.util.jpa.entity.EntityBase;
import de.proveo.util.jpa.entity.Relation;
import de.proveo.wwt.datamodel.account.Account;
import de.proveo.wwt.datamodel.groupIdent.GroupIdent;
import de.proveo.wwt.datamodel.role.Role;
import de.proveo.wwt.datamodel.unit.model.UnitModel;
import de.proveo.wwt.datamodel.use.group.UseGroup;
import de.proveo.wwt.datamodel.use.user.UseUser;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.QueryHint;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name="unit_permission")
@NamedQueries(value={@NamedQuery(name="findUnitPermissionByUnitId", query="SELECT u FROM UnitPermission AS u WHERE u.unit.unitId > ?1 OR u.group.unitId > ?1", hints={@QueryHint(name="org.hibernate.cacheable", value="true")}), @NamedQuery(name="findUnitPermissionByUnitIdOrGroupId", query="SELECT u FROM UnitPermission u where (u.unit.unitId = ?1 or u.group.unitId = ?1)", hints={@QueryHint(name="org.hibernate.cacheable", value="true")}), @NamedQuery(name="findUnitPermissionByUnitORGroupIdAndUserId", query="SELECT u FROM UnitPermission u where (u.unit.unitId = ?1 or u.group.unitId = ?1) AND u.useUser.id = ?2", hints={@QueryHint(name="org.hibernate.cacheable", value="true")}), @NamedQuery(name="findUnitPermissionPermissionsForUseUsersByUnitId", query="SELECT u FROM UnitPermission u where (u.unit.unitId = ?1 or u.group.unitId = ?1) and (u.useUser.id > 0 or u.useGroup.id > 0)", hints={@QueryHint(name="org.hibernate.cacheable", value="true")})})
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class UnitPermission
extends EntityBase
implements Comparable<UnitPermission> {
    private static final long serialVersionUID = -6476220495454653444L;
    @Id
    @Column(name="UNITPERMISSION_ID")
    @GenericGenerator(name="incrementer", strategy="increment")
    @GeneratedValue(generator="incrementer")
    @ToString
    private long unitpermissionId;
    @Column(name="UNIT_ID")
    @ToString
    private Long unitId;
    @Column(name="GROUP_ID")
    @ToString
    private Long groupId;
    @Column(name="ROLE_ID")
    @ToString
    private Long roleId;
    @Column(name="USEUSER_ID")
    @ToString
    private Long useUserId;
    @Column(name="ACCOUNT_ID")
    @ToString
    private Long accountId;
    @Column(name="USEGROUP_ID")
    @ToString
    private Long useGroupId;
    @Column(name="GROUPIDENT")
    @ToString
    private Long groupIdentId;
    @ManyToOne(targetEntity=UnitModel.class, fetch=FetchType.EAGER)
    @JoinColumn(name="UNIT_ID", insertable=false, updatable=false)
    @Relation(targetName="unitPermissions")
    private UnitModel unit;
    @ManyToOne(targetEntity=UnitModel.class, fetch=FetchType.EAGER)
    @JoinColumn(name="GROUP_ID", insertable=false, updatable=false)
    @Relation(targetName="groupPermissions")
    private UnitModel group;
    @ManyToOne(targetEntity=Role.class, fetch=FetchType.LAZY)
    @JoinColumn(name="ROLE_ID", insertable=false, updatable=false)
    private Role role;
    @ManyToOne(targetEntity=UseUser.class, fetch=FetchType.LAZY)
    @JoinColumn(name="USEUSER_ID", insertable=false, updatable=false)
    private UseUser useUser;
    @ManyToOne(targetEntity=Account.class, fetch=FetchType.LAZY)
    @JoinColumn(name="ACCOUNT_ID", insertable=false, updatable=false)
    private Account account;
    @ManyToOne(targetEntity=UseGroup.class, fetch=FetchType.LAZY)
    @JoinColumn(name="USEGROUP_ID", insertable=false, updatable=false)
    private UseGroup useGroup;
    @ManyToOne(targetEntity=GroupIdent.class, fetch=FetchType.LAZY)
    @JoinColumn(name="GROUPIDENT", insertable=false, updatable=false)
    private GroupIdent groupIdent;

    public UnitPermission(UnitPermission unitPermission) {
        this.unitpermissionId = unitPermission.unitpermissionId;
        this.unitId = unitPermission.unitId;
        this.roleId = unitPermission.roleId;
        this.useUserId = unitPermission.useUserId;
        this.accountId = unitPermission.accountId;
        this.useGroupId = unitPermission.useGroupId;
        this.groupIdentId = unitPermission.groupIdentId;
        this.groupId = unitPermission.groupId;
    }

    public UnitPermission() {
    }

    public String getName() {
        String name = "";
        if (this.unit != null) {
            name = this.unit.getName();
        } else if (this.group != null) {
            name = this.group.getName();
        }
        return name;
    }

    public Object getPrimaryKey() {
        return this.getUnitpermissionId();
    }

    public long getUnitpermissionId() {
        return this.unitpermissionId;
    }

    public void setUnitpermissionId(long unitpermissionId) {
        this.unitpermissionId = unitpermissionId;
    }

    public Long getUnitId() {
        return this.unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }

    public Long getGroupId() {
        return this.groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public Long getRoleId() {
        return this.roleId;
    }

    public void setRoleId(Long roleId) {
        this.roleId = roleId;
    }

    public Long getUseUserId() {
        return this.useUserId;
    }

    public void setUseUserId(Long useUserId) {
        this.useUserId = useUserId;
    }

    public Long getAccountId() {
        return this.accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public Long getUseGroupId() {
        return this.useGroupId;
    }

    public void setUseGroupId(Long useGroupId) {
        this.useGroupId = useGroupId;
    }

    public Long getGroupIdentId() {
        return this.groupIdentId;
    }

    public void setGroupIdentId(Long groupIdentId) {
        this.groupIdentId = groupIdentId;
    }

    public UnitModel getUnit() {
        return this.unit;
    }

    public Role getRole() {
        return this.role;
    }

    public UseUser getUseUser() {
        return this.useUser;
    }

    public Account getAccount() {
        return this.account;
    }

    public UseGroup getUseGroup() {
        return this.useGroup;
    }

    public GroupIdent getGroupIdent() {
        return this.groupIdent;
    }

    public void setGroupIdent(GroupIdent groupIdent) {
        this.groupIdent = groupIdent;
    }

    public UnitModel getGroup() {
        return this.group;
    }

    public boolean idHasBeenSet() {
        return this.unitpermissionId != 0L;
    }

    @Override
    public int compareTo(UnitPermission o) {
        if (this.equals(o)) {
            return 0;
        }
        return this.hashCode() - o.hashCode();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.accountId == null ? 0 : this.accountId.hashCode());
        result = 31 * result + (this.groupId == null ? 0 : this.groupId.hashCode());
        result = 31 * result + (this.groupIdentId == null ? 0 : this.groupIdentId.hashCode());
        result = 31 * result + (this.roleId == null ? 0 : this.roleId.hashCode());
        result = 31 * result + (this.unitId == null ? 0 : this.unitId.hashCode());
        result = 31 * result + (int)(this.unitpermissionId ^ this.unitpermissionId >>> 32);
        result = 31 * result + (this.useGroupId == null ? 0 : this.useGroupId.hashCode());
        result = 31 * result + (this.useUserId == null ? 0 : this.useUserId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UnitPermission other = (UnitPermission)obj;
        if (this.accountId == null ? other.accountId != null : !this.accountId.equals(other.accountId)) {
            return false;
        }
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        if (this.groupIdentId == null ? other.groupIdentId != null : !this.groupIdentId.equals(other.groupIdentId)) {
            return false;
        }
        if (this.roleId == null ? other.roleId != null : !this.roleId.equals(other.roleId)) {
            return false;
        }
        if (this.unitId == null ? other.unitId != null : !this.unitId.equals(other.unitId)) {
            return false;
        }
        if (this.unitpermissionId != other.unitpermissionId) {
            return false;
        }
        if (this.useGroupId == null ? other.useGroupId != null : !this.useGroupId.equals(other.useGroupId)) {
            return false;
        }
        return !(this.useUserId == null ? other.useUserId != null : !this.useUserId.equals(other.useUserId));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("UnitPermission");
        stringBuilder.append(" (");
        stringBuilder.append("unitpermissionId = ");
        stringBuilder.append(this.unitpermissionId);
        stringBuilder.append(", ");
        stringBuilder.append("unitId = ");
        stringBuilder.append(this.unitId == null ? "[null]" : this.unitId.toString());
        stringBuilder.append(", ");
        stringBuilder.append("groupId = ");
        stringBuilder.append(this.groupId == null ? "[null]" : this.groupId.toString());
        stringBuilder.append(", ");
        stringBuilder.append("roleId = ");
        stringBuilder.append(this.roleId == null ? "[null]" : this.roleId.toString());
        stringBuilder.append(", ");
        stringBuilder.append("useUserId = ");
        stringBuilder.append(this.useUserId == null ? "[null]" : this.useUserId.toString());
        stringBuilder.append(", ");
        stringBuilder.append("accountId = ");
        stringBuilder.append(this.accountId == null ? "[null]" : this.accountId.toString());
        stringBuilder.append(", ");
        stringBuilder.append("useGroupId = ");
        stringBuilder.append(this.useGroupId == null ? "[null]" : this.useGroupId.toString());
        stringBuilder.append(", ");
        stringBuilder.append("groupIdentId = ");
        stringBuilder.append(this.groupIdentId == null ? "[null]" : this.groupIdentId.toString());
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

