/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.datamodel.statesum;

import de.proveo.util.jpa.entity.EntityBase;
import de.proveo.wwt.datamodel.grouphistory.Grouphistory;
import de.proveo.wwt.datamodel.stateModel.State;
import de.proveo.wwt.datamodel.unit.model.UnitModel;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

@Entity
@Table(name="state_summary")
@NamedQueries(value={@NamedQuery(name="findStateSummaryByUnitIdPeriodTypeStateModelIdStateIdPeriod", query="SELECT c FROM StateSummary c WHERE c.pk.unitId = :unitId AND c.pk.periodType = :periodType AND c.pk.stateModelId = :stateModelId AND c.pk.stateId = :stateId AND c.pk.beginTime >= :beginTime AND c.pk.beginTime < :endTime ORDER BY c.pk.beginTime"), @NamedQuery(name="findStateSummaryByUnitIdPeriodTypeStateModelIdPeriod", query="SELECT c FROM StateSummary c WHERE c.pk.unitId = :unitId AND c.pk.periodType = :periodType AND c.pk.stateModelId = :stateModelId AND c.pk.beginTime >= :beginTime AND c.pk.beginTime < :endTime ORDER BY c.pk.beginTime"), @NamedQuery(name="findStateSummaryByUnitIdPeriodTypePeriod", query="SELECT c FROM StateSummary c WHERE c.pk.unitId = :unitId AND c.pk.periodType = :periodType AND c.pk.beginTime >= :beginTime AND c.pk.beginTime < :endTime ORDER BY c.pk.beginTime"), @NamedQuery(name="getMaxBeginTime", query="SELECT MAX(c.pk.beginTime) FROM StateSummary c WHERE c.pk.unitId = ?1 AND c.pk.periodType = ?2"), @NamedQuery(name="getMinBeginTime", query="SELECT MIN(c.pk.beginTime) FROM StateSummary c WHERE c.pk.unitId = ?1"), @NamedQuery(name="countEntriesForUnitIdPeriodTypeStateModelAndState", query="SELECT count(*) FROM StateSummary c WHERE c.pk.unitId = :unitId AND c.pk.periodType = :periodType AND c.pk.stateModelId = :stateModelId AND c.pk.stateId = :stateId "), @NamedQuery(name="getSumDuration", query="SELECT SUM(c.duration) FROM StateSummary c WHERE c.pk.unitId = :unitId AND c.pk.periodType = :periodType AND c.pk.stateModelId = :stateModelId AND c.pk.stateId = :stateId AND c.pk.beginTime >= :since AND c.pk.beginTime < :until")})
public class StateSummary
extends EntityBase {
    private static final long serialVersionUID = -8202082349362267999L;
    @EmbeddedId
    private PK pk;
    @Column(name="DURATION")
    private long duration;
    @Column(name="GROUP_HISTORY_ID")
    private Long groupHistoryId;
    @ManyToOne(targetEntity=Grouphistory.class, fetch=FetchType.LAZY)
    @JoinColumn(name="GROUP_HISTORY_ID", updatable=false, insertable=false)
    private Grouphistory groupHistory;
    @ManyToOne(targetEntity=UnitModel.class, fetch=FetchType.LAZY)
    @JoinColumn(name="UNIT_ID", updatable=false, insertable=false)
    private UnitModel unitModel;
    @ManyToOne(targetEntity=State.class, fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="state_id", insertable=false, updatable=false), @JoinColumn(name="state_model_id", insertable=false, updatable=false)})
    private State state;

    public StateSummary(StateSummary stateSummary) {
        this.pk = stateSummary.pk;
        this.duration = stateSummary.duration;
        this.groupHistory = stateSummary.groupHistory;
        this.groupHistoryId = stateSummary.groupHistoryId;
        this.unitModel = stateSummary.unitModel;
    }

    public StateSummary() {
        this.pk = new PK();
    }

    public String getName() {
        return "";
    }

    public Object getPrimaryKey() {
        return this.pk;
    }

    public PK getPk() {
        return this.pk;
    }

    public void setPk(PK pk) {
        this.pk = pk;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public Grouphistory getGroupHistory() {
        return this.groupHistory;
    }

    public Long getGroupHistoryId() {
        return this.groupHistoryId;
    }

    public void setGroupHistoryId(Long groupHistoryId) {
        this.groupHistoryId = groupHistoryId;
    }

    public UnitModel getUnitModel() {
        return this.unitModel;
    }

    public void setUnitModel(UnitModel unitModel) {
        this.unitModel = unitModel;
    }

    public String toString() {
        String TAB = "    ";
        StringBuilder retValue = new StringBuilder();
        retValue.append("StateSummary ( ").append(super.toString()).append("    ").append("duration = ").append(this.duration).append("    ").append("pk = ").append(this.pk).append("    ").append(" )");
        return retValue.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.duration ^ this.duration >>> 32);
        result = 31 * result + (this.pk == null ? 0 : this.pk.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StateSummary)) {
            return false;
        }
        StateSummary other = (StateSummary)((Object)obj);
        if (this.duration != other.duration) {
            return false;
        }
        return !(this.pk == null ? other.pk != null : !this.pk.equals(other.pk));
    }

    @Embeddable
    public static class PK
    implements Serializable {
        private static final long serialVersionUID = -7418876852883938166L;
        @Column(name="STATE_MODEL_ID")
        private int stateModelId;
        @Column(name="PERIOD_TYPE")
        private int periodType;
        @Column(name="UNIT_ID")
        private long unitId;
        @Column(name="BEGIN_TIME")
        private long beginTime;
        @Column(name="STATE_ID")
        private int stateId;

        public PK(PK pK) {
            this.stateModelId = pK.stateModelId;
            this.periodType = pK.periodType;
            this.unitId = pK.unitId;
            this.beginTime = pK.beginTime;
            this.stateId = pK.stateId;
        }

        public PK() {
        }

        public int getStateModelId() {
            return this.stateModelId;
        }

        public void setStateModelId(int stateModelId) {
            this.stateModelId = stateModelId;
        }

        public int getPeriodType() {
            return this.periodType;
        }

        public void setPeriodType(int periodType) {
            this.periodType = periodType;
        }

        public long getUnitId() {
            return this.unitId;
        }

        public void setUnitId(long unitId) {
            this.unitId = unitId;
        }

        public long getBeginTime() {
            return this.beginTime;
        }

        public void setBeginTime(long beginTime) {
            this.beginTime = beginTime;
        }

        public int getStateId() {
            return this.stateId;
        }

        public void setStateId(int stateId) {
            this.stateId = stateId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PK)) {
                return false;
            }
            PK other = (PK)o;
            return this.stateModelId == other.stateModelId && this.periodType == other.periodType && this.unitId == other.unitId && this.beginTime == other.beginTime && this.stateId == other.stateId;
        }

        public int hashCode() {
            return this.stateModelId ^ this.stateModelId >>> 32 ^ this.periodType ^ (int)(this.unitId ^ this.unitId >>> 32) ^ (int)(this.beginTime ^ this.beginTime >>> 32) ^ (this.stateId ^ this.stateId >>> 32);
        }

        public String toString() {
            String TAB = "    ";
            StringBuilder retValue = new StringBuilder();
            retValue.append("PK ( ").append(super.toString()).append("    ").append("beginTime = ").append(this.beginTime).append("    ").append("periodType = ").append(this.periodType).append("    ").append("stateId = ").append(this.stateId).append("    ").append("stateModelId = ").append(this.stateModelId).append("    ").append("unitId = ").append(this.unitId).append("    ").append(" )");
            return retValue.toString();
        }
    }
}

