/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.datamodel.scheduledReports;

import de.proveo.util.jpa.entity.EntityBase;
import de.proveo.wwt.datamodel.account.Account;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name="scheduled_report")
@NamedQueries(value={@NamedQuery(name="findScheduledReportAll", query="SELECT a FROM ScheduledReport a"), @NamedQuery(name="findScheduledReportNotDeleted", query="SELECT a FROM ScheduledReport a WHERE a.deleted=false")})
public class ScheduledReport
extends EntityBase {
    private static final long serialVersionUID = -540830413918824718L;
    @Id
    @Column(name="ID")
    @GenericGenerator(name="incrementer", strategy="increment")
    @GeneratedValue(generator="incrementer")
    private long id;
    @Column(name="PAGE_FORMAT")
    private String pageFormat;
    @Column(name="EMAILS")
    private String emails;
    @Column(name="REPORT_PARAMETERS")
    private String reportParameters;
    @Column(name="REPORT_TYPE")
    private String reportType;
    @Column(name="CREATE_TIME")
    private long createTime;
    @Column(name="DELETED")
    private boolean deleted;
    @Column(name="OUTPUT_FORMAT")
    private String outputFormat;
    @Column(name="LOCALE")
    private String locale;
    @Column(name="REPORT_NAME")
    private String reportName;
    @Column(name="REPORT_DESIGN")
    private String reportDesign;
    @Column(name="TIME_INTERVAL")
    private String timeInterval;
    @ManyToMany(targetEntity=Account.class, fetch=FetchType.LAZY, mappedBy="scheduledReports")
    @JoinTable(name="scheduledReport_x_account", joinColumns={@JoinColumn(name="ID_SCHEDULED_REPORT")}, inverseJoinColumns={@JoinColumn(name="ID_ACCOUNT")})
    private List<Account> accounts = new ArrayList<Account>();

    public ScheduledReport(ScheduledReport scheduledReport) {
        this.pageFormat = scheduledReport.pageFormat;
        this.emails = scheduledReport.emails;
        this.reportParameters = scheduledReport.reportParameters;
        this.reportType = scheduledReport.reportType;
        this.createTime = scheduledReport.createTime;
        this.deleted = scheduledReport.deleted;
        this.outputFormat = scheduledReport.outputFormat;
        this.locale = scheduledReport.locale;
        this.reportName = scheduledReport.reportName;
        this.reportDesign = scheduledReport.reportDesign;
        this.timeInterval = scheduledReport.timeInterval;
        this.accounts = scheduledReport.accounts;
    }

    public ScheduledReport() {
    }

    public String getName() {
        return this.reportName;
    }

    public Object getPrimaryKey() {
        return this.id;
    }

    public long getId() {
        return this.id;
    }

    public String getPageFormat() {
        return this.pageFormat;
    }

    public void setPageFormat(String pageFormat) {
        this.pageFormat = pageFormat;
    }

    public String getEmails() {
        return this.emails;
    }

    public void setEmails(String emails) {
        this.emails = emails;
    }

    public String getReportParameters() {
        return this.reportParameters;
    }

    public void setReportParameters(String reportParameters) {
        this.reportParameters = reportParameters;
    }

    public String getReportType() {
        return this.reportType;
    }

    public void setReportType(String reportType) {
        this.reportType = reportType;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public boolean getDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public String getReportName() {
        return this.reportName;
    }

    public void setReportName(String reportName) {
        this.reportName = reportName;
    }

    public String getReportDesign() {
        return this.reportDesign;
    }

    public void setReportDesign(String reportDesign) {
        this.reportDesign = reportDesign;
    }

    public String getTimeInterval() {
        return this.timeInterval;
    }

    public void setTimeInterval(String timeInterval) {
        this.timeInterval = timeInterval;
    }

    public List<Account> getAccounts() {
        return this.accounts;
    }

    public void setAccounts(List<Account> accounts) {
        this.accounts = accounts;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void addAccount(Account account) {
        if (account != null && !this.accounts.contains(account)) {
            this.accounts.add(account);
            account.addScheduledReport(this);
        }
    }

    public String toString() {
        String TAB = "    ";
        StringBuilder retValue = new StringBuilder();
        retValue.append("ScheduledReport ( ").append(super.toString()).append("    ").append("createTime = ").append(this.createTime).append("    ").append("deleted = ").append(this.deleted).append("    ").append("emails = ").append(this.emails).append("    ").append("id = ").append(this.id).append("    ").append("locale = ").append(this.locale).append("    ").append("outputFormat = ").append(this.outputFormat).append("    ").append("pageFormat = ").append(this.pageFormat).append("    ").append("reportDesign = ").append(this.reportDesign).append("    ").append("reportName = ").append(this.reportName).append("    ").append("reportParameters = ").append(this.reportParameters).append("    ").append("reportType = ").append(this.reportType).append("    ").append("timeInterval = ").append(this.timeInterval).append("    ").append(" )");
        return retValue.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.createTime ^ this.createTime >>> 32);
        result = 31 * result + (this.deleted ? 1231 : 1237);
        result = 31 * result + (this.emails == null ? 0 : this.emails.hashCode());
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.locale == null ? 0 : this.locale.hashCode());
        result = 31 * result + (this.outputFormat == null ? 0 : this.outputFormat.hashCode());
        result = 31 * result + (this.pageFormat == null ? 0 : this.pageFormat.hashCode());
        result = 31 * result + (this.reportDesign == null ? 0 : this.reportDesign.hashCode());
        result = 31 * result + (this.reportName == null ? 0 : this.reportName.hashCode());
        result = 31 * result + (this.reportParameters == null ? 0 : this.reportParameters.hashCode());
        result = 31 * result + (this.reportType == null ? 0 : this.reportType.hashCode());
        result = 31 * result + (this.timeInterval == null ? 0 : this.timeInterval.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledReport)) {
            return false;
        }
        ScheduledReport other = (ScheduledReport)((Object)obj);
        if (this.createTime != other.createTime) {
            return false;
        }
        if (this.deleted != other.deleted) {
            return false;
        }
        if (this.emails == null ? other.emails != null : !this.emails.equals(other.emails)) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.locale == null ? other.locale != null : !this.locale.equals(other.locale)) {
            return false;
        }
        if (this.outputFormat == null ? other.outputFormat != null : !this.outputFormat.equals(other.outputFormat)) {
            return false;
        }
        if (this.pageFormat == null ? other.pageFormat != null : !this.pageFormat.equals(other.pageFormat)) {
            return false;
        }
        if (this.reportDesign == null ? other.reportDesign != null : !this.reportDesign.equals(other.reportDesign)) {
            return false;
        }
        if (this.reportName == null ? other.reportName != null : !this.reportName.equals(other.reportName)) {
            return false;
        }
        if (this.reportParameters == null ? other.reportParameters != null : !this.reportParameters.equals(other.reportParameters)) {
            return false;
        }
        if (this.reportType == null ? other.reportType != null : !this.reportType.equals(other.reportType)) {
            return false;
        }
        return !(this.timeInterval == null ? other.timeInterval != null : !this.timeInterval.equals(other.timeInterval));
    }
}

