/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.datamodel.scheduledReports;

import de.proveo.util.jpa.entity.EntityBase;
import java.util.Arrays;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name="generated_report")
@NamedQueries(value={@NamedQuery(name="findGeneratedReportAll", query="SELECT a FROM GeneratedReport a")})
public class GeneratedReport
extends EntityBase {
    private static final long serialVersionUID = 8545266063386108364L;
    @Transient
    private static final int BLOB_SIZE = Integer.MAX_VALUE;
    @Id
    @Column(name="ID")
    @GenericGenerator(name="incrementer", strategy="increment")
    @GeneratedValue(generator="incrementer")
    private long id;
    @Column(name="CREATE_TIME")
    private long createTime;
    @Column(name="DATA_SIZE")
    private int dataSize;
    @Column(name="EMAILS")
    @Lob
    private String emails;
    @Column(name="ERROR_CODE")
    private Short errorCode;
    @Column(length=0x7FFFFFFF)
    @Lob
    private byte[] report;
    @Column(name="SCHEDULED_REPORT_ID")
    private long scheduledReportId;
    @Column(name="PROCESS_DURATION", nullable=false)
    private long processDuration;

    public GeneratedReport(GeneratedReport generatedReport) {
        this.id = generatedReport.id;
        this.createTime = generatedReport.createTime;
        this.report = generatedReport.report;
        this.scheduledReportId = generatedReport.scheduledReportId;
        this.processDuration = generatedReport.processDuration;
        this.dataSize = generatedReport.dataSize;
        this.emails = generatedReport.emails;
        this.errorCode = generatedReport.errorCode;
    }

    public GeneratedReport() {
    }

    public String getName() {
        return "";
    }

    public Object getPrimaryKey() {
        return this.id;
    }

    public long getId() {
        return this.id;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public byte[] getReport() {
        return this.report;
    }

    public void setReport(byte[] report) {
        this.report = report;
    }

    public long getScheduledReportId() {
        return this.scheduledReportId;
    }

    public void setScheduledReportId(long scheduledReportId) {
        this.scheduledReportId = scheduledReportId;
    }

    public long getProcessDuration() {
        return this.processDuration;
    }

    public void setProcessDuration(long processDuration) {
        this.processDuration = processDuration;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.createTime ^ this.createTime >>> 32);
        result = 31 * result + this.dataSize;
        result = 31 * result + (this.emails == null ? 0 : this.emails.hashCode());
        result = 31 * result + (this.errorCode == null ? 0 : this.errorCode.hashCode());
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (int)(this.processDuration ^ this.processDuration >>> 32);
        result = 31 * result + Arrays.hashCode(this.report);
        result = 31 * result + (int)(this.scheduledReportId ^ this.scheduledReportId >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        GeneratedReport other = (GeneratedReport)((Object)obj);
        if (this.createTime != other.createTime) {
            return false;
        }
        if (this.dataSize != other.dataSize) {
            return false;
        }
        if (this.emails == null ? other.emails != null : !this.emails.equals(other.emails)) {
            return false;
        }
        if (this.errorCode == null ? other.errorCode != null : !this.errorCode.equals(other.errorCode)) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.processDuration != other.processDuration) {
            return false;
        }
        if (!Arrays.equals(this.report, other.report)) {
            return false;
        }
        return this.scheduledReportId == other.scheduledReportId;
    }

    public String toString() {
        String TAB = "    ";
        String retValue = "";
        retValue = "GeneratedReport ( " + super.toString() + "    " + "id = " + this.id + "    " + "createTime = " + this.createTime + "    " + "report = " + this.report + "    " + "scheduledReportId = " + this.scheduledReportId + "    " + "processDuration = " + this.processDuration + "    " + " )";
        return retValue;
    }

    public void setDataSize(int dataSize) {
        this.dataSize = dataSize;
    }

    public int getDataSize() {
        return this.dataSize;
    }

    public void setEmails(String emails) {
        this.emails = emails;
    }

    public String getEmails() {
        return this.emails;
    }

    public void setErrorCode(Short errorCode) {
        this.errorCode = errorCode;
    }

    public Short getErrorCode() {
        return this.errorCode;
    }
}

