/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.datamodel.resourceString;

import de.proveo.maven.plugins.extendedObject.annotations.Equals;
import de.proveo.maven.plugins.extendedObject.annotations.ToString;
import de.proveo.util.jpa.entity.EntityBase;
import de.proveo.wwt.datamodel.locale.Locale;
import de.proveo.wwt.datamodel.module.Module;
import de.proveo.wwt.logic.ejb.entityListener.StateModelListener;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.QueryHint;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Table(name="resource_string")
@NamedQueries(value={@NamedQuery(name="ResourceString.findAll", query="SELECT r FROM ResourceString r", hints={@QueryHint(name="org.hibernate.cacheable", value="true")}), @NamedQuery(name="ResourceString.findByModuleIdAndLocaleId", query="SELECT r FROM ResourceString r WHERE pk.moduleId = ?1 AND pk.localeId = ?2", hints={@QueryHint(name="org.hibernate.cacheable", value="true")}), @NamedQuery(name="ResourceString.findByModuleIdAndStringId", query="SELECT r FROM ResourceString r WHERE pk.moduleId = ?1 AND pk.id = ?2", hints={@QueryHint(name="org.hibernate.cacheable", value="true")})})
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@EntityListeners(value={StateModelListener.class})
public class ResourceString
extends EntityBase {
    private static final long serialVersionUID = 3626356642221090202L;
    @EmbeddedId
    @Equals
    @ToString
    private PK pk = new PK();
    @Equals
    @Column(name="resource_value", length=4096, nullable=false)
    @ToString
    private String resourceValue;
    @ManyToOne(targetEntity=Locale.class, fetch=FetchType.LAZY)
    @JoinColumn(name="locale_id", insertable=false, updatable=false)
    private Locale locale;
    @ManyToOne(targetEntity=Module.class, fetch=FetchType.LAZY)
    @JoinColumn(name="module_id", insertable=false, updatable=false)
    private Module module;
    @Equals
    @Column(name="customized", nullable=false)
    @ToString
    private boolean customized = false;

    public ResourceString() {
    }

    public ResourceString(PK pk) {
        this.pk = pk;
    }

    public ResourceString(PK pk, String resourceValue) {
        this(pk);
        this.resourceValue = resourceValue;
    }

    public ResourceString(String id, int localeId, int moduleId, String resourceValue) {
        this(new PK(id, localeId, moduleId), resourceValue);
    }

    public String getName() {
        return this.pk.id;
    }

    public Object getPrimaryKey() {
        return this.pk;
    }

    public String getPk() {
        return this.pk.id;
    }

    public void setPk(PK pk) {
        this.pk = pk;
    }

    public String getResourceValue() {
        return this.resourceValue;
    }

    public void setResourceValue(String resourceValue) {
        this.resourceValue = resourceValue;
    }

    public int getLocaleId() {
        return this.pk.localeId;
    }

    public void setLocaleId(int localeId) {
        this.pk.localeId = localeId;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public int getModuleId() {
        return this.pk.moduleId;
    }

    public void setModuleId(int moduleId) {
        this.pk.moduleId = moduleId;
    }

    public Module getModule() {
        return this.module;
    }

    public boolean isCustomized() {
        return this.customized;
    }

    public void setCustomized(boolean customized) {
        this.customized = customized;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ResourceString");
        stringBuilder.append(" (");
        stringBuilder.append("pk = ");
        stringBuilder.append(this.pk == null ? "[null]" : this.pk.toString());
        stringBuilder.append(", ");
        stringBuilder.append("resourceValue = ");
        stringBuilder.append(this.resourceValue == null ? "[null]" : this.resourceValue.toString());
        stringBuilder.append(", ");
        stringBuilder.append("customized = ");
        stringBuilder.append(this.customized);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        ResourceString resourceString = (ResourceString)((Object)object);
        if (this.pk == null ? resourceString.pk != null : !this.pk.equals(resourceString.pk)) {
            return false;
        }
        if (this.resourceValue == null ? resourceString.resourceValue != null : !this.resourceValue.equals(resourceString.resourceValue)) {
            return false;
        }
        return this.customized == resourceString.customized;
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = n * n2 + (this.pk == null ? 0 : this.pk.hashCode());
        n2 = n * n2 + (this.resourceValue == null ? 0 : this.resourceValue.hashCode());
        n2 = n * n2 + (this.customized ? 0 : 1);
        return n2;
    }

    @Embeddable
    public static class PK
    implements Serializable {
        private static final long serialVersionUID = -4756378255623676938L;
        @Equals
        @Column(name="string_id", length=128)
        @ToString
        private String id;
        @Equals
        @Column(name="locale_id", nullable=false)
        @ToString
        private int localeId;
        @Equals
        @Column(name="module_id", nullable=false)
        @ToString
        private int moduleId;

        public PK(PK pk) {
            this.id = pk.id;
            this.localeId = pk.localeId;
            this.moduleId = pk.moduleId;
        }

        public PK(String id, int localeId, int applicationId) {
            this.id = id;
            this.localeId = localeId;
            this.moduleId = applicationId;
        }

        public PK() {
        }

        public int getLocaleId() {
            return this.localeId;
        }

        public void setLocaleId(int localeId) {
            this.localeId = localeId;
        }

        public int getModuleId() {
            return this.moduleId;
        }

        public void setModuleId(int moduleId) {
            this.moduleId = moduleId;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("ResourceString$PK");
            stringBuilder.append(" (");
            stringBuilder.append("id = ");
            stringBuilder.append(this.id == null ? "[null]" : this.id.toString());
            stringBuilder.append(", ");
            stringBuilder.append("localeId = ");
            stringBuilder.append(this.localeId);
            stringBuilder.append(", ");
            stringBuilder.append("moduleId = ");
            stringBuilder.append(this.moduleId);
            stringBuilder.append(")");
            return stringBuilder.toString();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            PK pK = (PK)object;
            if (this.id == null ? pK.id != null : !this.id.equals(pK.id)) {
                return false;
            }
            if (this.localeId != pK.localeId) {
                return false;
            }
            return this.moduleId == pK.moduleId;
        }

        public int hashCode() {
            int n = 31;
            int n2 = 1;
            n2 = n * n2 + (this.id == null ? 0 : this.id.hashCode());
            n2 = n * n2 + this.localeId;
            n2 = n * n2 + this.moduleId;
            return n2;
        }
    }
}

