/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.datamodel.notify;

import de.proveo.maven.plugins.extendedObject.annotations.Equals;
import de.proveo.maven.plugins.extendedObject.annotations.ToString;
import de.proveo.wwt.datamodel.base.HistoryHelperBase;
import de.proveo.wwt.datamodel.notify.NotifyBase;
import de.proveo.wwt.datamodel.notify.NotifyCache;
import de.proveo.wwt.datamodel.notify.NotifyHistoryHelper;
import de.proveo.wwt.logic.ejb.dataIn.event.history.IHistoryEntity;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name="notify_history")
@NamedQueries(value={@NamedQuery(name="findNotifyHistoryAll", query="SELECT h FROM NotifyHistory h"), @NamedQuery(name="findNotifyHistoryByUnitIdSorted", query="SELECT h FROM NotifyHistory h WHERE h.unitId = :unitId AND h.entry = :entry AND h.createTime BETWEEN :since AND :until ORDER BY h.createTime"), @NamedQuery(name="findNotifyHistoryByUnitIdNotifyId", query="SELECT h FROM NotifyHistory h WHERE h.unitId = :unitId AND h.messageId = :messageId AND h.entry = :entry AND h.createTime BETWEEN :since AND :until"), @NamedQuery(name="findNotifyHistoryAllOlderThanGivenTimestamp", query="SELECT h FROM NotifyHistory h WHERE h.createTime >= ?1 ORDER BY h.createTime"), @NamedQuery(name="findNotifyHistoryAllOlderThanGivenTimestampByUnitId", query="SELECT h FROM NotifyHistory h WHERE h.unitId = :unitId AND h.createTime >= :timestamp ORDER BY h.createTime"), @NamedQuery(name="findNotifyHistoryMaxHistoryId", query="SELECT MAX(h.id) FROM NotifyHistory h")})
public class NotifyHistory
extends NotifyBase
implements IHistoryEntity<NotifyHistory, NotifyCache> {
    private static final long serialVersionUID = -1079770453065146784L;
    @Id
    @Column(name="ID")
    @GenericGenerator(name="incrementer", strategy="increment")
    @GeneratedValue(generator="incrementer")
    @Equals
    @ToString
    private long id;
    @Column(name="UNIT_ID")
    @Equals
    @ToString
    private Long unitId;
    @Column(name="MESSAGE_ID")
    @Equals
    @ToString
    private long messageId;
    @JoinColumn(name="ID", updatable=false, insertable=false)
    @OneToMany(targetEntity=NotifyHistoryHelper.class, fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    private List<NotifyHistoryHelper> notifyHistoryHelper;
    @OneToOne(targetEntity=NotifyCache.class, fetch=FetchType.LAZY, cascade={CascadeType.REMOVE}, mappedBy="history")
    @JoinColumn(name="id", referencedColumnName="history_id", insertable=false, updatable=false)
    private NotifyCache cache;

    public NotifyHistory() {
    }

    public NotifyHistory(NotifyCache notifyCache) {
        super(notifyCache);
    }

    @Override
    public long getBeginTime() {
        return this.getCreateTime();
    }

    @Override
    public void setBeginTime(long timestamp) {
        this.setCreateTime(timestamp);
    }

    @Override
    public Class<? extends HistoryHelperBase> getHelperClass() {
        return NotifyHistoryHelper.class;
    }

    @Override
    public void finishHistory(NotifyHistory oldHistory) {
    }

    @Override
    public NotifyCache generateCache() {
        return new NotifyCache(this);
    }

    @Override
    public long getHistoryId() {
        return this.id;
    }

    @Override
    public void setHistoryId(long historyId) {
        this.id = historyId;
    }

    public Object getPrimaryKey() {
        return this.id;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Override
    public long getUnitId() {
        return this.unitId;
    }

    @Override
    public void setUnitId(long unitId) {
        this.unitId = unitId;
    }

    @Override
    public long getMessageId() {
        return this.messageId;
    }

    @Override
    public void setMessageId(long messageId) {
        this.messageId = messageId;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("NotifyHistory");
        stringBuilder.append(" (");
        stringBuilder.append("id = ");
        stringBuilder.append(this.id);
        stringBuilder.append(", ");
        stringBuilder.append("unitId = ");
        stringBuilder.append(this.unitId == null ? "[null]" : this.unitId.toString());
        stringBuilder.append(", ");
        stringBuilder.append("messageId = ");
        stringBuilder.append(this.messageId);
        stringBuilder.append(" (");
        stringBuilder.append(super.toString());
        stringBuilder.append(")");
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        NotifyHistory notifyHistory = (NotifyHistory)object;
        if (this.id != notifyHistory.id) {
            return false;
        }
        if (this.unitId == null ? notifyHistory.unitId != null : !this.unitId.equals(notifyHistory.unitId)) {
            return false;
        }
        return this.messageId == notifyHistory.messageId;
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = super.hashCode();
        n2 = n * n2 + (int)(this.id ^ this.id >>> 32);
        n2 = n * n2 + (this.unitId == null ? 0 : this.unitId.hashCode());
        n2 = n * n2 + (int)(this.messageId ^ this.messageId >>> 32);
        return n2;
    }
}

