/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.datamodel.measurement;

import de.proveo.maven.plugins.extendedObject.annotations.Equals;
import de.proveo.maven.plugins.extendedObject.annotations.ToString;
import de.proveo.util.jpa.entity.EntityBase;
import de.proveo.wwt.datamodel.area.Area;
import de.proveo.wwt.datamodel.geo.GdataHistory;
import de.proveo.wwt.datamodel.grouphistory.Grouphistory;
import de.proveo.wwt.datamodel.measurement.MeasurementHistory;
import de.proveo.wwt.datamodel.measurement.MeasurementIntervalDefn;
import de.proveo.wwt.datamodel.unit.model.UnitModel;
import de.proveo.wwt.datamodel.use.user.UseUser;
import de.proveo.wwt.logic.ejb.dataIn.event.history.IGdataHistory;
import de.proveo.wwt.logic.ejb.entityListener.MeasurementListener;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name="measurement_interval")
@EntityListeners(value={MeasurementListener.class})
public class MeasurementInterval
extends EntityBase
implements IGdataHistory {
    private static final long serialVersionUID = -4453289692961950802L;
    @Id
    @Column(name="ID")
    @GenericGenerator(name="incrementer", strategy="increment")
    @GeneratedValue(generator="incrementer")
    @Equals
    @ToString
    private int id;
    @Column(name="MEASUREMENT_FROM")
    @Equals
    @ToString
    private float measurementFrom;
    @Column(name="MEASUREMENT_TO")
    @Equals
    @ToString
    private float measurementTo;
    @Column(name="BEGIN_TIME")
    @Equals
    @ToString
    private long beginTime;
    @Column(name="END_TIME")
    @Equals
    @ToString
    private long endTime;
    @ManyToOne
    @JoinColumn(name="MEASUREMENT_INTERVAL_DEFN_ID")
    @Equals
    @ToString
    private MeasurementIntervalDefn measurementIntervalDefn;
    @ManyToOne
    @JoinColumn(name="MEASUREMENT_FROM_ID")
    private MeasurementHistory mesurementFrom;
    @ManyToOne
    @JoinColumn(name="MEASUREMENT_TO_ID")
    private MeasurementHistory measuremrentTo;
    @Column(name="GROUP_HISTORY_ID")
    @Equals
    @ToString
    private Long groupHistoryId;
    @ManyToOne(targetEntity=Grouphistory.class, fetch=FetchType.LAZY)
    @JoinColumn(name="GROUP_HISTORY_ID", updatable=false, insertable=false)
    private Grouphistory groupHistory;
    @Column(name="AREA_ID")
    @Equals
    @ToString
    private Integer areaId;
    @ManyToOne(targetEntity=Area.class, fetch=FetchType.LAZY)
    @JoinColumn(name="AREA_ID", updatable=false, insertable=false)
    private Area area;
    @Column(name="USE_USER_ID")
    @Equals
    @ToString
    private Long useUserId;
    @ManyToOne(targetEntity=UseUser.class, fetch=FetchType.LAZY)
    @JoinColumn(name="USE_USER_ID", updatable=false, insertable=false)
    private UseUser useUser;
    @Column(name="GDATA_HISTORY_ID")
    @Equals
    @ToString
    private Long gdataHistoryId;
    @ManyToOne(targetEntity=GdataHistory.class, fetch=FetchType.LAZY)
    @JoinColumn(name="GDATA_HISTORY_ID", updatable=false, insertable=false)
    private GdataHistory gdataHistory;
    @ManyToOne(targetEntity=UnitModel.class, fetch=FetchType.LAZY)
    @JoinColumn(name="UNIT_ID", updatable=false, insertable=false)
    private UnitModel unitModel;
    @Column(name="UNIT_ID", nullable=false)
    private long unitId;

    public Object getPrimaryKey() {
        return this.id;
    }

    public void setMeasurementFrom(float measurementFrom) {
        this.measurementFrom = measurementFrom;
    }

    public float getMeasurementFrom() {
        return this.measurementFrom;
    }

    public void setMeasurementTo(float measurementTo) {
        this.measurementTo = measurementTo;
    }

    public float getMeasurementTo() {
        return this.measurementTo;
    }

    public void setMeasurementIntervalDefn(MeasurementIntervalDefn measurementIntervalDefn) {
        this.measurementIntervalDefn = measurementIntervalDefn;
    }

    public MeasurementIntervalDefn getMeasurementIntervalDefn() {
        return this.measurementIntervalDefn;
    }

    public String getName() {
        return this.getPrimaryKey().toString();
    }

    public void setMesurementFrom(MeasurementHistory mesurementFrom) {
        this.mesurementFrom = mesurementFrom;
    }

    public MeasurementHistory getMesurementFrom() {
        return this.mesurementFrom;
    }

    public void setMeasuremrentTo(MeasurementHistory measuremrentTo) {
        this.measuremrentTo = measuremrentTo;
    }

    public MeasurementHistory getMeasuremrentTo() {
        return this.measuremrentTo;
    }

    public Long getGroupHistoryId() {
        return this.groupHistoryId;
    }

    public void setGroupHistoryId(Long groupHistoryId) {
        this.groupHistoryId = groupHistoryId;
    }

    public Grouphistory getGroupHistory() {
        return this.groupHistory;
    }

    public Integer getAreaId() {
        return this.areaId;
    }

    public void setAreaId(Integer areaId) {
        this.areaId = areaId;
    }

    public Long getUseUserId() {
        return this.useUserId;
    }

    public void setUseUserId(Long useUserId) {
        this.useUserId = useUserId;
    }

    @Override
    public Long getGdataHistoryId() {
        return this.gdataHistoryId;
    }

    @Override
    public void setGdataHistoryId(Long gdataHistoryId) {
        this.gdataHistoryId = gdataHistoryId;
    }

    public Area getArea() {
        return this.area;
    }

    @Override
    public GdataHistory getGdataHistory() {
        return this.gdataHistory;
    }

    public UseUser getUseUser() {
        return this.useUser;
    }

    public long getBeginTime() {
        return this.beginTime;
    }

    public void setBeginTime(long beginTime) {
        this.beginTime = beginTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public long getUnitId() {
        return this.unitId;
    }

    public void setUnitId(long unitId) {
        this.unitId = unitId;
    }

    public UnitModel getUnitModel() {
        return this.unitModel;
    }

    public void setUnitModel(UnitModel unitModel) {
        this.unitModel = unitModel;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("MeasurementInterval");
        stringBuilder.append(" (");
        stringBuilder.append("id = ");
        stringBuilder.append(this.id);
        stringBuilder.append(", ");
        stringBuilder.append("measurementFrom = ");
        stringBuilder.append(this.measurementFrom);
        stringBuilder.append(", ");
        stringBuilder.append("measurementTo = ");
        stringBuilder.append(this.measurementTo);
        stringBuilder.append(", ");
        stringBuilder.append("beginTime = ");
        stringBuilder.append(this.beginTime);
        stringBuilder.append(", ");
        stringBuilder.append("endTime = ");
        stringBuilder.append(this.endTime);
        stringBuilder.append(", ");
        stringBuilder.append("measurementIntervalDefn = ");
        stringBuilder.append(this.measurementIntervalDefn == null ? "[null]" : ((Object)((Object)this.measurementIntervalDefn)).toString());
        stringBuilder.append(", ");
        stringBuilder.append("groupHistoryId = ");
        stringBuilder.append(this.groupHistoryId == null ? "[null]" : this.groupHistoryId.toString());
        stringBuilder.append(", ");
        stringBuilder.append("areaId = ");
        stringBuilder.append(this.areaId == null ? "[null]" : this.areaId.toString());
        stringBuilder.append(", ");
        stringBuilder.append("useUserId = ");
        stringBuilder.append(this.useUserId == null ? "[null]" : this.useUserId.toString());
        stringBuilder.append(", ");
        stringBuilder.append("gdataHistoryId = ");
        stringBuilder.append(this.gdataHistoryId == null ? "[null]" : this.gdataHistoryId.toString());
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MeasurementInterval measurementInterval = (MeasurementInterval)object;
        if (this.id != measurementInterval.id) {
            return false;
        }
        if (Float.floatToIntBits(this.measurementFrom) != Float.floatToIntBits(measurementInterval.measurementFrom)) {
            return false;
        }
        if (Float.floatToIntBits(this.measurementTo) != Float.floatToIntBits(measurementInterval.measurementTo)) {
            return false;
        }
        if (this.beginTime != measurementInterval.beginTime) {
            return false;
        }
        if (this.endTime != measurementInterval.endTime) {
            return false;
        }
        if (this.measurementIntervalDefn == null ? measurementInterval.measurementIntervalDefn != null : !((Object)((Object)this.measurementIntervalDefn)).equals((Object)measurementInterval.measurementIntervalDefn)) {
            return false;
        }
        if (this.groupHistoryId == null ? measurementInterval.groupHistoryId != null : !this.groupHistoryId.equals(measurementInterval.groupHistoryId)) {
            return false;
        }
        if (this.areaId == null ? measurementInterval.areaId != null : !this.areaId.equals(measurementInterval.areaId)) {
            return false;
        }
        if (this.useUserId == null ? measurementInterval.useUserId != null : !this.useUserId.equals(measurementInterval.useUserId)) {
            return false;
        }
        return !(this.gdataHistoryId == null ? measurementInterval.gdataHistoryId != null : !this.gdataHistoryId.equals(measurementInterval.gdataHistoryId));
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = n * n2 + this.id;
        n2 = n * n2 + (this.measurementFrom == 0.0f ? 0 : Float.floatToIntBits(this.measurementFrom));
        n2 = n * n2 + (this.measurementTo == 0.0f ? 0 : Float.floatToIntBits(this.measurementTo));
        n2 = n * n2 + (int)(this.beginTime ^ this.beginTime >>> 32);
        n2 = n * n2 + (int)(this.endTime ^ this.endTime >>> 32);
        n2 = n * n2 + (this.measurementIntervalDefn == null ? 0 : ((Object)((Object)this.measurementIntervalDefn)).hashCode());
        n2 = n * n2 + (this.groupHistoryId == null ? 0 : this.groupHistoryId.hashCode());
        n2 = n * n2 + (this.areaId == null ? 0 : this.areaId.hashCode());
        n2 = n * n2 + (this.useUserId == null ? 0 : this.useUserId.hashCode());
        n2 = n * n2 + (this.gdataHistoryId == null ? 0 : this.gdataHistoryId.hashCode());
        return n2;
    }
}

