/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.datamodel.measurement;

import de.proveo.maven.plugins.extendedObject.annotations.Equals;
import de.proveo.maven.plugins.extendedObject.annotations.ToString;
import de.proveo.util.jpa.entity.EntityBase;
import de.proveo.wwt.datamodel.measurement.MeasurementDefinition;
import de.proveo.wwt.logic.ejb.entityListener.MeasurementListener;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="measurement_conversion")
@EntityListeners(value={MeasurementListener.class})
public class MeasurementConversion
extends EntityBase {
    private static final long serialVersionUID = 6878652822012315525L;
    @Id
    @Column(name="id")
    @Equals
    @ToString
    private int id;
    @Column(name="measurement_defn_id", nullable=false)
    @Equals
    @ToString
    private int measurementDefinitionId;
    @ManyToOne(targetEntity=MeasurementDefinition.class, fetch=FetchType.LAZY)
    @JoinColumn(name="measurement_defn_id", updatable=false, insertable=false)
    private MeasurementDefinition measurementDefinition;
    @Column(name="raw_value", nullable=false)
    @Equals
    @ToString
    private double rawValue;
    @Column(name="converted_value", nullable=false)
    @Equals
    @ToString
    private double convertedValue;

    public String getName() {
        return String.valueOf(this.id);
    }

    public Object getPrimaryKey() {
        return this.id;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getMeasurementDefinitionId() {
        return this.measurementDefinitionId;
    }

    public void setMeasurementDefinitionId(int measurementDefinitionId) {
        this.measurementDefinitionId = measurementDefinitionId;
    }

    public double getRawValue() {
        return this.rawValue;
    }

    public void setRawValue(double rawValue) {
        this.rawValue = rawValue;
    }

    public double getConvertedValue() {
        return this.convertedValue;
    }

    public void setConvertedValue(double convertedValue) {
        this.convertedValue = convertedValue;
    }

    public MeasurementDefinition getMeasurementDefinition() {
        return this.measurementDefinition;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("MeasurementConversion");
        stringBuilder.append(" (");
        stringBuilder.append("id = ");
        stringBuilder.append(this.id);
        stringBuilder.append(", ");
        stringBuilder.append("measurementDefinitionId = ");
        stringBuilder.append(this.measurementDefinitionId);
        stringBuilder.append(", ");
        stringBuilder.append("rawValue = ");
        stringBuilder.append(this.rawValue);
        stringBuilder.append(", ");
        stringBuilder.append("convertedValue = ");
        stringBuilder.append(this.convertedValue);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        MeasurementConversion measurementConversion = (MeasurementConversion)((Object)object);
        if (this.id != measurementConversion.id) {
            return false;
        }
        if (this.measurementDefinitionId != measurementConversion.measurementDefinitionId) {
            return false;
        }
        if (Double.doubleToLongBits(this.rawValue) != Double.doubleToLongBits(measurementConversion.rawValue)) {
            return false;
        }
        return Double.doubleToLongBits(this.convertedValue) == Double.doubleToLongBits(measurementConversion.convertedValue);
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = n * n2 + this.id;
        n2 = n * n2 + this.measurementDefinitionId;
        long l = this.rawValue == 0.0 ? 0L : Double.doubleToLongBits(this.rawValue);
        n2 = n * n2 + (int)(l ^ l >>> 32);
        l = this.convertedValue == 0.0 ? 0L : Double.doubleToLongBits(this.convertedValue);
        n2 = n * n2 + (int)(l ^ l >>> 32);
        return n2;
    }
}

