/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.datamodel.infoman.software;

import de.proveo.util.jpa.entity.EntityBase;
import de.proveo.wwt.datamodel.infoman.setup.update.InfomanUpdate;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Hibernate;
import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name="infoman_software")
@NamedQueries(value={@NamedQuery(name="findInfomanSoftwareAll", query="SELECT s FROM InfomanSoftware s"), @NamedQuery(name="findInfomanSoftwareAllWithoutDataBlob", query="SELECT s.softwareId, s.versionName, s.description, s.checksumType, s.checksum, s.softwareContentType, s.softwareFilename FROM InfomanSoftware s")})
public class InfomanSoftware
extends EntityBase {
    @Transient
    private static final int BLOB_SIZE = Integer.MAX_VALUE;
    @Id
    @Column(name="SOFTWARE_ID")
    @GenericGenerator(name="incrementer", strategy="increment")
    @GeneratedValue(generator="incrementer")
    private long softwareId;
    @Column(name="DESCRIPTION")
    private String description;
    @Column(name="SOFTWARE_CONTENT_TYPE")
    private String softwareContentType;
    @Column(name="CHECKSUM")
    private String checksum;
    @Column(length=0x7FFFFFFF)
    @Lob
    @Basic(fetch=FetchType.LAZY)
    private Blob software;
    @Column(name="VERSION_NAME")
    private String versionName;
    @Column(name="CHECKSUM_TYPE")
    private String checksumType;
    @Column(name="SOFTWARE_FILENAME")
    private String softwareFilename;
    @OneToMany(targetEntity=InfomanUpdate.class, mappedBy="infomanSoftware", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private List<InfomanUpdate> infomanUpdates = new ArrayList<InfomanUpdate>();
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(InfomanSoftware.class);

    public InfomanSoftware(InfomanSoftware infomanSoftware) {
        log.trace((Object)"Constructor InfomanSoftware(InfomanSoftware infomanSoftware) called");
        this.softwareId = infomanSoftware.softwareId;
        this.description = infomanSoftware.description;
        this.softwareContentType = infomanSoftware.softwareContentType;
        this.checksum = infomanSoftware.checksum;
        this.software = infomanSoftware.software;
        this.versionName = infomanSoftware.versionName;
        this.checksumType = infomanSoftware.checksumType;
        this.softwareFilename = infomanSoftware.softwareFilename;
        this.infomanUpdates = infomanSoftware.infomanUpdates;
    }

    public InfomanSoftware() {
    }

    public String getName() {
        return this.versionName;
    }

    public Object getPrimaryKey() {
        return this.softwareId;
    }

    public long getSoftwareId() {
        return this.softwareId;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getSoftwareContentType() {
        return this.softwareContentType;
    }

    public void setSoftwareContentType(String softwareContentType) {
        this.softwareContentType = softwareContentType;
    }

    public String getContentType() {
        return this.softwareContentType;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public byte[] getSoftware() {
        log.trace((Object)"getSoftware()");
        try {
            if (this.software != null) {
                return this.software.getBytes(1L, (int)this.software.length());
            }
        }
        catch (SQLException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return new byte[0];
    }

    public void setSoftware(byte[] software) {
        log.trace((Object)"setSoftware()");
        this.software = Hibernate.createBlob((byte[])software);
    }

    public String getVersionName() {
        return this.versionName;
    }

    public void setVersionName(String versionName) {
        this.versionName = versionName;
    }

    public String getChecksumType() {
        return this.checksumType;
    }

    public void setChecksumType(String checksumType) {
        this.checksumType = checksumType;
    }

    public String getSoftwareFilename() {
        return this.softwareFilename;
    }

    public String getFilename() {
        return this.softwareFilename;
    }

    public void setSoftwareFilename(String softwareFilename) {
        this.softwareFilename = softwareFilename;
    }

    public List<InfomanUpdate> getInfomanUpdates() {
        return this.infomanUpdates;
    }

    public void setInfomanUpdates(List<InfomanUpdate> infomanUpdates) {
        this.infomanUpdates = infomanUpdates;
    }

    public String toString() {
        String TAB = "    ";
        StringBuilder retValue = new StringBuilder();
        retValue.append("InfomanSoftware ( ").append(super.toString()).append("    ").append("checksum = ").append(this.checksum).append("    ").append("checksumType = ").append(this.checksumType).append("    ").append("description = ").append(this.description).append("    ").append("softwareContentType = ").append(this.softwareContentType).append("    ").append("softwareFilename = ").append(this.softwareFilename).append("    ").append("softwareId = ").append(this.softwareId).append("    ").append("versionName = ").append(this.versionName).append("    ").append(" )");
        return retValue.toString();
    }

    public int hashCode() {
        log.trace((Object)"hashCode()");
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.checksum == null ? 0 : this.checksum.hashCode());
        result = 31 * result + (this.checksumType == null ? 0 : this.checksumType.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.software == null ? 0 : this.software.hashCode());
        result = 31 * result + (this.softwareContentType == null ? 0 : this.softwareContentType.hashCode());
        result = 31 * result + (this.softwareFilename == null ? 0 : this.softwareFilename.hashCode());
        result = 31 * result + (int)(this.softwareId ^ this.softwareId >>> 32);
        result = 31 * result + (this.versionName == null ? 0 : this.versionName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        log.trace((Object)"equals(Object obj)");
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        InfomanSoftware other = (InfomanSoftware)((Object)obj);
        if (this.checksum == null ? other.checksum != null : !this.checksum.equals(other.checksum)) {
            return false;
        }
        if (this.checksumType == null ? other.checksumType != null : !this.checksumType.equals(other.checksumType)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.infomanUpdates == null ? other.infomanUpdates != null : !((Object)this.infomanUpdates).equals(other.infomanUpdates)) {
            return false;
        }
        if (this.software == null ? other.software != null : !this.software.equals(other.software)) {
            return false;
        }
        if (this.softwareContentType == null ? other.softwareContentType != null : !this.softwareContentType.equals(other.softwareContentType)) {
            return false;
        }
        if (this.softwareFilename == null ? other.softwareFilename != null : !this.softwareFilename.equals(other.softwareFilename)) {
            return false;
        }
        if (this.softwareId != other.softwareId) {
            return false;
        }
        return !(this.versionName == null ? other.versionName != null : !this.versionName.equals(other.versionName));
    }
}

