/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.datamodel.file;

import de.proveo.maven.plugins.extendedObject.annotations.Equals;
import de.proveo.maven.plugins.extendedObject.annotations.ToString;
import de.proveo.wwt.datamodel.file.FileBase;
import de.proveo.wwt.datamodel.file.FileStorage;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.FetchType;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.PersistenceContext;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;

@Entity
@Table(name="file_directory")
@NamedQueries(value={@NamedQuery(name="FileDirectory.findByModuleId", query="SELECT d FROM FileDirectory d WHERE d.moduleId = ?1 ORDER BY d.level, d.name"), @NamedQuery(name="FileDirectory.findByParentId", query="SELECT d FROM FileDirectory d WHERE d.parentId = ?1 ORDER BY d.name")})
public class FileDirectory
extends FileBase {
    private static final long serialVersionUID = -6936131770067137252L;
    @Equals
    @Column(name="level_no", nullable=false)
    @ToString
    private int level;
    @OneToMany(targetEntity=FileDirectory.class, fetch=FetchType.LAZY, cascade={CascadeType.REMOVE}, mappedBy="parentId")
    private List<FileDirectory> childDirectories = new ArrayList<FileDirectory>();
    @OneToMany(targetEntity=FileStorage.class, fetch=FetchType.LAZY, cascade={CascadeType.REMOVE}, mappedBy="parentId")
    private List<FileStorage> childFiles = new ArrayList<FileStorage>();
    @PersistenceContext(unitName="rts")
    private transient EntityManager entityManager = null;

    public void setLevel(int level) {
        this.level = level;
    }

    public int getLevel() {
        return this.level;
    }

    @PrePersist
    @PreUpdate
    private void preProcess() {
        Integer parentId = this.getParentId();
        if (parentId != null) {
            FileDirectory parentDirectory = (FileDirectory)((Object)this.entityManager.find(FileDirectory.class, (Object)parentId));
            this.level = parentDirectory.getLevel() + 1;
        } else {
            this.level = 0;
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("FileDirectory");
        stringBuilder.append(" (");
        stringBuilder.append("level = ");
        stringBuilder.append(this.level);
        stringBuilder.append(" (");
        stringBuilder.append(super.toString());
        stringBuilder.append(")");
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        FileDirectory fileDirectory = (FileDirectory)((Object)object);
        return this.level == fileDirectory.level;
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = super.hashCode();
        n2 = n * n2 + this.level;
        return n2;
    }
}

