/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.dataOut.rpc.airportmap.generator;

import de.proveo.rts.configuration.map.AirportMapGeneratorMBean;
import de.proveo.rts.configuration.map.AirportMapGeneratorUtil;
import de.proveo.util.connection.UserNotInRoleException;
import de.proveo.wwt.logic.app.security.LoginContextUtil;
import de.proveo.wwt.logic.ejb.general.area.Area;
import de.proveo.wwt.logic.ejb.general.area.AreaHome;
import de.proveo.wwt.logic.ejb.general.area.AreaUtil;
import de.proveo.wwt.logic.ejb.general.area.AreaValue;
import de.proveo.wwt.logic.ejb.general.config.Configuration;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationUtil;
import de.proveo.wwt.logic.ejb.general.unit.entity.identity.UnitIdentityValue;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelValue;
import de.proveo.wwt.logic.servlet.dataOut.rpc.SimpleRPCHandler;
import de.proveo.wwt.logic.servlet.dataOut.rpc.SimpleXMLRPCCall;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import de.proveo.wwt.logic.web.hierarchicalData.unitTree.UnitTreeFacade;
import de.proveo.wwt.logic.web.hierarchicalData.unitTree.UnitTreeFacadeUtil;
import de.proveo.wwt.logic.web.hierarchicalData.unitTree.dto.UnitTreeNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GetUnitGroupsTreeHandler
implements SimpleRPCHandler {
    private static final Log log = LogFactory.getLog(GetUnitGroupsTreeHandler.class);
    public static final String PARAM_AIRPORT_ID = "airportId";
    private Configuration configuration;
    private AreaHome areaHome;
    private UnitTreeFacade unitTreeFacade;
    private AirportMapGeneratorMBean airportMapGeneratorConfig;

    public Object execute(SimpleXMLRPCCall call) throws Exception {
        Object sendGeoFencingParameter;
        boolean admin;
        String username = "";
        char[] password = new char[]{};
        boolean sendDeleted = false;
        boolean sendGeoFencing = false;
        boolean sendNonGeoFencing = false;
        Object usernameParameter = call.getParameter("username");
        Object passwordParameter = call.getParameter("password");
        if (usernameParameter != null) {
            username = usernameParameter.toString();
        }
        if (passwordParameter != null) {
            password = (char[])passwordParameter;
        }
        LoginContextUtil lcu = null;
        try {
            lcu = new LoginContextUtil(username, password);
        }
        catch (LoginException ex) {
            log.warn((Object)("Login failed for user '" + username + "'!"));
            throw ex;
        }
        boolean bl = admin = lcu.isSuperAdmin() || lcu.isUserInRole("section.airportmapgenerator_admin");
        if (!admin && !lcu.isUserInRole("section.airportmapgenerator")) {
            throw new UserNotInRoleException("User '" + username + "' is not in role " + "section.airportmapgenerator" + "!");
        }
        if (this.configuration.isConfigured("airport.groupId")) {
            Long airportId = Long.parseLong(this.configuration.getParameter("airport.groupId"));
            log.debug((Object)("Retrun airport id '" + airportId + "' from configuration."));
            return airportId;
        }
        Object sendDeletedParameter = call.getParameter("sendDeleted");
        sendDeleted = sendDeletedParameter != null ? Boolean.parseBoolean(sendDeletedParameter.toString()) : lcu.isSuperAdmin() || lcu.isUserInRole("section.airportmapgenerator_admin");
        Object sendNonGeoFencingParameter = call.getParameter("sendAirportMapAreas");
        if (sendNonGeoFencingParameter != null) {
            sendNonGeoFencing = Boolean.parseBoolean(sendNonGeoFencingParameter.toString());
        }
        if ((sendGeoFencingParameter = call.getParameter("sendGeoFencingAreas")) != null) {
            sendGeoFencing = Boolean.parseBoolean(sendGeoFencingParameter.toString());
        }
        if (sendNonGeoFencing && sendGeoFencing) {
            log.error((Object)"Client wants to get both, geo fencing and airportmap areas. This isn't possible, will send only airportmap areas!");
            sendGeoFencing = false;
        } else if (!sendNonGeoFencing && !sendGeoFencing) {
            log.warn((Object)"Client wants to get none of the area types, neither geo fencing nor airportmap areas!?!");
        } else {
            if (!admin && sendNonGeoFencing && !lcu.isUserInRole("section.airportmapgenerator.airportmap")) {
                throw new UserNotInRoleException("User '" + username + "' is not in the needed role for this operation: " + "section.airportmapgenerator.airportmap");
            }
            if (!admin && sendGeoFencing && !lcu.isUserInRole("section.airportmapgenerator.geofencing")) {
                throw new UserNotInRoleException("User '" + username + "' is not in the needed role for this operation: " + "section.airportmapgenerator.geofencing");
            }
        }
        Collection areaEntities = this.areaHome.findAreasAllocatedToUnit();
        if (areaEntities == null || areaEntities.size() <= 0) {
            boolean onlyNonAllocatedAreasInDatabase = true;
            for (Area area : areaEntities) {
                AreaValue areaValue = area.getAreaValue();
                if (areaValue.getDeleted()) continue;
                onlyNonAllocatedAreasInDatabase = false;
                break;
            }
            if (onlyNonAllocatedAreasInDatabase) {
                log.debug((Object)"Retrun airport id null, cause no area is allocated to any unit id.");
                return null;
            }
        }
        UnitTreeNode unitTree = this.unitTreeFacade.getWebTreeModel(false, true);
        log.debug((Object)"Retrun unit group tree, that the user can select, which airport has to be updated.");
        return this.builUnitTreeMap((UnitTreeNode)unitTree.getRoot(), admin, sendDeleted, sendGeoFencing, sendNonGeoFencing);
    }

    public String getMethodName() {
        return "GetUnitGroupsTree";
    }

    public void init() throws Exception {
        this.areaHome = AreaUtil.getHome();
        this.unitTreeFacade = UnitTreeFacadeUtil.getHome().create();
        this.configuration = ConfigurationUtil.getHome().create();
        this.airportMapGeneratorConfig = AirportMapGeneratorUtil.getMBean();
    }

    private Map builUnitTreeMap(UnitTreeNode unitNode, boolean admin, boolean sendDeleted, boolean sendGeoFencing, boolean sendNonGeoFencing) {
        HashMap<Long, HashMap<String, Object>> treeNodeMap = null;
        UnitModelValue unitModelValue = ((UnitDTO)unitNode.getData()).getUnitModelValue();
        UnitIdentityValue unitIdentityValue = ((UnitDTO)unitNode.getData()).getUnitIdentityValue();
        String name = unitIdentityValue.getName();
        String imageName = unitIdentityValue.getImageName();
        long unitId = unitModelValue.getUnitId();
        if (admin) {
            name = name + " (" + unitId + ")";
        }
        if (!unitModelValue.getBasic()) {
            List children = unitNode.getChildren();
            HashMap<String, Object> value = new HashMap<String, Object>();
            value.put("name", name);
            value.put("imageName", imageName);
            value.put("allowsChildren", true);
            if (children != null) {
                ArrayList<Map> childsList = new ArrayList<Map>();
                for (UnitTreeNode childUnitNode : children) {
                    Map childTreeNode = this.builUnitTreeMap(childUnitNode, admin, sendDeleted, sendGeoFencing, sendNonGeoFencing);
                    if (childTreeNode == null) continue;
                    childsList.add(childTreeNode);
                }
                if (childsList.size() > 0) {
                    value.put("children", childsList);
                } else {
                    value.put("allowsChildren", false);
                }
            }
            try {
                Collection areaEntities = null;
                areaEntities = unitId == 0L ? this.areaHome.findAreasNotAllocatedToUnit() : this.areaHome.findOrderedByPriorityByAirport(unitId);
                int areasSize = 0;
                if (areaEntities != null) {
                    for (Area area : areaEntities) {
                        AreaValue areaValue = area.getAreaValue();
                        boolean areaDeleted = areaValue.getDeleted();
                        boolean areaGeoFencing = areaValue.getIsGeofencing();
                        if (!sendDeleted && areaDeleted || !sendGeoFencing && areaGeoFencing || !sendNonGeoFencing && !areaGeoFencing) continue;
                        ++areasSize;
                    }
                }
                if (areasSize > 0) {
                    name = name + " [" + areasSize + "]";
                    value.put("name", name);
                }
            }
            catch (Throwable ex) {
                log.warn((Object)("Could not fetch areas for unit with id '" + unitId + "'"), ex);
            }
            treeNodeMap = new HashMap<Long, HashMap<String, Object>>();
            treeNodeMap.put(unitId, value);
        }
        return treeNodeMap;
    }

    public boolean isDisabled() {
        return this.airportMapGeneratorConfig.isClientsDisabled();
    }
}

