/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.dataOut.rpc.airportmap;

import de.proveo.wwt.logic.ejb.general.unit.entity.identity.UnitIdentityValue;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelValue;
import de.proveo.wwt.logic.servlet.dataOut.rpc.SimpleRPCHandler;
import de.proveo.wwt.logic.servlet.dataOut.rpc.SimpleXMLRPCCall;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import de.proveo.wwt.logic.web.hierarchicalData.unitTree.UnitTreeFacade;
import de.proveo.wwt.logic.web.hierarchicalData.unitTree.UnitTreeFacadeUtil;
import de.proveo.wwt.logic.web.hierarchicalData.unitTree.dto.UnitTreeNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GetAPReplayUnitTreeHandler
implements SimpleRPCHandler {
    public static final String PARAM_IS_ADMIN = "isAdmin";
    public static final String PARAM_UNIT_GROUP_ID = "unitGroupId";
    public static final String PARAM_UNIT_PERMISSIONS = "permissions";
    private UnitTreeFacade unitTreeFacade;
    private boolean isAdmin = false;
    private long unitGroupId = -1L;

    public Object execute(SimpleXMLRPCCall call) throws Exception {
        Object unitGroupIdObj;
        Object isSuperAdminObj = call.getParameter(PARAM_IS_ADMIN);
        if (isSuperAdminObj != null) {
            this.isAdmin = Boolean.valueOf(isSuperAdminObj.toString());
        }
        if ((unitGroupIdObj = call.getParameter(PARAM_UNIT_GROUP_ID)) != null) {
            this.unitGroupId = Long.valueOf(unitGroupIdObj.toString());
        }
        Set unitPermissions = null;
        Object unitPermissionsObj = call.getParameter(PARAM_UNIT_PERMISSIONS);
        if (unitPermissionsObj != null) {
            unitPermissions = (Set)unitPermissionsObj;
        }
        UnitTreeNode rootUnitNode = null;
        if (unitPermissions != null && unitPermissions.size() > 0) {
            rootUnitNode = this.unitTreeFacade.getWebTreeModel(false, false);
            rootUnitNode.removeUnauthorizedUnits(unitPermissions);
        } else {
            rootUnitNode = this.unitTreeFacade.getWebTreeModel(true, false);
        }
        UnitTreeNode unitGroupNode = this.findUnitGroupNode(rootUnitNode);
        if (unitGroupNode != null) {
            rootUnitNode = unitGroupNode;
        }
        return this.builUnitTreeMap(rootUnitNode);
    }

    public String getMethodName() {
        return "GetAPReplayUnitTree";
    }

    public void init() throws Exception {
        this.unitTreeFacade = UnitTreeFacadeUtil.getHome().create();
    }

    private UnitTreeNode findUnitGroupNode(UnitTreeNode unitNode) {
        List children;
        if (unitNode == null) {
            return null;
        }
        UnitTreeNode ret = null;
        UnitModelValue unitModelValue = ((UnitDTO)unitNode.getData()).getUnitModelValue();
        long unitId = unitModelValue.getUnitId();
        if (unitId == this.unitGroupId) {
            return unitNode;
        }
        if (unitNode.hasChildren() && (children = unitNode.getChildren()) != null) {
            for (UnitTreeNode childUnitNode : children) {
                ret = this.findUnitGroupNode(childUnitNode);
                if (ret == null) continue;
                return ret;
            }
        }
        return ret;
    }

    private Map builUnitTreeMap(UnitTreeNode unitNode) {
        HashMap treeNodeMap = new HashMap();
        if (unitNode == null) {
            return treeNodeMap;
        }
        UnitModelValue unitModelValue = ((UnitDTO)unitNode.getData()).getUnitModelValue();
        UnitIdentityValue unitIdentityValue = ((UnitDTO)unitNode.getData()).getUnitIdentityValue();
        String name = unitIdentityValue.getName();
        long unitId = unitModelValue.getUnitId();
        if (!unitModelValue.getBasic()) {
            List children = unitNode.getChildren();
            HashMap<String, Object> value = new HashMap<String, Object>();
            value.put("name", name);
            value.put("imageName", "");
            value.put("allowsChildren", true);
            if (children != null) {
                ArrayList<Map> childsList = new ArrayList<Map>();
                for (UnitTreeNode childUnitNode : children) {
                    Map childTreeNode = this.builUnitTreeMap(childUnitNode);
                    childsList.add(childTreeNode);
                }
                value.put("children", childsList);
            }
            treeNodeMap = new HashMap();
            treeNodeMap.put(unitId, value);
        } else {
            HashMap<String, Object> value = new HashMap<String, Object>();
            if (this.isAdmin) {
                value.put("name", name + " (" + unitId + ")");
            } else {
                value.put("name", name);
            }
            value.put("imageName", unitIdentityValue.getImageName());
            value.put("allowsChildren", false);
            treeNodeMap = new HashMap();
            treeNodeMap.put(unitId, value);
        }
        return treeNodeMap;
    }

    public boolean isDisabled() {
        return false;
    }
}

