/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.dataOut.rpc;

import de.proveo.wwt.logic.servlet.dataOut.rpc.SimpleXMLRPCCall;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleXMLRPCCallImpl
implements SimpleXMLRPCCall {
    private static final Log log = LogFactory.getLog(SimpleXMLRPCCallImpl.class);
    protected static final String ENCODE_PREFIX = "ENC:";
    private Map<String, Object> parameters = new HashMap<String, Object>();
    private String method;

    @Override
    public void addParameter(String name, Object value) {
        try {
            this.parameters.put(name, this.transparentEncode(value));
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public Object getParameter(String key) {
        Object value = this.parameters.get(key);
        try {
            return this.transparentDecode(value);
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    @Override
    public void removeParameter(String name) {
        this.parameters.remove(name);
    }

    @Override
    public void setMethod(String method) {
        this.method = method;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    protected Object transparentDecode(Object value) throws UnsupportedEncodingException {
        if (value instanceof String && ((String)value).startsWith(ENCODE_PREFIX)) {
            String content = ((String)value).substring(ENCODE_PREFIX.length());
            return Base64.decodeBase64((byte[])content.getBytes("UTF8"));
        }
        return value;
    }

    protected Object transparentEncode(Object value) throws UnsupportedEncodingException {
        if (value instanceof byte[]) {
            StringBuffer buffer = new StringBuffer(ENCODE_PREFIX);
            buffer.append(new String(Base64.encodeBase64((byte[])((byte[])value)), "UTF8"));
            return buffer.toString();
        }
        return value;
    }
}

