/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.dataOut;

import de.proveo.rts.configuration.map.AirportMapMBean;
import de.proveo.rts.configuration.map.AirportMapUtil;
import de.proveo.util.observable.interfaces.ServletBlocker;
import de.proveo.wwt.logic.app.security.LoginContextUtil;
import de.proveo.wwt.logic.ejb.dataOut.mapclient.MapClientFacade;
import de.proveo.wwt.logic.ejb.dataOut.mapclient.MapClientFacadeHome;
import de.proveo.wwt.logic.ejb.general.config.Configuration;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationUtil;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MapClientServlet
extends HttpServlet
implements ServletBlocker {
    private static final Log log = LogFactory.getLog(MapClientServlet.class);
    private static final String INIT_PARAM_MAP_CLIENT_FACADE = "MapClientFacadeSB_JNDI_Name";
    private static final String INIT_PARAM_FETCH_INTERVAL = "minTimeBetweenFetches";
    private static final String CONTENT_TYPE = "application/octet-stream";
    private static Set allStamps;
    private static long lastFetchStart;
    private static long lastFetchEnd;
    private static long fetchTimeout;
    private MapClientFacade mapClientFacade;
    private boolean fetchIsRunning = false;
    private long minTimeBetweenFetches = 7500L;
    private boolean isRunning;
    private AirportMapMBean airportMapConfig;
    private Configuration configuration;
    private LoginContextUtil lcu;
    private String username = "";
    private String password = "";
    private long unitGroupId = -1L;

    public void destroy() {
        this.mapClientFacade = null;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.warn((Object)"doGet() entered... client should use POST instead GET !");
        this.doPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.airportMapConfig.isClientsDisabled()) {
            response.sendError(503);
            return;
        }
        String method = "doPost(): ";
        String returnMsg = "'URL_DID_NOT_WORK'";
        response.setContentType(CONTENT_TYPE);
        this.username = request.getParameter("username");
        this.password = request.getParameter("password");
        if (this.username == null || this.password == null) {
            log.warn((Object)"username or password not given (old APMap version 2.x)");
        } else {
            try {
                this.lcu = new LoginContextUtil(this.username, this.password);
                this.lcu.login4AirportMap();
            }
            catch (Exception ex) {
                log.error((Object)"runs into", (Throwable)ex);
            }
        }
        this.handleOnlineRequest(request, response);
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String method = "init(): ";
        String fetchInterval = config.getInitParameter(INIT_PARAM_FETCH_INTERVAL);
        if (fetchInterval != null && fetchInterval.length() > 0) {
            this.minTimeBetweenFetches = Long.parseLong(fetchInterval);
            log.debug((Object)(method + "read from web.xml 'minTimeBetweenFetches'=" + this.minTimeBetweenFetches));
        }
        fetchTimeout = 20L * this.minTimeBetweenFetches;
        String jndiName = config.getInitParameter(INIT_PARAM_MAP_CLIENT_FACADE);
        if (jndiName == null || jndiName.length() == 0) {
            throw new ServletException("InitParameter: [MapClientFacadeSB_JNDI_Name] not found");
        }
        try {
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup(jndiName);
            MapClientFacadeHome home = (MapClientFacadeHome)PortableRemoteObject.narrow((Object)ref, MapClientFacadeHome.class);
            this.mapClientFacade = home.create();
            this.airportMapConfig = AirportMapUtil.getMBean();
            this.configuration = ConfigurationUtil.getHome().create();
        }
        catch (Exception ex) {
            log.error((Object)"runs during lookup for MapClientFacade session bean into", (Throwable)ex);
            throw new ServletException("runs during lookup for MapClientFacade session bean into", (Throwable)ex);
        }
    }

    private String fetchOnlineData() throws ServletException {
        String returnMsg = "";
        try {
            allStamps = this.mapClientFacade.getOnlineMapData(false, false, false, this.username, this.password, this.unitGroupId);
            returnMsg = "'URL_dispatched_CORRECTLY'";
        }
        catch (RemoteException ex) {
            log.error((Object)"runs into", (Throwable)ex);
            throw new ServletException("runs into", (Throwable)ex);
        }
        if (allStamps.isEmpty()) {
            returnMsg = "no units found (in CURRENT_GDATA_CACHE) !";
            log.debug((Object)returnMsg);
        } else {
            returnMsg = allStamps.size() + " units found to serialize.";
        }
        return returnMsg;
    }

    private HashMap filterData(HttpServletRequest request, long now) {
        String method = "filterData(): ";
        HashMap filteredStamps = new HashMap();
        if (allStamps == null) {
            log.warn((Object)(method + "allStamps==null, no stamps up to now"));
            return filteredStamps;
        }
        long unitId = 0L;
        String unitKind = "";
        String unitName = "";
        List requestedUnitIds = this.getParameters(request, "unitId");
        List requestedUnitKinds = this.getParameters(request, "unitKind");
        List requestedOperationstates = this.getParameters(request, "operationState");
        List requestedMotorstates = this.getParameters(request, "motorState");
        List requestedServicestates = this.getParameters(request, "serviceState");
        List requestedAssignedstates = this.getParameters(request, "assignedState");
        List requestedFuelstates = this.getParameters(request, "fuelState");
        List requestedConnectorstates = this.getParameters(request, "connectorState");
        List requestedFlag1states = this.getParameters(request, "flag1State");
        List requestedFlag2states = this.getParameters(request, "flag2State");
        List requestedFlag3states = this.getParameters(request, "flag3State");
        List requestedOnlinestates = this.getParameters(request, "onlineState");
        String requestedIsAlive = request.getParameter("isAlive");
        String requestedIsAliveTimeout = request.getParameter("isAliveTimeout");
        if (requestedOnlinestates.size() > 0 && requestedIsAlive != null && requestedIsAlive.length() > 0) {
            log.error((Object)"mixed use of 'onlineState' (new) and 'isAlive' (old) not allowed in URL! Check client configuration!");
        }
        for (HashMap stamp : allStamps) {
            HashMap<String, Object> fStamp = new HashMap<String, Object>();
            Object oVal = this.getStampValue(stamp, "UnitId");
            if (oVal == null) {
                log.error((Object)(method + " stamp does not contain an unit ID!"));
                continue;
            }
            unitId = (Long)oVal;
            fStamp.put("UnitId", oVal);
            oVal = this.getStampValue(stamp, "UnitKind");
            if (oVal == null) {
                log.error((Object)(method + " stamp does not contain an unit type!"));
                continue;
            }
            unitKind = (String)oVal;
            fStamp.put("UnitKind", oVal);
            unitName = (String)this.getStampValue(stamp, "UnitName");
            fStamp.put("UnitName", unitName);
            if (requestedUnitIds.size() > 0 && !requestedUnitIds.contains(Long.toString(unitId)) || requestedUnitKinds.size() > 0 && !requestedUnitKinds.contains(unitKind) || requestedIsAlive != null && requestedIsAlive.length() > 0 && !this.matchFilterKeepalive(requestedIsAlive, requestedIsAliveTimeout, now, stamp, fStamp, unitId, unitName) || requestedOnlinestates.size() > 0 && !this.matchFilterOnlinestate(requestedOnlinestates, requestedIsAliveTimeout, now, stamp, fStamp, unitId, unitName) || !this.matchFilter(requestedOperationstates, stamp, fStamp, "OperationState") || !this.matchFilter(requestedMotorstates, stamp, fStamp, "MotorState") || !this.matchFilter(requestedServicestates, stamp, fStamp, "ServiceState") || !this.matchFilter(requestedAssignedstates, stamp, fStamp, "AssignedState") || !this.matchFilter(requestedFuelstates, stamp, fStamp, "FuelState") || !this.matchFilter(requestedConnectorstates, stamp, fStamp, "ConnectorState")) continue;
            for (String key : stamp.keySet()) {
                Object obj = stamp.get(key);
                if (fStamp.containsKey(key)) continue;
                fStamp.put(key, obj);
            }
            filteredStamps.put(new Long(unitId), fStamp);
        }
        return filteredStamps;
    }

    private List getParameters(HttpServletRequest request, String key) {
        ArrayList<String> list = new ArrayList<String>();
        String par = request.getParameter(key);
        if (par != null) {
            StringTokenizer st = new StringTokenizer(par, ",");
            while (st.hasMoreTokens()) {
                String str = st.nextToken();
                list.add(str);
            }
        }
        return list;
    }

    private Object getStampValue(HashMap stamp, String key) {
        return this.getStampValue(stamp, key, false);
    }

    private Object getStampValue(HashMap stamp, String key, boolean optional) {
        if (stamp.containsKey(key)) {
            return stamp.get(key);
        }
        if (!optional) {
            log.error((Object)("stamp HashMap doesn't contain a value for key '" + key + "' !"));
        }
        return null;
    }

    private void handleOnlineRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String method = "handleOnlineRequest(): ";
        String returnMsg = "'URL_DID_NOT_WORK'";
        String unitGroupIdStr = request.getParameter("unitGroupId");
        this.unitGroupId = -1L;
        try {
            if (this.configuration.isConfigured("airport.groupId")) {
                Long airportId = Long.parseLong(this.configuration.getParameter("airport.groupId"));
                log.debug((Object)("Use airport id '" + airportId + "' from configuration."));
                this.unitGroupId = airportId;
            }
        }
        catch (Throwable ex) {
            log.error((Object)"Could not get configuration parameter \"airport.groupId\"", ex);
        }
        if (this.unitGroupId == -1L) {
            try {
                this.unitGroupId = Long.valueOf(unitGroupIdStr);
                log.debug((Object)("Given unit group ID is: '" + this.unitGroupId + "'"));
            }
            catch (Throwable ex) {
                log.debug((Object)("Given unit group ID isn't a long value: '" + unitGroupIdStr + "'"));
            }
        }
        boolean ignoreCache = false;
        String paraIgnoreCache = request.getParameter("ignoreCache");
        if (paraIgnoreCache != null) {
            ignoreCache = Boolean.valueOf(paraIgnoreCache);
        }
        long start = System.currentTimeMillis();
        long diff = start - lastFetchEnd;
        boolean doTheFetch = true;
        if (diff > this.minTimeBetweenFetches || ignoreCache) {
            if (this.fetchIsRunning) {
                log.debug((Object)(method + "another fetch is already running ..."));
                if (lastFetchEnd == 0L) {
                    log.debug((Object)(method + "first global fetch on the way, give him a chance ..."));
                    try {
                        Thread.sleep(this.minTimeBetweenFetches);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    doTheFetch = false;
                } else if (lastFetchStart > 0L && start - lastFetchStart > fetchTimeout) {
                    log.error((Object)(method + "already running fetch is over time (" + fetchTimeout / 1000L + "s), try another fetch ..."));
                    doTheFetch = true;
                } else {
                    log.debug((Object)(method + "do not start a second fetch, use buffered data instead"));
                    doTheFetch = false;
                }
            }
            if (doTheFetch) {
                this.fetchIsRunning = true;
                lastFetchStart = start;
                if (log.isDebugEnabled()) {
                    if (diff > this.minTimeBetweenFetches) {
                        if (lastFetchEnd == 0L) {
                            log.debug((Object)(method + "MapClientServlet initialized, no buffered data up to now, fetch data..."));
                        } else {
                            log.debug((Object)(method + "buffered data to old, fetch new data..."));
                        }
                    } else {
                        log.debug((Object)(method + "cache should be ignored, fetch new data..."));
                    }
                }
                returnMsg = this.fetchOnlineData();
                lastFetchEnd = System.currentTimeMillis();
                diff = lastFetchEnd - start;
                if (log.isDebugEnabled()) {
                    log.debug((Object)(method + "time for fetchOnlineData(): " + diff + "ms"));
                }
                if (diff > this.minTimeBetweenFetches) {
                    log.warn((Object)(method + "time for fetch was greater than " + this.minTimeBetweenFetches + "ms between 2 fetches! (time was " + diff + "ms)"));
                }
                this.fetchIsRunning = false;
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)(method + "buffered data newer than " + this.minTimeBetweenFetches + " ms, use buffered data..."));
        }
        HashMap filteredStamps = this.filterData(request, start);
        this.writeResponseStream(response, filteredStamps);
        if (log.isDebugEnabled()) {
            log.debug((Object)(method + "time for fetchOnlineData(), filterData() and writeResponseStream(): " + (System.currentTimeMillis() - start) + "ms"));
        }
    }

    private boolean matchFilter(List reqList, HashMap stamp, HashMap fStamp, String stampKey) {
        if (reqList.size() == 0) {
            return true;
        }
        Object oVal = this.getStampValue(stamp, stampKey);
        if (oVal != null && reqList.contains(oVal.toString())) {
            fStamp.put(stampKey, oVal);
            return true;
        }
        return false;
    }

    private boolean matchFilterKeepalive(String requestedIsAlive, String requestedIsAliveTimeout, long now, HashMap stamp, HashMap fStamp, long unitId, String unitName) {
        if (requestedIsAlive == null || requestedIsAlive != null && requestedIsAlive.length() == 0) {
            return true;
        }
        if (requestedIsAlive.equals("true,false") || requestedIsAlive.equals("false,true")) {
            return true;
        }
        String method = "matchFilterKeepalive: ";
        Object oVal = this.getStampValue(stamp, "KeepaliveTimestamp");
        boolean timeout = true;
        boolean keepaliveExist = true;
        long lastKeepaliveTimestamp = (Long)oVal;
        if (lastKeepaliveTimestamp == 0L) {
            keepaliveExist = false;
            timeout = false;
        } else if (requestedIsAliveTimeout != null) {
            long requestedTimeout = Long.parseLong(requestedIsAliveTimeout);
            timeout = now - lastKeepaliveTimestamp > requestedTimeout;
        } else {
            oVal = this.getStampValue(stamp, "KeepaliveTimeout");
            if (oVal != null) {
                timeout = (Boolean)oVal;
            }
        }
        if (timeout && (oVal = this.getStampValue(stamp, "InfomanOnlineState", true)) != null && Long.parseLong(oVal.toString()) == 2111L) {
            timeout = false;
        }
        if (Boolean.parseBoolean(requestedIsAlive) == !timeout) {
            if (lastKeepaliveTimestamp > 0L) {
                fStamp.put("KeepaliveTimeout", new Boolean(timeout));
                fStamp.put("KeepaliveTimestamp", new Long(lastKeepaliveTimestamp));
            }
            return true;
        }
        return false;
    }

    private boolean matchFilterOnlinestate(List reqOnlinestates, String requestedIsAliveTimeout, long now, HashMap stamp, HashMap fStamp, long unitId, String unitName) {
        if (reqOnlinestates.size() == 0) {
            return true;
        }
        String method = "matchFilterOnlinestate: ";
        boolean onlineStateExist = true;
        long onlineState = 0L;
        long stateTimestamp = 0L;
        Object oVal = this.getStampValue(stamp, "InfomanOnlineState", true);
        if (oVal != null) {
            onlineState = (Long)oVal;
            oVal = this.getStampValue(stamp, "InfomanOnlineStateBegin");
            stateTimestamp = (Long)oVal;
        } else {
            onlineStateExist = false;
        }
        if (!onlineStateExist || onlineState != 2111L) {
            oVal = this.getStampValue(stamp, "KeepaliveTimestamp");
            stateTimestamp = (Long)oVal;
            if (stateTimestamp == 0L) {
                onlineState = 2112L;
            } else if (requestedIsAliveTimeout != null) {
                long requestedTimeout = Long.parseLong(requestedIsAliveTimeout);
                onlineState = now - stateTimestamp > requestedTimeout ? 2113L : 2112L;
            } else {
                oVal = this.getStampValue(stamp, "KeepaliveTimeout");
                if (oVal != null) {
                    onlineState = ((Boolean)oVal).booleanValue() ? 2113L : 2112L;
                } else {
                    log.error((Object)(method + "MapClientStamp: key '" + "KeepaliveTimestamp" + "' exists in stamp, but '" + "KeepaliveTimeout" + "' is missing !"));
                    onlineState = 2112L;
                }
            }
        }
        if (reqOnlinestates.contains(Long.toString(onlineState))) {
            if (stateTimestamp > 0L) {
                fStamp.put("InfomanOnlineState", new Long(onlineState));
                fStamp.put("InfomanOnlineStateBegin", new Long(stateTimestamp));
            }
            return true;
        }
        return false;
    }

    private void writeResponseStream(HttpServletResponse response, HashMap filteredStamps) throws IOException {
        HashMap<String, Serializable> mcr = new HashMap<String, Serializable>();
        mcr.put("ServerTime", new Long(System.currentTimeMillis()));
        mcr.put("Stamps", filteredStamps);
        ServletOutputStream sos = response.getOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream((OutputStream)sos);
        oos.writeObject(mcr);
        oos.flush();
        oos.close();
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void stopRunning() {
        log.debug((Object)"MapClientServlet.stopRunning() called...");
        this.isRunning = false;
    }

    static {
        lastFetchStart = 0L;
        lastFetchEnd = 0L;
        fetchTimeout = 0L;
    }
}

