/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.dataIn.stands.threads;

import de.proveo.wwt.logic.ejb.dataIn.informant.InformantClient;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationClient;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationParameterNotFoundException;
import de.proveo.wwt.logic.servlet.dataIn.stands.connector.AbstractStandsConnector;
import java.io.IOException;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UpdateAllStandsDataThread
extends Thread {
    private static final Log log = LogFactory.getLog(UpdateAllStandsDataThread.class);
    private AbstractStandsConnector standsCentralConnector = null;
    private ConfigurationClient configurationClient = null;
    private InformantClient informantClient = new InformantClient();
    private boolean isRunning = true;
    private boolean update = false;
    private boolean updateAllData = false;
    private int waitLatency = 0;

    public UpdateAllStandsDataThread(AbstractStandsConnector standsCentralConnector) {
        this.standsCentralConnector = standsCentralConnector;
        this.configurationClient = new ConfigurationClient();
        try {
            this.waitLatency = this.configurationClient.getInteger("observable.stands.updateAllData.latency");
        }
        catch (ConfigurationParameterNotFoundException e) {
            log.error((Object)"UpdateAllStandsDataThread() runs into ConfigurationParameterNotFoundException: ", (Throwable)e);
            this.informantClient.notify("UpdateAllStandsDataThread() runs into ConfigurationParameterNotFoundException: " + (Object)((Object)e), "StandErrorEvent");
        }
        catch (RemoteException e) {
            log.error((Object)"UpdateAllStandsDataThread() runs into RemoteException: ", (Throwable)e);
            this.informantClient.notify("UpdateAllStandsDataThread() runs into RemoteException: " + e, "StandErrorEvent");
        }
    }

    public boolean isUpdate() {
        return this.update;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        String method = "run(): ";
        while (this.isRunning) {
            UpdateAllStandsDataThread updateAllStandsDataThread = this;
            synchronized (updateAllStandsDataThread) {
                try {
                    this.wait(2000L);
                    if (this.update) {
                        log.debug((Object)(method + "Waiting to start update process: " + this.waitLatency / 1000 + "s"));
                        this.wait(this.waitLatency);
                        this.standsCentralConnector.updateData(this.updateAllData);
                        log.debug((Object)"Update process finished!");
                    }
                }
                catch (InterruptedException e) {
                    log.debug((Object)(method + "thread sleep interrupted."));
                    this.informantClient.notify(method + "runs into InterruptedException: " + e, "StandErrorEvent");
                }
                catch (UnknownHostException e) {
                    log.error((Object)(method + "runs into UnknownHostException: "), (Throwable)e);
                    this.informantClient.notify(method + "runs into UnknownHostException: " + e, "StandErrorEvent");
                }
                catch (IOException e) {
                    log.error((Object)(method + "runs into IOException: "), (Throwable)e);
                    this.informantClient.notify(method + "runs into IOException: " + e, "StandErrorEvent");
                }
                catch (Exception e) {
                    log.error((Object)(method + "runs into Exception: "), (Throwable)e);
                    this.informantClient.notify(method + "runs into Exception: " + e, "StandErrorEvent");
                }
            }
        }
    }

    public void startUpdateAllDataProcess() {
        this.update = true;
        this.updateAllData = true;
    }

    public void startUpdateProcess() {
        this.update = true;
    }

    public void stopThread() {
        this.isRunning = false;
    }
}

