/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.dataIn.observable.threads;

import de.proveo.util.observable.interfaces.UnitBulkDataUpdateListener;
import de.proveo.wwt.logic.ejb.dataIn.informant.InformantClient;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationClient;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationParameterNotFoundException;
import java.rmi.RemoteException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UnitBulkDataUpdateThread
extends Thread {
    private static final Log log = LogFactory.getLog(UnitBulkDataUpdateThread.class);
    private UnitBulkDataUpdateListener unitBulkDataUpdateListener = null;
    private ConfigurationClient configurationClient;
    private InformantClient informantClient = null;
    private boolean isRunning = true;
    private int timeToUpdateBulkData = 1800000;

    public UnitBulkDataUpdateThread() {
        log.debug((Object)"UpdateBulkDataThread started!");
        this.informantClient = new InformantClient();
        try {
            this.configurationClient = new ConfigurationClient();
            this.timeToUpdateBulkData = Integer.parseInt(this.configurationClient.getParameter("observable.unitbulkdatathread.latency"));
        }
        catch (RemoteException e) {
            log.error((Object)("UpdateBulkDataThread() runs into RemoteException: " + e));
            this.informantClient.notify("UpdateBulkDataThread() runs into RemoteException: " + e, "UnitErrorEvent");
        }
        catch (NumberFormatException e) {
            log.error((Object)("UpdateBulkDataThread() runs into NumberFormatException: " + e));
            this.informantClient.notify("UpdateBulkDataThread() runs into NumberFormatException: " + e, "UnitErrorEvent");
        }
        catch (ConfigurationParameterNotFoundException e) {
            log.error((Object)("UpdateBulkDataThread() runs into ConfigurationParameterNotFoundException: " + (Object)((Object)e)));
            this.informantClient.notify("UpdateBulkDataThread() runs into CreateConfigurationParameterNotFoundExceptionException: " + (Object)((Object)e), "UnitErrorEvent");
        }
    }

    public void removeListener() {
        this.unitBulkDataUpdateListener = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.isRunning) {
            try {
                UnitBulkDataUpdateThread unitBulkDataUpdateThread = this;
                synchronized (unitBulkDataUpdateThread) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"******************** Update of bulk data *****************************************");
                        log.debug((Object)("UpdateBulkDataThread (" + this.toString() + ") will executed in " + this.timeToUpdateBulkData / 60000 + " minutes"));
                        log.debug((Object)"**********************************************************************************");
                    }
                    UnitBulkDataUpdateThread.sleep(this.timeToUpdateBulkData);
                }
                if (this.isRunning) {
                    log.debug((Object)"run() - Starting to update the bulk data!");
                    this.unitBulkDataUpdateListener.updateBulkData();
                    log.debug((Object)("run() - Bulk data has been updated!" + this.toString()));
                    continue;
                }
                log.debug((Object)"Thread closed. leaving run-Method()");
            }
            catch (InterruptedException e) {
                log.warn((Object)("UpdateBulkDataThread --> sleep interrupted  | Keep on running: " + this.isRunning));
            }
            catch (Exception e) {
                log.error((Object)"run() runs into Exception: ", (Throwable)e);
            }
        }
        log.debug((Object)"Leaving UpdateBulkDataThread run()-method. Thread closed");
    }

    public void setListener(UnitBulkDataUpdateListener unitBulkDataUpdateListener) {
        this.unitBulkDataUpdateListener = unitBulkDataUpdateListener;
    }

    public void stopRunning() {
        log.debug((Object)("Set StopRunning: " + this.toString()));
        this.isRunning = false;
    }

    public boolean isRunning() {
        return this.isRunning;
    }
}

