/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.dataIn.observable.data;

import de.proveo.util.observable.exceptions.NoAirportMapUnitException;
import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.wwt.logic.app.keepalive.event.KeepAliveEvent;
import de.proveo.wwt.logic.app.notify.event.NotifyEvent;
import de.proveo.wwt.logic.app.use.event.UseEvent;
import de.proveo.wwt.logic.ejb.dataIn.scanmanmsg.ScanmanMsgHistoryValue;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.CurrentStateCacheValue;
import de.proveo.wwt.logic.ejb.dataIn.use.UseFacade;
import de.proveo.wwt.logic.ejb.dataIn.use.UseFacadeUtil;
import de.proveo.wwt.logic.ejb.dataOut.mapclient.MapClientFacade;
import de.proveo.wwt.logic.ejb.dataOut.mapclient.MapClientFacadeUtil;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationClient;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationParameterNotFoundException;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserValue;
import de.proveo.wwt.logic.ejb.general.use.user.UserNotFoundException;
import de.proveo.wwt.logic.ejb.geo.GeoStruct;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.TreeMap;
import javax.ejb.CreateException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GSEDataUtil {
    private static final Log log = LogFactory.getLog(GSEDataUtil.class);
    private UseFacade useFacade = null;
    private ConfigurationClient configurationClient = null;
    private long infomanKeepaliveTimeout = 0L;
    private MapClientFacade mapClientFacade = null;

    public GSEDataUtil() {
        try {
            this.useFacade = UseFacadeUtil.getHome().create();
            this.mapClientFacade = MapClientFacadeUtil.getHome().create();
        }
        catch (RemoteException e) {
            log.error((Object)"GSEDataLogic runs into RemoteException: ", (Throwable)e);
        }
        catch (CreateException e) {
            log.error((Object)"GSEDataLogic runs into CreateException: ", (Throwable)e);
        }
        catch (NamingException e) {
            log.error((Object)"GSEDataLogic runs into NamingException: ", (Throwable)e);
        }
        long value = -1L;
        String parameter = this.getParameter("infoman.keepalive.timeout", "300");
        if (parameter != null) {
            value = Long.parseLong(parameter);
        }
        this.infomanKeepaliveTimeout = value * 60L * 1000L;
    }

    public HashMap<String, Object> createFittingEventMap(SerializableEventWrapper eventWrapper) {
        HashMap eventMap = null;
        String eventType = eventWrapper.get_typeOfEvent();
        if (eventType.equals("GeoStructHistoryAndCache")) {
            log.debug((Object)"Event type: GeoStruct");
            GeoStruct event = (GeoStruct)eventWrapper.get_cacheValue();
            eventMap = this.getGeoEventMap(event);
        } else if (eventType.equals("StateEventHistoryAndCache")) {
            log.debug((Object)"Event type: StateEvent");
            CurrentStateCacheValue event = (CurrentStateCacheValue)eventWrapper.get_cacheValue();
            eventMap = this.getStateEventMap(event);
        } else if (eventType.equals("KeepAlive")) {
            log.debug((Object)"Event type: KeepAliveEvent");
            KeepAliveEvent event = (KeepAliveEvent)eventWrapper.get_cacheValue();
            eventMap = this.getKeepaliveEventMap(event);
        } else if (eventType.equals("InfomanMessages")) {
            log.debug((Object)"Event type: InfomanEvent (Scanman Message)");
            ScanmanMsgHistoryValue event = (ScanmanMsgHistoryValue)eventWrapper.get_cacheValue();
            eventMap = this.getInfomanEventMap(event);
        } else if (eventType.equals("InfomanNotifyMessages")) {
            log.debug((Object)"Event type: NotifyEvent");
            NotifyEvent event = (NotifyEvent)eventWrapper.get_cacheValue();
            eventMap = this.getNotifyEventMap(event);
        } else if (eventType.equals("UseEvent")) {
            log.debug((Object)"Event type: UseEvent");
            UseEvent event = (UseEvent)eventWrapper.get_cacheValue();
            eventMap = this.getUseEventMap(event);
        } else {
            log.error((Object)("Found unknown event type '" + eventType + "'!"));
        }
        return eventMap;
    }

    private HashMap<String, Object> getGeoEventMap(GeoStruct geoStruct) {
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        valueMap.put("EventType", "GeoStruct");
        valueMap.put("UnitId", geoStruct.getUnitId());
        valueMap.put("GeoBegin", geoStruct.getBeginTime());
        valueMap.put("GpsRmc", geoStruct.getRmcRec());
        valueMap.put("GpsGga", geoStruct.getGgaRec());
        valueMap.put("GpsTrusted", geoStruct.isTrusted());
        valueMap.put("GpsLatMsec", geoStruct.getLatMSEC());
        valueMap.put("GpsLongMsec", geoStruct.getLongMSEC());
        valueMap.put("Area", geoStruct.getArea());
        valueMap.put("AreaName", geoStruct.getAreaDescription());
        return valueMap;
    }

    private HashMap getKeepaliveEventMap(KeepAliveEvent keepAliveEvent) {
        long timeStamp = keepAliveEvent.getCreateTimestamp();
        boolean timeout = false;
        if (System.currentTimeMillis() - timeStamp > this.infomanKeepaliveTimeout) {
            timeout = true;
        }
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        valueMap.put("EventType", "KeepAliveEvent");
        valueMap.put("UnitId", keepAliveEvent.getUnitId());
        valueMap.put("KeepaliveTimestamp", timeStamp);
        valueMap.put("KeepaliveTimeout", timeout);
        return valueMap;
    }

    private HashMap getNotifyEventMap(NotifyEvent notifyEvent) {
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        valueMap.put("EventType", "data_type_notification_event");
        valueMap.put("NotifyTimestamp", notifyEvent.getTimestamp());
        valueMap.put("NotifyEntry", notifyEvent.isEntry());
        valueMap.put("NotifyMessageID", notifyEvent.getMessageId());
        valueMap.put("NotifyMessage", notifyEvent.getMessage());
        valueMap.put("NotifyReceiveTime", notifyEvent.getReceiveTime());
        valueMap.put("UnitId", notifyEvent.getUnitId());
        return valueMap;
    }

    private HashMap getInfomanEventMap(ScanmanMsgHistoryValue scanmanMsgHistoryValue) {
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        valueMap.put("EventType", "data_type_infoman_event");
        valueMap.put("UnitId", scanmanMsgHistoryValue.getUnitId());
        if (scanmanMsgHistoryValue.getType() == 9 || scanmanMsgHistoryValue.getType() == 25 || scanmanMsgHistoryValue.getType() == 10) {
            if (scanmanMsgHistoryValue.getType() == 9) {
                valueMap.put("SmErrorTimestamp", scanmanMsgHistoryValue.getCreateTime());
                valueMap.put("SmErrorMessage", scanmanMsgHistoryValue.getMsgToString());
            } else if (scanmanMsgHistoryValue.getType() == 25) {
                valueMap.put("SmBootTimestamp", scanmanMsgHistoryValue.getCreateTime());
                valueMap.put("SmBootMessage", scanmanMsgHistoryValue.getMsgToString());
            } else if (scanmanMsgHistoryValue.getType() == 10) {
                valueMap.put("SmIpTimestamp", scanmanMsgHistoryValue.getCreateTime());
                valueMap.put("SmIpMessage", scanmanMsgHistoryValue.getMsgToString());
            }
        }
        return valueMap;
    }

    private HashMap getStateEventMap(CurrentStateCacheValue stateEvent) {
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        valueMap.put("EventType", "StateEvent");
        valueMap.put("UnitId", stateEvent.getUnitId());
        valueMap.put("StateModelID", stateEvent.getStateModelId());
        this.fillupStateEventData(stateEvent, valueMap);
        return valueMap;
    }

    private HashMap getUseEventMap(UseEvent useEvent) {
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        valueMap.put("EventType", "UseEvent");
        valueMap.put("UseEventUserKey", useEvent.getUserKey());
        try {
            long userId = this.useFacade.getUserIdByKey(useEvent.getUserKey());
            UseUserValue useUserValue = this.useFacade.getUser(userId);
            valueMap.put("UseEventDriverName", useUserValue.getName());
            valueMap.put("UseEventPersonalNumber", useUserValue.getPersonalNumber());
        }
        catch (RemoteException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        catch (UserNotFoundException e) {
            log.warn((Object)("user not found for key: " + useEvent.getUserKey()));
        }
        valueMap.put("UnitId", useEvent.getUnitId());
        valueMap.put("UseEventTimestamp", useEvent.getTimestamp());
        valueMap.put("UseEventUserGroupId", useEvent.getUserGroupId());
        valueMap.put("UseEventLogin", useEvent.isLogin());
        valueMap.put("UseEventReceiveTime", useEvent.getReceiveTime());
        return valueMap;
    }

    private void fillupStateEventData(CurrentStateCacheValue stateEvent, HashMap valueMap) {
        if (stateEvent.getStateModelId() == 2010L) {
            valueMap.put("MotorState", stateEvent.getState());
            valueMap.put("MotorStateBegin", stateEvent.getBeginTime());
        } else if (stateEvent.getStateModelId() == 2110L) {
            valueMap.put("InfomanOnlineState", stateEvent.getState());
            valueMap.put("InfomanOnlineStateBegin", stateEvent.getBeginTime());
        } else if (stateEvent.getStateModelId() == 2050L) {
            valueMap.put("OperationState", stateEvent.getState());
            valueMap.put("OperationStateBegin", stateEvent.getBeginTime());
        } else if (stateEvent.getStateModelId() == 2090L) {
            valueMap.put("ServiceState", stateEvent.getState());
            valueMap.put("ServiceStateBegin", stateEvent.getBeginTime());
            valueMap.put("ServiceStateRemark", stateEvent.getRemark());
        } else if (stateEvent.getStateModelId() == 2100L) {
            valueMap.put("AssignedState", stateEvent.getState());
            valueMap.put("AssignedStateBegin", stateEvent.getBeginTime());
            valueMap.put("AssignedStateRemark", stateEvent.getRemark());
        } else if (stateEvent.getStateModelId() == 2030L) {
            valueMap.put("FuelState", stateEvent.getState());
            valueMap.put("FuelStateBegin", stateEvent.getBeginTime());
        } else if (stateEvent.getStateModelId() == 2120L) {
            valueMap.put("GseAssignmentState", stateEvent.getState());
            valueMap.put("GseAssignmentStateBegin", stateEvent.getBeginTime());
        } else if (stateEvent.getStateModelId() == 2020L) {
            valueMap.put("ConnectorState", stateEvent.getState());
            valueMap.put("ConnectorStateBegin", stateEvent.getBeginTime());
        } else if (stateEvent.getStateModelId() == 2910L) {
            valueMap.put("Flag1State", stateEvent.getState());
            valueMap.put("Flag1StateBegin", stateEvent.getBeginTime());
            valueMap.put("Flag1StateRemark", stateEvent.getRemark());
        } else if (stateEvent.getStateModelId() == 2920L) {
            valueMap.put("Flag2State", stateEvent.getState());
            valueMap.put("Flag2StateBegin", stateEvent.getBeginTime());
            valueMap.put("Flag2StateRemark", stateEvent.getRemark());
        } else if (stateEvent.getStateModelId() == 2930L) {
            valueMap.put("Flag3State", stateEvent.getState());
            valueMap.put("Flag3StateBegin", stateEvent.getBeginTime());
            valueMap.put("Flag3StateRemark", stateEvent.getRemark());
        } else {
            log.error((Object)("fillupStateEventData(): unknown state model ID " + stateEvent.getStateModelId() + " !"));
        }
    }

    public String getParameter(String key, String defaultValue) {
        if (this.configurationClient == null) {
            this.configurationClient = new ConfigurationClient();
        }
        String value = null;
        try {
            value = defaultValue != null ? this.configurationClient.getParameter(key, defaultValue) : this.configurationClient.getParameter(key);
        }
        catch (RemoteException e) {
            log.error((Object)"getParameter runs into RemoteException: ", (Throwable)e);
        }
        catch (ConfigurationParameterNotFoundException e) {
            log.error((Object)"getParameter runs into ConfigurationParameterNotFoundException: ", (Throwable)e);
        }
        return value;
    }

    public HashMap<String, Object> createStampWithNotifyMsg(HashMap<String, Object> eventMap, long unitID) throws RemoteException, NoAirportMapUnitException {
        TreeMap<String, HashMap> notifyEvents = new TreeMap<String, HashMap>();
        Long timeStamp = (Long)eventMap.get("NotifyTimestamp");
        Long msgID = (Long)eventMap.get("NotifyMessageID");
        eventMap.remove("EventType");
        notifyEvents.put(timeStamp + "_" + msgID, eventMap);
        eventMap = (HashMap)this.mapClientFacade.addUnitIdentityBasicData(new HashMap(), Long.valueOf(unitID));
        eventMap.put("NotifyEvents", notifyEvents);
        return eventMap;
    }
}

