/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.dataIn.observable.client.services;

import de.proveo.util.observable.wrapper.PermissionVO;
import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.wwt.logic.servlet.dataIn.observable.client.ObservableClient;
import de.proveo.wwt.logic.servlet.dataIn.observable.client.ObservableClientFactory;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AirportmapStatusChangeProvider
implements MessageListener {
    private static final Log log = LogFactory.getLog(AirportmapStatusChangeProvider.class);
    private boolean reconnected = false;
    private ObservableClientFactory clientFactory = null;

    public AirportmapStatusChangeProvider(ObservableClientFactory clientFactory) {
        this.clientFactory = clientFactory;
        this.establishJMSConnection();
        log.debug((Object)"JMSViewPermissionClient started!");
    }

    public void onMessage(Message message) {
        log.debug((Object)"New update of permission settings received!");
        try {
            Serializable object = ((ObjectMessage)message).getObject();
            SerializableEventWrapper event = (SerializableEventWrapper)object;
            this.updateClientViewPermissions(event.getPermissionVOList());
        }
        catch (JMSException e) {
            log.error((Object)"onMessage runs into JMSException: ", (Throwable)e);
        }
    }

    private void updateClientViewPermissions(List<PermissionVO> permissionVOList) {
        this.checkForAPMapFlagChanges(permissionVOList);
        ConcurrentHashMap<String, ObservableClient> clientPool = this.clientFactory.getObservableClientPoolByUserName();
        Iterator it = clientPool.values().iterator();
        PermissionVO permissionVO = null;
        while (it.hasNext()) {
            ObservableClient observableClient = (ObservableClient)it.next();
            permissionVO = null;
            permissionVO = this.checkClient(permissionVOList, observableClient);
            if (permissionVO == null) continue;
            if (permissionVO.isAirportMapFlagSet()) {
                this.initClientBulkUpdate(observableClient);
                continue;
            }
            if (permissionVO.isUserDeleted()) {
                this.shutdownAirportMap(observableClient);
                continue;
            }
            if (permissionVO.isRoleChanged()) {
                this.roleChangeForMap(observableClient);
                continue;
            }
            if (permissionVO.isUserPwChanged()) {
                this.pwChangeForUser(observableClient);
                continue;
            }
            observableClient.getObservableUnitsClient().scheduleNextUpdateThread(true);
        }
    }

    private void checkForAPMapFlagChanges(List<PermissionVO> permissionVOList) {
        PermissionVO permissionVO;
        Long unitID;
        if (permissionVOList.size() == 1 && (unitID = this.isAirportMapFlagSet(permissionVO = permissionVOList.iterator().next())) != null) {
            this.clientFactory.unitBulkData.setAPMapFlagByUnitID(unitID, permissionVO.isAirportMapVisible());
        }
    }

    private Long isAirportMapFlagSet(PermissionVO permissionVO) {
        return permissionVO.isAirportMapFlagSet() ? permissionVO.getUnitID() : null;
    }

    private void initClientBulkUpdate(ObservableClient observableClient) {
        observableClient.getObservableUnitsClient().scheduleNextUpdateThread(true);
    }

    private void shutdownAirportMap(ObservableClient observableClient) {
        HashMap<String, String> eventMap = new HashMap<String, String>();
        eventMap.put("DataType", "data_type_server_messages");
        eventMap.put("ServerMessage", "ServerMessageUserDeleted");
        try {
            observableClient.getClient().sendObject(eventMap);
        }
        catch (IOException e) {
            log.error((Object)"shutdownAirportMap runs into IOException: ", (Throwable)e);
        }
        observableClient.setMarkedForShutdown(true);
    }

    private void roleChangeForMap(ObservableClient observableClient) {
        HashMap<String, String> eventMap = new HashMap<String, String>();
        eventMap.put("DataType", "data_type_server_messages");
        eventMap.put("ServerMessage", "ServerMessageRoleChanged");
        try {
            observableClient.getClient().sendObject(eventMap);
        }
        catch (IOException e) {
            log.error((Object)"roleChangeForMap runs into IOException: ", (Throwable)e);
        }
    }

    private void pwChangeForUser(ObservableClient observableClient) {
        HashMap<String, String> eventMap = new HashMap<String, String>();
        eventMap.put("DataType", "data_type_server_messages");
        eventMap.put("ServerMessage", "ServerMessagePwUserChanged");
        try {
            observableClient.getClient().sendObject(eventMap);
        }
        catch (IOException e) {
            log.error((Object)"pwChangeForUser runs into IOException: ", (Throwable)e);
        }
    }

    private PermissionVO checkClient(List<PermissionVO> permissionVOList, ObservableClient observableClient) {
        Iterator<PermissionVO> i$ = permissionVOList.iterator();
        if (i$.hasNext()) {
            PermissionVO permissionVO = i$.next();
            if (permissionVO.getUserName().equals(observableClient.getUsername())) {
                return permissionVO;
            }
            return observableClient.getObservableUnitsClient().hasPermissionForUnitID(permissionVO.getUnitID()) ? permissionVO : null;
        }
        return null;
    }

    private void establishJMSConnection() {
        this.reconnected = false;
        try {
            InitialContext ctx = new InitialContext();
            Topic topic = null;
            TopicSession session = null;
            TopicSubscriber subscriber = null;
            TopicConnectionFactory fact = (TopicConnectionFactory)ctx.lookup("ConnectionFactory");
            final TopicConnection connect = fact.createTopicConnection();
            connect.setExceptionListener(new ExceptionListener(){
                public static final int NUM_RETRIES = 3;
                boolean exceptionFlag = false;

                public synchronized void onException(JMSException ex) {
                    if (this.exceptionFlag) {
                        return;
                    }
                    this.exceptionFlag = true;
                    for (int i = 0; i < 3; ++i) {
                        log.warn((Object)("Connection has problems, trying to re-create it, attempt " + (i + 1) + " ..."));
                        try {
                            connect.close();
                        }
                        catch (Exception e2) {
                            1 v0 = this;
                            log.error((Object)"ExceptionLister is not able to close the connection!");
                        }
                        AirportmapStatusChangeProvider.this.establishJMSConnection();
                        if (AirportmapStatusChangeProvider.this.reconnected) {
                            log.info((Object)"Connection re-established");
                            return;
                        }
                        log.warn((Object)"Re-creating connection failed, retrying ...");
                    }
                }
            });
            session = connect.createTopicSession(false, 2);
            try {
                topic = (Topic)ctx.lookup("topic/proveoDataProviderTopic");
            }
            catch (NameNotFoundException ex) {
                topic = session.createTopic("topic/proveoDataProviderTopic");
                ctx.bind("topic/proveoDataProviderTopic", (Object)topic);
            }
            subscriber = session.createSubscriber(topic, this.clientFactory.getSelectorString("ViewPermissionUpdateMessage"), true);
            subscriber.setMessageListener((MessageListener)this);
            connect.start();
            this.reconnected = true;
        }
        catch (NamingException e) {
            log.error((Object)"establishJMSConnection runs into NamingException: ", (Throwable)e);
        }
        catch (JMSException e) {
            log.error((Object)"establishJMSConnection runs into JMSException: ", (Throwable)e);
        }
    }
}

