/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.dataIn.observable.client.services;

import de.proveo.wwt.logic.servlet.dataIn.observable.client.ObservableClient;
import de.proveo.wwt.logic.servlet.dataIn.observable.client.ObservableClientFactory;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AirportMapMaintenance
implements MessageListener {
    private static final Log log = LogFactory.getLog(AirportMapMaintenance.class);
    private volatile boolean reconnected = false;
    private ObservableClientFactory clientFactory = null;

    public AirportMapMaintenance(ObservableClientFactory clientFactory) {
        this.clientFactory = clientFactory;
        this.establishJMSConnection();
        log.debug((Object)"JMSViewPermissionClient started!");
    }

    private void establishJMSConnection() {
        this.reconnected = false;
        try {
            InitialContext ctx = new InitialContext();
            Topic topic = null;
            TopicSession session = null;
            TopicSubscriber subscriber = null;
            TopicConnectionFactory fact = (TopicConnectionFactory)ctx.lookup("ConnectionFactory");
            final TopicConnection connect = fact.createTopicConnection();
            connect.setExceptionListener(new ExceptionListener(){
                public static final int NUM_RETRIES = 3;
                boolean exceptionFlag = false;

                public synchronized void onException(JMSException ex) {
                    if (this.exceptionFlag) {
                        return;
                    }
                    this.exceptionFlag = true;
                    for (int i = 0; i < 3; ++i) {
                        log.warn((Object)("Connection has problems, trying to re-create it, attempt " + (i + 1) + " ..."));
                        try {
                            connect.close();
                        }
                        catch (Exception e2) {
                            1 v0 = this;
                            log.error((Object)"ExceptionLister is not able to close the connection!");
                        }
                        AirportMapMaintenance.this.establishJMSConnection();
                        if (AirportMapMaintenance.this.reconnected) {
                            log.info((Object)"Connection re-established");
                            return;
                        }
                        log.warn((Object)"Re-creating connection failed, retrying ...");
                    }
                }
            });
            session = connect.createTopicSession(false, 2);
            try {
                topic = (Topic)ctx.lookup("topic/proveoDataProviderTopic");
            }
            catch (NameNotFoundException ex) {
                topic = session.createTopic("topic/proveoDataProviderTopic");
                ctx.bind("topic/proveoDataProviderTopic", (Object)topic);
            }
            subscriber = session.createSubscriber(topic, this.clientFactory.getSelectorString("AirportMapMaintenance"), true);
            subscriber.setMessageListener((MessageListener)this);
            connect.start();
            this.reconnected = true;
        }
        catch (NamingException e) {
            log.error((Object)"establishJMSConnection runs into NamingException: ", (Throwable)e);
        }
        catch (JMSException e) {
            log.error((Object)"establishJMSConnection runs into JMSException: ", (Throwable)e);
        }
    }

    public void onMessage(Message message) {
        try {
            String maintenanceMsg = (String)((Object)((ObjectMessage)message).getObject());
            this.handleMsg(maintenanceMsg);
        }
        catch (JMSException e) {
            log.error((Object)"onMessage runs into: ", (Throwable)e);
        }
    }

    private void handleMsg(String maintenanceMsg) {
        if (maintenanceMsg.startsWith("CloseSingleConnection")) {
            String clientID = maintenanceMsg.replace("CloseSingleConnection", "");
            this.closeConnection(clientID);
        } else if (maintenanceMsg.startsWith("UpdateSingleClient")) {
            String clientID = maintenanceMsg.replace("UpdateSingleClient", "");
            this.updateClient(clientID);
        } else if (maintenanceMsg.startsWith("CloseAllConnections")) {
            this.closeAllConnections();
        } else if (maintenanceMsg.startsWith("UpdateAllClients")) {
            this.updateAllClients();
        } else if (maintenanceMsg.startsWith("UpdateServerCache")) {
            this.updateServerCache();
        } else {
            log.error((Object)("JMS Message unknown: " + maintenanceMsg));
        }
    }

    private void updateServerCache() {
        log.debug((Object)"AirportMapMaintenance: Server cache will be updated!");
        this.clientFactory.unitBulkData.updateBulkData();
    }

    private void updateAllClients() {
        log.debug((Object)"AirportMapMaintenance: All clients will be updated!");
        ConcurrentHashMap<String, ObservableClient> clientPool = this.clientFactory.getObservableClientPoolByUserName();
        Iterator it = clientPool.values().iterator();
        while (it.hasNext()) {
            ((ObservableClient)it.next()).getObservableUnitsClient().scheduleNextUpdateThread(true);
        }
    }

    private void closeAllConnections() {
        log.debug((Object)"AirportMapMaintenance: All airport map connections will be closed!");
        ConcurrentHashMap<String, ObservableClient> clientPool = this.clientFactory.getObservableClientPoolByUserName();
        Iterator it = clientPool.values().iterator();
        while (it.hasNext()) {
            ((ObservableClient)it.next()).setMarkedForShutdown(true);
        }
    }

    private void updateClient(String clientID) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("AirportMapMaintenance: Client " + clientID + " will be updated!"));
        }
        ConcurrentHashMap<String, ObservableClient> clientPool = this.clientFactory.getObservableClientPoolByUserName();
        try {
            ((ObservableClient)clientPool.get(clientID)).getObservableUnitsClient().scheduleNextUpdateThread(true);
        }
        catch (Exception e) {
            log.error((Object)"Client ID doesn't exist!");
        }
    }

    private void closeConnection(String clientID) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("AirportMapMaintenance: Client " + clientID + " will be closed!"));
        }
        ConcurrentHashMap<String, ObservableClient> clientPool = this.clientFactory.getObservableClientPoolByUserName();
        try {
            ((ObservableClient)clientPool.get(clientID)).setMarkedForShutdown(true);
        }
        catch (NullPointerException e) {
            log.error((Object)"Client ID doesn't exist!");
        }
    }
}

