/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.dataIn.observable.client;

import de.proveo.configurator.airportmap.AirportMapMonitorMBean;
import de.proveo.configurator.airportmap.AirportMapMonitorUtil;
import de.proveo.util.observable.interfaces.PingThreadListener;
import de.proveo.util.threadPool.ThreadPool;
import de.proveo.wwt.logic.ejb.dataIn.informant.InformantClient;
import de.proveo.wwt.logic.servlet.dataIn.observable.ObservableClientServlet;
import de.proveo.wwt.logic.servlet.dataIn.observable.client.ObservableClient;
import de.proveo.wwt.logic.servlet.dataIn.observable.client.RemoteClient;
import de.proveo.wwt.logic.servlet.dataIn.observable.client.services.AirportMapMaintenance;
import de.proveo.wwt.logic.servlet.dataIn.observable.client.services.AirportmapStatusChangeProvider;
import de.proveo.wwt.logic.servlet.dataIn.observable.data.GSEDataUtil;
import de.proveo.wwt.logic.servlet.dataIn.observable.data.UnitBulkData;
import de.proveo.wwt.logic.servlet.dataIn.observable.threads.pool.ClientPingRunnableObj;
import de.proveo.wwt.logic.servlet.dataIn.observable.threads.pool.MapTimerTask;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.management.MalformedObjectNameException;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObservableClientFactory
implements PingThreadListener {
    private static ObservableClientFactory observableClientFactory = null;
    private final Log log = LogFactory.getLog(ObservableClientFactory.class);
    private InformantClient informantClient = null;
    private ConcurrentHashMap<String, ObservableClient> observableClientPoolByClientID = null;
    private ConcurrentHashMap<String, ObservableClient> observableClientPoolByUserName = null;
    private boolean sendAllStands = true;
    private boolean sendAllUnits = true;
    public UnitBulkData unitBulkData = null;
    private ThreadPool threadpool = null;
    private AirportmapStatusChangeProvider AirportmapStatusChangeProvider = null;
    private AirportMapMaintenance airportMapMaintenance = null;
    private static final ReentrantLock lock = new ReentrantLock();
    private AirportMapMonitorMBean airportMapMonitorMBean = null;
    private static final String THREAD_POOL_ID = "ObservableClientFactory";
    private Timer pingTimer = null;
    private static long periodTimestampPing = 900000L;

    private ObservableClientFactory() {
        this.log.debug((Object)"Constructor ObservableClientfactory invoked.");
        this.informantClient = new InformantClient();
        this.AirportmapStatusChangeProvider = new AirportmapStatusChangeProvider(this);
        this.airportMapMaintenance = new AirportMapMaintenance(this);
        this.observableClientPoolByClientID = new ConcurrentHashMap();
        this.observableClientPoolByUserName = new ConcurrentHashMap();
        try {
            this.airportMapMonitorMBean = AirportMapMonitorUtil.getMBean();
        }
        catch (MalformedObjectNameException e) {
            this.log.error((Object)"ObservableClientFactory has caused a MalformedObjectNameException", (Throwable)e);
        }
        this.unitBulkData = new UnitBulkData(this.createSelector("units,notify_messages,use_messages,infoman_messages"));
        this.threadpool = new ThreadPool(10, THREAD_POOL_ID);
        GSEDataUtil gseDataUtil = new GSEDataUtil();
        periodTimestampPing = Long.parseLong(gseDataUtil.getParameter("observable.pingthread.timeStamp", null));
        this.startTimestampTimer();
    }

    public boolean createObserverClient(ObservableClientServlet parentServletThread, String clientName, String username, String password, long unitGroupId, RemoteClient remoteClient) throws NullPointerException {
        this.log.debug((Object)("ObserverClientFactory.createObserverClient(): Creating new OberserverClient... FactoryInstance: " + this.toString()));
        ObservableClient observableClient = this.observableClientPoolByClientID.get(clientName);
        if (observableClient != null) {
            this.log.debug((Object)("ObservableClient with name " + clientName + " already exists. Use existing one!"));
            return false;
        }
        this.log.debug((Object)("ObservableClient with name " + clientName + " unknown. Create new instance..."));
        observableClient = this.createObserverClientJMSReceiver(clientName, parentServletThread, username, password, unitGroupId, remoteClient);
        if (observableClient == null) {
            throw new NullPointerException("ObserverClient is null!");
        }
        observableClient.setClient(remoteClient);
        this.observableClientPoolByClientID.put(clientName, observableClient);
        this.observableClientPoolByUserName.put(clientName, observableClient);
        this.airportMapMonitorMBean.setAirportMapUser(clientName, observableClient.getClient().getProperties());
        if (this.sendAllUnits) {
            this.log.debug((Object)("Sending all Units from ObservableClient-Instance: " + observableClient.toString()));
            observableClient.observableUnitsClient.sendAllStampsToClient();
        }
        if (this.sendAllStands) {
            observableClient.observableStandsClient.sendAllStandsToClient();
        }
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("************ pingServerTime createObservableClient() **********" + observableClient.getUsername()));
            }
            observableClient.pingServerTime(System.currentTimeMillis());
        }
        catch (JMSException e) {
            this.log.error((Object)("createObserverClient() - pingServerTime() ends in JMSException: " + (Object)((Object)e)));
        }
        this.log.debug((Object)"ObserverClientFactory.createObserverClient(): OberserverClient created!");
        return true;
    }

    private ObservableClient createObserverClientJMSReceiver(final String clientName, final ObservableClientServlet servlet, final String username, final String password, final long unitGroupId, final RemoteClient remoteClient) {
        this.sendAllUnits = true;
        this.sendAllStands = true;
        this.log.debug((Object)"createObserverClientJMSReceiver() entered.");
        try {
            String selector;
            InitialContext ctx = new InitialContext();
            Topic topic = null;
            TopicSession session = null;
            TopicSubscriber subscriber = null;
            TopicConnectionFactory fact = (TopicConnectionFactory)ctx.lookup("ConnectionFactory");
            final TopicConnection connect = fact.createTopicConnection();
            connect.setExceptionListener(new ExceptionListener(){
                public static final int NUM_RETRIES = 3;
                boolean exceptionFlag = false;

                public synchronized void onException(JMSException ex) {
                    if (this.exceptionFlag) {
                        return;
                    }
                    this.exceptionFlag = true;
                    for (int i = 0; i < 3; ++i) {
                        ObservableClientFactory.this.log.warn((Object)("Connection has problems, trying to re-create it, attempt " + (i + 1) + " ..."));
                        try {
                            connect.close();
                        }
                        catch (Exception e2) {
                            ObservableClientFactory.this.log.error((Object)"ExceptionLister is not able to close the connection!");
                        }
                        ObservableClient observableClient = ObservableClientFactory.this.createObserverClientJMSReceiver(clientName, servlet, username, password, unitGroupId, remoteClient);
                        if (observableClient.isReconnected()) {
                            ObservableClientFactory.this.log.info((Object)"Connection re-established");
                            return;
                        }
                        ObservableClientFactory.this.log.warn((Object)"Re-creating connection failed, retrying ...");
                    }
                }
            });
            session = connect.createTopicSession(false, 2);
            try {
                topic = (Topic)ctx.lookup("topic/proveoDataProviderTopic");
            }
            catch (NameNotFoundException ex) {
                topic = session.createTopic("topic/proveoDataProviderTopic");
                ctx.bind("topic/proveoDataProviderTopic", (Object)topic);
            }
            ObservableClient observableClient = new ObservableClient(clientName, servlet, username, password, this.unitBulkData, this.threadpool, unitGroupId);
            observableClient.selector = selector = this.getSelector(remoteClient);
            String typeOfClientInterest = remoteClient.getProperties().getProperty("TypeOfInterest", "");
            if (typeOfClientInterest.indexOf("units") == -1) {
                this.sendAllUnits = false;
            }
            if (typeOfClientInterest.indexOf("stands") == -1) {
                this.sendAllStands = false;
            }
            subscriber = session.createSubscriber(topic, selector, true);
            observableClient.getJmsClient().setSession(session);
            observableClient.getJmsClient().setConnect(connect);
            observableClient.getJmsClient().setCtx(ctx);
            observableClient.getJmsClient().setSubscriber(subscriber);
            observableClient.getJmsClient().setTopic(topic);
            subscriber.setMessageListener((MessageListener)observableClient);
            connect.start();
            this.log.debug((Object)"createObserverClient(): MessageListener set!");
            observableClient.setReconnected(true);
            return observableClient;
        }
        catch (NamingException e) {
            this.log.error((Object)("createObserverClient() ends in NamingException: " + e));
            this.informantClient.notify("createObserverClient() ends in NamingException: " + e, "ServerErrorEvent");
        }
        catch (JMSException e) {
            this.log.error((Object)("createObserverClient() ends in JMSException: " + (Object)((Object)e)));
            this.informantClient.notify("createObserverClient() ends in JMSException: " + (Object)((Object)e), "ServerErrorEvent");
        }
        return null;
    }

    private String createSelector(String selectorValues) {
        String selector = "";
        if (!selectorValues.equals("")) {
            StringTokenizer tokenizer = new StringTokenizer(selectorValues, ",");
            boolean standsSelected = false;
            boolean unitsSelected = false;
            boolean errorSelected = false;
            while (tokenizer.hasMoreTokens()) {
                String nextToken = tokenizer.nextToken().trim();
                if (nextToken.equals("units")) {
                    if (!selector.equals("")) {
                        selector = selector + " OR ";
                    }
                    selector = selector + this.getSelectorString("KeepAlive") + " OR " + this.getSelectorString("GeoStructHistoryAndCache") + " OR " + this.getSelectorString("StateEventHistoryAndCache");
                    unitsSelected = true;
                    continue;
                }
                if (nextToken.equals("stands")) {
                    if (!selector.equals("")) {
                        selector = selector + " OR ";
                    }
                    selector = selector + this.getSelectorString("AllStandData") + " OR " + this.getSelectorString("StandEvent") + " OR " + this.getSelectorString("AllocationEvent");
                    standsSelected = true;
                    continue;
                }
                if (nextToken.equals("notify_messages")) {
                    if (!selector.equals("")) {
                        selector = selector + " OR ";
                    }
                    selector = selector + this.getSelectorString("InfomanNotifyMessages");
                    continue;
                }
                if (nextToken.equals("use_messages")) {
                    if (!selector.equals("")) {
                        selector = selector + " OR ";
                    }
                    selector = selector + this.getSelectorString("UseEvent");
                    continue;
                }
                if (nextToken.equals("infoman_messages")) {
                    if (!selector.equals("")) {
                        selector = selector + " OR ";
                    }
                    selector = selector + this.getSelectorString("InfomanMessages");
                    continue;
                }
                if (nextToken.equals("server_errors")) {
                    errorSelected = true;
                    continue;
                }
                if (!selector.equals("")) {
                    selector = selector + " OR " + this.getSelectorString(nextToken);
                    this.log.warn((Object)("Unidentified selector given: " + nextToken));
                    continue;
                }
                selector = this.getSelectorString(nextToken);
                this.log.warn((Object)("Unidentified selector given: " + nextToken));
            }
            selector = this.addErrorMsgSelectors(selector, standsSelected, unitsSelected, errorSelected);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Topic selector: " + selector));
            }
        }
        return selector;
    }

    private String addErrorMsgSelectors(String selector, boolean standsSelected, boolean unitsSelected, boolean errorSelected) {
        if (standsSelected && unitsSelected && errorSelected) {
            selector = selector + " OR " + this.getSelectorString("ServerErrorEvent") + " OR " + this.getSelectorString("StandErrorEvent") + " OR " + this.getSelectorString("UnitErrorEvent");
        } else if (unitsSelected && errorSelected) {
            selector = selector + " OR " + this.getSelectorString("ServerErrorEvent") + " OR " + this.getSelectorString("UnitErrorEvent");
        } else if (standsSelected && errorSelected) {
            selector = selector + " OR " + this.getSelectorString("ServerErrorEvent") + " OR " + this.getSelectorString("StandErrorEvent");
        }
        return selector;
    }

    public void removeClient(String clientName) {
        ObservableClient observableClient = this.observableClientPoolByClientID.get(clientName);
        if (observableClient != null) {
            this.observableClientPoolByClientID.remove(clientName);
            this.observableClientPoolByUserName.remove(clientName);
            this.airportMapMonitorMBean.removeAirportMapUser(clientName);
            this.log.debug((Object)("ObservableClient " + clientName + " removed --> " + observableClient.toString()));
        } else {
            this.log.warn((Object)("No ObservableClient registered with name " + clientName));
        }
    }

    private String getSelector(RemoteClient remoteClient) {
        return this.createSelector(remoteClient.getProperties().getProperty("TypeOfInterest", ""));
    }

    public String getSelectorString(String selectionItem) {
        return "TypeOfInterest='" + selectionItem + "'";
    }

    public ConcurrentHashMap<String, ObservableClient> getObservableClientPoolByClientID() {
        return this.observableClientPoolByClientID;
    }

    public ConcurrentHashMap<String, ObservableClient> getObservableClientPoolByUserName() {
        return this.observableClientPoolByUserName;
    }

    public ObservableClient getObservableClientByClientID(String clientID) {
        return this.observableClientPoolByClientID.get(clientID);
    }

    protected ObservableClient getObservableClientByUserName(String userName) {
        return this.observableClientPoolByUserName.get(userName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObservableClientFactory getInstance() {
        if (observableClientFactory == null) {
            lock.lock();
            try {
                if (observableClientFactory == null) {
                    observableClientFactory = new ObservableClientFactory();
                }
            }
            finally {
                lock.unlock();
            }
        }
        return observableClientFactory;
    }

    protected void finalize() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("finalize(): Object " + this.toString() + " deleted by garbage collector!"));
        }
    }

    public void ping() throws JMSException {
        long currentServerTime = System.currentTimeMillis();
        for (Map.Entry<String, ObservableClient> entry : this.observableClientPoolByClientID.entrySet()) {
            ObservableClient observableClient = entry.getValue();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("************ pingServerTime ping() **********  " + observableClient.getUsername()));
            }
            if (observableClient == null) continue;
            observableClient.pingServerTime(currentServerTime);
        }
    }

    private void startTimestampTimer() {
        ClientPingRunnableObj clientPingRunnableObj = new ClientPingRunnableObj(this);
        MapTimerTask mapClientUpdater = new MapTimerTask(this.threadpool, clientPingRunnableObj);
        this.pingTimer = new Timer();
        this.pingTimer.scheduleAtFixedRate((TimerTask)mapClientUpdater, 10000L, periodTimestampPing);
    }

    public void cleanUp() {
    }

    public String getClientName() {
        return "";
    }

    public void setMarkedForShutdown(boolean markedForShutdown) {
    }
}

