/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.dataIn.event.udp;

import de.proveo.rts.configuration.infoman.InfomanEventInterfaceMBean;
import de.proveo.rts.configuration.infoman.InfomanEventInterfaceUtil;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationClient;
import de.proveo.wwt.logic.servlet.dataIn.event.AbstractEventServlet;
import de.proveo.wwt.logic.servlet.dataIn.event.udp.Filter;
import de.proveo.wwt.logic.servlet.dataIn.event.udp.UDPEventWorker;
import de.proveo.wwt.logic.servlet.dataIn.event.udp.UDPWorkerThread;
import java.net.DatagramSocket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UDPServlet
extends AbstractEventServlet
implements Thread.UncaughtExceptionHandler {
    private static final Log log = LogFactory.getLog(UDPServlet.class);
    private static final long serialVersionUID = 4991102150040996084L;
    private final Filter filter = new Filter();
    private final ThreadGroup threadGroup = new ThreadGroup("UDP worker threads");
    private final Collection<UDPWorkerThread> workerThreads = new ArrayList<UDPWorkerThread>();
    private InfomanEventInterfaceMBean config;
    private DatagramSocket socket;

    public void init(ServletConfig config) throws ServletException {
        log.trace((Object)"init()");
        super.init(config);
        try {
            this.config = InfomanEventInterfaceUtil.getMBean();
            if (new ConfigurationClient().getBoolean("infoman.event.udp")) {
                this.initUDPserver();
            }
        }
        catch (Exception ex) {
            log.error((Object)"runs during init Infoman UDP Event Protocol into", (Throwable)ex);
        }
    }

    public void destroy() {
        Iterator<UDPWorkerThread> it = this.workerThreads.iterator();
        while (it.hasNext()) {
            it.next().getWorker().stop();
        }
        if (this.socket != null) {
            this.socket.close();
        }
        this.workerThreads.clear();
    }

    protected boolean isDisabled() {
        return this.config.isUDPEventsDisabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uncaughtException(Thread t, Throwable e) {
        if (log.isErrorEnabled()) {
            log.error((Object)("Thread " + t.getName() + " has stoped, runs into"), e);
        }
        Collection<UDPWorkerThread> collection = this.workerThreads;
        synchronized (collection) {
            if (this.workerThreads.remove(t)) {
                this.poolSizeUpdate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void poolSizeUpdate() {
        Collection<UDPWorkerThread> collection = this.workerThreads;
        synchronized (collection) {
            int diff = this.config.getUDPThreadPoolSize() - this.workerThreads.size();
            if (diff > 0) {
                for (int index = 0; index < diff; ++index) {
                    try {
                        this.createUDPWorkerThread();
                        continue;
                    }
                    catch (Exception ex) {
                        log.error((Object)"runs during create a new UDPWorkerThread into", (Throwable)ex);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isPoolToLarge() {
        Collection<UDPWorkerThread> collection = this.workerThreads;
        synchronized (collection) {
            return this.config.getUDPThreadPoolSize() - this.workerThreads.size() < 0;
        }
    }

    public void initUDPserver() throws ServletException {
        log.trace((Object)"initUDPserver()");
        try {
            this.socket = new DatagramSocket(this.config.getUDPPort());
        }
        catch (Exception ex) {
            throw new ServletException((Throwable)ex);
        }
        try {
            int workerThreadCount = this.config.getUDPThreadPoolSize();
            for (int index = 0; index < workerThreadCount; ++index) {
                this.createUDPWorkerThread();
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Infoman UDP Event Server started. " + workerThreadCount + " worker threads started."));
            }
        }
        catch (Exception ex) {
            throw new ServletException((Throwable)ex);
        }
    }

    protected void createUDPWorkerThread() {
        UDPEventWorker worker = new UDPEventWorker(this.socket, this, this.filter);
        UDPWorkerThread workerThread = new UDPWorkerThread(this.threadGroup, worker, "UDPworker" + worker.getInstanceNumber());
        workerThread.start();
        this.workerThreads.add(workerThread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void workerThreadStoped(UDPWorkerThread workerThread) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Thread " + workerThread.getName() + " has stoped"));
        }
        Collection<UDPWorkerThread> collection = this.workerThreads;
        synchronized (collection) {
            if (this.workerThreads.remove(workerThread)) {
                this.poolSizeUpdate();
            }
        }
    }
}

